//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;


/**
 * The element layout for a Template.
 * 
 * @author Kelvin Low
 * @author Jinhua Xi
 * @since 1.0
 */
public class TemplateLayout extends AbstractElementLayout {

	public TemplateLayout() {
		super();
	}

	public void init(ElementLayoutManager layoutManager, MethodElement element) {
		super.__init(layoutManager, element);
	}

	public XmlElement getXmlElement(boolean includeReferences) {
		XmlElement elementXml = super.getXmlElement(includeReferences);

		if (includeReferences) {
			List contentElements = ConfigurationHelper.calc0nFeatureValue(super.element,
					AssociationHelper.Template_WorkProducts, layoutManager
							.getElementRealizer());
			addReferences(AssociationHelper.Template_WorkProducts, elementXml, "contentElements", contentElements); //$NON-NLS-1$

			Template template = (Template) super.element;
			ContentDescription content = (ContentDescription) template
					.getPresentation();
			if (content != null) {
				
				// RATLC00385127 - Authoring:  Template attachments of a contributing template guidance element are not appended to the base list of attachments				
				//String attachmentString = ((org.eclipse.epf.uma.GuidanceDescription)content).getAttachments();
				EStructuralFeature feature = UmaPackage.eINSTANCE.getGuidanceDescription_Attachments();
				String attachmentString = (String)ConfigurationHelper.calcAttributeFeatureValue(content, super.element, feature, super.layoutManager.getConfiguration());
				if ( (attachmentString != null) && (attachmentString.indexOf(ConfigurationHelper.ATTRIBUTE_VALUE_SEPERATOR) > 0) )
				{
					attachmentString = attachmentString.replaceAll(ConfigurationHelper.ATTRIBUTE_VALUE_SEPERATOR, TngUtil.TEMPLATE_FILESTRING_SEPARATOR); 
				}
				List attachmentList = TngUtil.convertTemplateAttachmentsToList(attachmentString);
				for (Iterator iter = attachmentList.iterator();iter.hasNext();) {
					String templateFile = (String) iter.next();
					if (templateFile != null) {
						String fileName = FileUtil.getFileName(templateFile);
						elementXml.newChild("attribute").setAttribute("name", //$NON-NLS-1$ //$NON-NLS-2$
								"templateFile").setAttribute( //$NON-NLS-1$
								"url", "file://" + templateFile) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								.setAttribute("fileName", fileName); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}
				}
			}
		}

		return elementXml;
	}


}
