//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.layout.elements;

import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;


public class WorkProductDescriptorLayout extends DescriptorLayout {

	public void init(ElementLayoutManager layoutManager, MethodElement element) {
		super.__init(layoutManager, element);
	}

	public void loadReferences(XmlElement elementXml, boolean includeReferences) {

		super.loadReferences(elementXml, includeReferences);
		
		if ( layoutManager.getValidator().showExtraInfoForDescriptors() ) {
			// also load the linked element referenced information
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getWorkProduct_EstimationConsiderations(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getWorkProduct_Reports(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getWorkProduct_Templates(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getWorkProduct_ToolMentors(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Assets(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Checklists(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Examples(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_Guidelines(), elementXml, false);
			super.elementLayout.loadFeature(UmaPackage.eINSTANCE.getContentElement_SupportingMaterials(), elementXml, false);
		}
	}
}
