//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.preferences;

import org.eclipse.epf.library.LibraryPlugin;

/**
 * The Library preferences.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class LibraryPreferences {

	/**
	 * The Library preference keys prefix.
	 */
	public static final String PREFIX = "library."; //$NON-NLS-1$	

	/**
	 * The backup before save preference key.
	 */
	public static final String BACKUP_BEFORE_SAVE = PREFIX + "backupBeforeSave"; //$NON-NLS-1$

	/**
	 * The discard unresolved references preference key.
	 */
	public static final String DISCARD_UNRESOLVED_REFERENCES = PREFIX
			+ "discardUnresolvedReferences"; //$NON-NLS-1$

	/**
	 * Returns the backup before save preference.
	 */
	public static boolean getBackupBeforeSave() {
		return LibraryPlugin.getDefault().getPreferenceStore().getBoolean(
				BACKUP_BEFORE_SAVE);
	}

	/**
	 * Saves the backup before save preference.
	 */
	public static void setBackupBeforeSave(boolean value) {
		LibraryPlugin.getDefault().getPreferenceStore().setValue(
				BACKUP_BEFORE_SAVE, value);
	}

	/**
	 * Returns the discard unresolved references preference.
	 */
	public static boolean getDiscardUnresolvedReferences() {
		return LibraryPlugin.getDefault().getPreferenceStore().getBoolean(
				DISCARD_UNRESOLVED_REFERENCES);
	}

	/**
	 * Saves the discard unresolved references preference.
	 */
	public static void setDiscardUnresolvedReferences(boolean value) {
		LibraryPlugin.getDefault().getPreferenceStore().setValue(
				DISCARD_UNRESOLVED_REFERENCES, value);
	}

}
