//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;


/**
 * @author Jinhua Xi
 * @since 1.0
 */
public class ElementReference {

	Object element, refElement;

	public ElementReference(Object element, Object refElement) {
		this.element = element;
		this.refElement = refElement;
	}

	public Object getElement() {
		return element;
	}

	public Object getRefElement() {
		return refElement;
	}

	public void print() {
		System.out
				.println("    " + LibraryUtil.getName(element) + " --> " + LibraryUtil.getName(refElement)); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * check if the reference can be ignored
	 * 
	 * @return boolean
	 */
	public boolean canIgnore() {
		// if the element has no container, it's a deleted element, ignore it
		if ((element instanceof EObject)
				&& ((EObject) element).eContainer() == null
				|| (refElement instanceof EObject)
				&& ((EObject) refElement).eContainer() == null) {
			return true;
		}

		// RATLC00382739 - Don't warn on optional inputs not being present
		// so added the canIgnore() method
		if ((element instanceof Task) && (refElement instanceof WorkProduct)) {
			// if it's a mandatory input, can ignore
			if (((Task) element).getMandatoryInput().contains(refElement)) {
				return false;
			}

			// not mandatory, but optional, ok, ignore it
			if (((Task) element).getOptionalInput().contains(refElement)) {
				return true;
			}
		}

		// role's modifies feature is actually a dereived opposite feature,
		// it's value can be an element not visible to this plugin
		// ignore it
		// RATLC00383792 - Invalid configuration dependency error reported
		if ((element instanceof Role) && (refElement instanceof WorkProduct)) {
			Role r = (Role) element;
			if (r.getModifies().contains(refElement)
					&& !r.getResponsibleFor().contains(refElement)) {
				return true;
			}
		}

		return false;
	}

}
