//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.services;

import java.util.Iterator;

/**
 * Holds the a list of package references of one package element it also holds a
 * list of dependant package elements.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class PackageDependency extends ElementDependency {

	private boolean loaded = false;

	public PackageDependency(Object element) {
		super(element);
	}

	public void setLoaded(boolean loaded) {
		this.loaded = loaded;
	}

	public boolean isLoaded() {
		return this.loaded;
	}

	public PackageReference getReference(Object refElement, boolean create) {
		PackageReference ref = (PackageReference) super
				.getReference(refElement);
		if (ref == null && create) {
			ref = new PackageReference(element, refElement);
			super.addReference(ref);
		}

		return ref;
	}

	public void removeReference(Object ownerElement) {
		PackageReference ref;
		for (Iterator it = super.getReferences().iterator(); it.hasNext();) {
			ref = (PackageReference) it.next();
			ref.removeReference(ownerElement);
		}
	}

	public void print() {
		super.print();
	}

}
