//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.library.services;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.epf.uma.MethodElement;


/**
 * This class holds all the variable elements (contributors, replacers) of the
 * specified base element. and provide methods to calculate the final output.
 * 
 * @author Jinhua Xi
 * @since 1.0
 */
public class VariableElementList {

	private List variables = new ArrayList();

	public VariableElementList(MethodElement baseElement) {
	}

	public void addVariableElement(MethodElement variable) {
		if (!variables.contains(variable)) {
			variables.add(variable);
		}
	}

	public void removeVariableElement(MethodElement variable) {
		if (variables.contains(variable)) {
			variables.remove(variable);
		}
	}

	public Object[] getVariableElements() {
		return variables.toArray();
	}

	public int size() {
		return variables.size();
	}

}
