//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publisher;

import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.osgi.framework.BundleContext;

/**
 * The EPF publisher plugin. 
 * 
 * @author Jinhua Xi
 * @since 1.0
 *
 */
public class PublisherPlugin extends AbstractPlugin {

	// The plug-in ID.
	public static final String PLUGIN_ID = PublisherPlugin.class.getName();
	
	// The shared plug-in instance.
	private static PublisherPlugin plugin;
	
	/**
	 * Default constructor.
	 */
	public PublisherPlugin() {
		super();
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation.
	 * 
	 * @see org.eclipse.epf.uma.core.plugin.AbstractPlugin#start(BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped.
	 * 
	 * @see org.eclipse.epf.uma.core.plugin.AbstractPlugin#start(BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared plug-in instance.
	 */
	public static PublisherPlugin getDefault() {
		return plugin;
	}


}
