/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.epf.publishing.ui;

import org.eclipse.osgi.util.NLS;

public final class PublishingUIResources extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.epf.publishing.ui.Resources";//$NON-NLS-1$

	private PublishingUIResources() {
		// Do not instantiate
	}

	public static String publishConfigWizard_title;
	public static String publishConfigWizard_selectConfigPage_title;
	public static String publishConfigWizard_selectConfigPage_text;
	public static String publishConfigWizard_selectOptionsPage_title;
	public static String publishConfigWizard_selectOptionsPage_text;
	public static String publishConfigWizard_methodConfig_text;
	public static String publishConfigWizard_destinationGroup_text;
	public static String publishConfigWizard_directory_text;
	public static String publishConfigWizard_useDefaultPath_text;
	public static String publishConfigWizard_webSite_text;
	public static String publishConfigWizard_title_text;
	public static String publishConfigWizard_bannerImage_text;
	public static String publishConfigWizard_aboutHTML_text;
	public static String publishConfigWizard_feedbackURL_text;
	public static String publishConfigWizard_includeIndex_text;
	public static String publishConfigWizard_includeGlossary_text;
	public static String publishConfigWizard_includeSearch_text;
	public static String publishConfigWizard_useApplet_text;
	public static String publishConfigWizard_validationGroup_text;
	public static String publishConfigWizard_checkHyperlinks_text;
	public static String publishConfigWizard_diagramGroup_text;
	public static String publishConfigWizard_publish_unopen_activity_dd_text;
	public static String publishConfigWizard_publish_extend_activity_diagram;
	public static String publishConfigWizard_convertBrokenLinks_text;
	public static String publishConfigWizard_layout_text;
	public static String publishConfigWizard_extraDescriptorInfo_text;
	public static String publishConfigWizard_lightWeightTree_text;
	public static String publishConfigWizard_includeEmptyCategories_text;
	
	public static String PublishConfigSelectProcessPage_title;
	public static String PublishConfigSelectProcessPage_text;
	public static String PublishConfigSelectProcessPage_label_capability_pattern;
	public static String PublishConfigSelectProcessPage_label_delivery_process;
	public static String PublishConfigSelectProcessPage_label_selectType;
	public static String PublishConfigSelectProcessPage_label_type_processes;
	public static String PublishConfigSelectProcessPage_label_type_config;
	public static String PublishConfigSelectProcessPage_label_publish_base_processes;
	public static String preferencePage_defaultPath_text;
	public static String publishConfigDialog_title;
	public static String confirmPathDialog_text;
	public static String overwriteDialog_text;
	public static String cancelPublishConfig_msg;
	public static String previewConfigError_title;
	public static String viewReportError_title;
	public static String missingViewError_msg;
	public static String cannotPublishError_msg;
	public static String invalidPathError_msg;
	public static String invalidPathCharsError_msg;
	public static String publishConfigError_msg;
	public static String previewConfigError_msg;
	public static String viewReportError_msg;
	public static String publishConfigError_reason;
	public static String deleteFilesError_reason;
	public static String createDirError_reason;
	public static String openBrowserError_reason;

	static {
		NLS.initializeMessages(BUNDLE_NAME, PublishingUIResources.class);
	}
	
	/**
	 * Returns the localized string associated with a resource key and formatted
	 * with a given object.
	 * 
	 * @param key
	 *            A resource key.
	 * @param data
	 *            An object.
	 * @return A formatted localized string.
	 */
	public static String bind(String key, Object data) {
		return NLS.bind(key, new Object[] { data });
	}
}