//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.ui.actions;

import java.util.Iterator;
import java.util.List;

import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.prefs.LibraryPreferenceConstants;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublisherElement;
import org.eclipse.epf.publishing.ui.PublisherFactory;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.wizards.AbstractPublishWizard;
import org.eclipse.epf.publishing.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.publishing.wizards.PublishingOperation;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/**
 * Invokes the Publish Method Configuration wizard.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @author Jinhua Xi
 * @since 1.0
 * 
 * TODO: Rename this class to PublishConfigurationAction
 */
public class Publish implements IWorkbenchWindowActionDelegate {

	private IStructuredSelection selection;

	private PublishOptions publishDataModel;

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		
		if ( !(action instanceof PublishAction) ) {
			return;
		}
		
		try {
			String id = ((PublishAction)action).getId();
			PublisherElement e = PublisherFactory.getInstance().getPublisherElement(id);		
			if ( e == null ) {
				// show error and return
				return;
			}
			
			startPublish(e);
	
		} catch (Exception ex ) {
			PublishingUIPlugin.getDefault().getLogger()
			.logError("Error publishing content", ex);	//$NON-NLS-1$
		}
	}
	

	private void startPublish(PublisherElement publisher) throws Exception {
	
//		PublishConfigurationWizard wizard = new PublishConfigurationWizard(
//		publishDataModel);
		AbstractPublishWizard wizard = publisher.getPublishWizard();
		wizard.init(PlatformUI.getWorkbench(), selection);
		publishDataModel = wizard.getPublishOptions();

		//publishDataModel = new PublishOptions();

		IPreferenceStore store = LibraryPlugin.getDefault()
				.getPreferenceStore();
		String lastPubPath = store
				.getString(LibraryPreferenceConstants.PREF_LAST_PUBLISH_FOLDER);
		if (lastPubPath != null && lastPubPath.length() > 0)
			publishDataModel.setLastPublicationPath(lastPubPath);

		// Instantiate the wizard container with the wizard and open it.
		WizardDialog dialog = new WizardDialog(Display.getCurrent()
				.getActiveShell(), wizard);
		dialog.create();
		dialog.open();

		if (!publishDataModel.isFinishPressed()) {
			return;
		}

		String publishDestFolder = publishDataModel.getPublicationPath();
		store.setValue(LibraryPreferenceConstants.PREF_LAST_PUBLISH_FOLDER,
				publishDestFolder);
		LibraryPlugin.getDefault().savePluginPreferences();

		AbstractPublishManager publishMgr = null;
		try {
			String selecedConfigName = publishDataModel.getSelectedConfig();
			MethodConfiguration config = LibraryServiceUtil
					.getMethodConfiguration(LibraryService.getInstance()
							.getCurrentMethodLibrary(), selecedConfigName);

			publishMgr = publisher.getPublishManager();
			publishMgr.init(publishDestFolder, config, publishDataModel);
			PublishingOperation operation = new PublishingOperation(publishMgr);

			PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(
					Display.getCurrent().getActiveShell(), publishMgr.getViewBuilder());

			UserInteractionHelper
					.runWithProgress(
							operation,
							dlg,
							true,
							PublishingUIResources.publishConfigWizard_title); //$NON-NLS-1$
		} finally {
			if (publishMgr != null) {
				publishMgr.dispose();
			}
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}

}
