//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.services;

import java.util.List;

/**
 * The Publishing Options.
 * 
 * @author Jinhua Xi
 * @author Kelvin Low
 * @since  1.0
 */
public class PublishOptions {
	
	// define the option names. will be used as preference keys
	public static final String PUBLISH_PATH = "publishPath"; //$NON-NLS-1$
	public static final String PUBLISH_PATH_DEFAULT = "publishPathDefault"; //$NON-NLS-1$
	public static final String TITLE = "title"; //$NON-NLS-1$
	public static final String BANNER_IMAGE = "bannerImage"; //$NON-NLS-1$
	public static final String ABOUT_HTML = "aboutHTML"; //$NON-NLS-1$
	public static final String FEEDBACK_URL = "feedbackURL"; //$NON-NLS-1$	
	public static final String FEEDBACK_URL_DEFAULT = "feedbackURLDefault"; //$NON-NLS-1$
	public static final String INCLUDE_GLOSSARY = "includeGlossary"; //$NON-NLS-1$
	public static final String INCLUDE_INDEX = "includeIndex"; //$NON-NLS-1$
//	public static final String INCLUDE_SEARCH = "includeSearch"; //$NON-NLS-1$
//	public static final String INCLUDE_PROCESS_CUSTOMIZATION = "includeProcessCustomization"; //$NON-NLS-1$	
	public static final String CHECK_EXTERNAL_LINKS = "checkExternalLinks"; //$NON-NLS-1$

	
	public static final int ALL_INPUT_WP = 1;
	public static final int MANDATORY_INPUT_WP = 2;
	public static final int MANDATORY_AND_EXTERNAL_INPUT_WP = 3;

	public String publicationPath;
	public boolean isFinishPressed;
	public String lastPublicationPath;
	public String selectedConfig;	
	public boolean publishConfiguration;
	public boolean publishProcess;
	public String title;
	public String bannerImage;
	public String aboutHTML;	
	public String feedbackURL;
	public boolean generateGlossary;
	public boolean generateIndex;
//	public boolean generateSearchDB;
//	public boolean useApplet;
	public boolean useDefaultTreeBrowser = true; // this is the default javascript navigation tree
	public boolean checkExtLinks = false;
	public int inputWPShown;
	public boolean onlyUsed;
	public boolean autoGenerateActivityDiagrams = false;
	public boolean publishUnOpenExtendedActivityDiagram = false;
	
	public List deliverProcessList;
	public boolean convertBrokenLinks = false; // convert broken links to plain text
	public boolean showExtraDescriptorInfo = false;
	public boolean generateLightWeightTree = false;
	
	// this option is not approved, so should be ALWAYS false
	public boolean includeEmptyCategories = false;
	
	public String getPublicationPath() {
		return publicationPath;
	}
	
	public void setPublicationPath(String publicationPath) {
		this.publicationPath = publicationPath;
	}
	
	public boolean isFinishPressed() {
		return isFinishPressed;
	}
	
	public void setFinishPressed(boolean isFinishPressed) {
		this.isFinishPressed = isFinishPressed;
	}
	
	public String getLastPublicationPath() {
		return lastPublicationPath;
	}
	
	public void setLastPublicationPath(String lastPublicationPath) {
		this.lastPublicationPath = lastPublicationPath;
	}
	
	public String getSelectedConfig() {
		return selectedConfig;
	}
	
	public void setSelectedConfig(String selectedConfig) {
		this.selectedConfig = selectedConfig;
	}
	
	public boolean isPublishConfiguration() {
		return publishConfiguration;
	}
	
	public void setPublishConfiguration(boolean publishConfiguration) {
		this.publishConfiguration = publishConfiguration;
	}
	
	public boolean isPublishProcess() {
		return publishProcess;
	}
	
	public void setPublishProcess(boolean publishProcess) {
		this.publishProcess = publishProcess;
	}
	
	public String getTitle() {
		return title;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getBannerImage() {
		return bannerImage;
	}
	
	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}
	
	public String getAboutHTML() {
		return aboutHTML;
	}
	
	public void setAboutHTML(String aboutHTML) {
		this.aboutHTML = aboutHTML;
	}	
	
	public String getFeedbackURL() {
		return feedbackURL;
	}
	
	public void setFeedbackURL(String feedbackURL) {
		this.feedbackURL = feedbackURL;
	}
	
	public boolean isGenerateGlossary() {
		return generateGlossary;
	}
	
	public void setGenerateGlossary(boolean generateGlossary) {
		this.generateGlossary = generateGlossary;
	}
	
	public boolean isGenerateIndex() {
		return generateIndex;
	}
	
	public void setGenerateIndex(boolean generateIndex) {
		this.generateIndex = generateIndex;
	}
	
//	public boolean isGenerateSearchDB() {
//		return generateSearchDB;
//	}
//	
//	public void setGenerateSearchDB(boolean generateSearchDB) {
//		this.generateSearchDB = generateSearchDB;
//	}
//	
//	public boolean isUseApplet() {
//		return useApplet;
//	}
//	
//	public void setUseApplet(boolean useApplet) {
//		this.useApplet = useApplet;
//	}
	
	public boolean isCheckExtLinks() {
		return checkExtLinks;
	}
	
	public void setCheckExtLinks(boolean checkExtLinks) {
		this.checkExtLinks = checkExtLinks;
	}

	public int getInputWPShown() {
		return inputWPShown;
	}
	
	public void setInputWPShown(int inputWPShown) {
		this.inputWPShown = inputWPShown;
	}
	
	public boolean isOnlyUsed() {
		return onlyUsed;
	}
	
	public void setOnlyUsed(boolean onlyUsed) {
		this.onlyUsed = onlyUsed;
	}
	
	public List getDeliverProcessList() {
		return deliverProcessList;
	}

	public void setDeliverProcessList(List deliverProcessList) {
		this.deliverProcessList = deliverProcessList;
	}

	public boolean isAutoGenerateActivityDiagrams() {
		return autoGenerateActivityDiagrams;
	}

	public void setAutoGenerateActivityDiagrams(boolean autoGenerateActivityDiagrams) {
		this.autoGenerateActivityDiagrams = autoGenerateActivityDiagrams;
	}
	
	public void validate() {
	}

	/**
	 * @return the unopenExtendedActivityDiagram
	 */
	public boolean isUnopenExtendedActivityDiagram() {
		return publishUnOpenExtendedActivityDiagram;
	}

	/**
	 * @param unopenExtendedActivityDiagram the unopenExtendedActivityDiagram to set
	 */
	public void setUnopenExtendedActivityDiagram(
			boolean flag) {
		this.publishUnOpenExtendedActivityDiagram = flag;
	}
}