//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.services.index;

/**
 * this class defines a key word
 *
 * @author Jinhua Xi
 * @since  1.0
 */
public class KeyWordDef {

	private String anchor;
	private String key;
	private String text;

	private String keyWordString;

	public KeyWordDef(String anchor)
	{
		this(anchor, null, null);
	}

	public KeyWordDef(String anchor, String key, String text)
	{
		this.anchor = anchor;
		this.key = key;
		this.text = text;
		
		if ( this.text == null )
		{
			this.text = "";
		}

		this.keyWordString = KeyWordStatic.convertKeyWord(this.anchor, this.key, this.text);
		if ( this.key == null || this.key.equals("") )
		{
			int index = this.keyWordString.indexOf(KeyWordIndexHelper.defObj.levelSeparatorReplace);
			if ( index < 0 )
			{
				this.key = this.keyWordString;
			}
			else
			{
				this.key = this.keyWordString.substring(0, index);
			}
		}
	}
	
	public String getAnchor()
	{
		return anchor;
	}
	
	public String getKey()
	{
		return key;
	}
	
	public String toString()
	{
		return keyWordString;
	}



}

