//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.services.search;

import java.io.File;
import org.apache.lucene.document.Document;

/**
 * This class provides methods to construct the proper type of
 * Lucene document given the file to parse. A example of a file
 * is a PDF document, HTML document, or Microsoft Word document. <br>
 *
 */
public class DocumentFactory
{
	/**
	 * Default constructor.
	 */
	private DocumentFactory()
	{
	}

	/**
	 * Retrieve a Lucene document that is constructed
	 * from the given file.
	 */
	public static Document document( File file )
	{
		Document luceneDocument = null;

		// determine file type and create the appropriate document type
		if( file.getName().endsWith( "htm" ) || //$NON-NLS-1$
		    file.getName().endsWith( "html" ) ) //$NON-NLS-1$
		{
			HTMLDocument htmlDocument = new HTMLDocument();
			luceneDocument = htmlDocument.document( file );
		}
		else
		{
//			PlainDocument plainDocument = new PlainDocument();
//			luceneDocument = plainDocument.document( file );
		}

		return( luceneDocument );
	}

}

