//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.services.search;

import java.io.File;

import org.eclipse.epf.publishing.util.PublishingUtil;


/**
 * @author Kelvin Low
 */
public class JarCreator
{

	public static final String INDEX_JAR = "index.jar"; //$NON-NLS-1$

	public static void main(String[] args)
	{
		jarFolder(args[0]);
	}

	public static void jarFolder(String foldername)
	{
		try
		{
			System.out.println("attempting to jar stuff"); //$NON-NLS-1$
			File jarDir = new File(foldername);
			File jarFile = new File(foldername + File.separator +INDEX_JAR);

			PublishingUtil.jarFiles(jarDir, jarFile);
		}
		catch (Exception e1)
		{
			System.out.println("Exception in the jar thingy"); //$NON-NLS-1$
			e1.printStackTrace();
		}
	}

}
