//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.services.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * This class parses and compiles the fields for a plain
 * text document. <br>
 *
 */
public class PlainDocument extends AbstractDocument
{
	/**
	 * Default constructor.
	 */
	public PlainDocument()
	{
		super();
	}

	/**
	 * Parses and compiles the document fields from the given file.
	 */
	protected void compileDocument( File file )
	{
    	// use the file path as the url
    	setDocUrl( file.getPath() );
     	// set title to be the file path
     	setDocTitle( file.getPath() );

		try
		{
	    	// parse and set the contents
		    FileInputStream inStream = new FileInputStream( file );
			InputStreamReader streamReader = new InputStreamReader( inStream );
	  	  	char[] charRead = new char[ inStream.available() ];
 	      	streamReader.read( charRead );
 	      	String contents = new String( charRead );
	       	setContentString( contents );

	       	// close stream
 	      	streamReader.close();
  	     	inStream.close();

  	     	// set summary
  	     	setSummary( contents.substring( 0, contents.length()/4 ) );

		}
		catch( FileNotFoundException fe )
		{
			fe.printStackTrace();
		}
		catch( IOException ie )
		{
			ie.printStackTrace();
		}
	}

}

