//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.publishing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;


public class PublishingUtil {

	/**
	 * method to jar the specified dir into a jar file. non-sub-folders will be jared.
	 * @param jarDir
	 * @param jarFile
	 * @throws IOException
	 */
	public static void jarFiles(File jarDir, File jarFile) throws IOException
	{
		File[] files = jarDir.listFiles();
		if (jarFile.exists())
		{
			jarFile.delete();
		}
		BufferedOutputStream bStream = new BufferedOutputStream(new FileOutputStream(jarFile));
		ZipOutputStream zipperStream = new ZipOutputStream(bStream);

		String currentName = ""; //$NON-NLS-1$
		byte[] bytes = new byte[4096];
		for (int i=0; i<files.length; i++)
		{
			File currentFile = files[i];
			if ( currentFile.isDirectory() )
			{
				continue;
			}
			ZipEntry currEntry = new ZipEntry(currentFile.getName());
			zipperStream.putNextEntry(currEntry);
			BufferedInputStream biStream = new BufferedInputStream(new FileInputStream(currentFile));
			while (biStream.available() > 0)
			{
				int num = biStream.read(bytes);
				zipperStream.write(bytes, 0, num);
			}
			biStream.close();
			zipperStream.closeEntry();
		}
		zipperStream.close();
		bStream.close();

	}


	public static String getHtml(XmlElement xmlElement, String xslPath)
	{
		try
		{
			URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), xslPath);
			if ( url == null )
			{
				System.out.println("Unable to get xsl template " + xslPath); //$NON-NLS-1$
				return null;
			}

			String xsl_uri = Platform.resolve(url).getPath();

			StringBuffer xml = new StringBuffer();
			xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());

			Properties xslParams = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties"); //$NON-NLS-1$
			
			// geenrate the html
			StringWriter sw = new StringWriter();
			XSLTProcessor.transform(xsl_uri, xml.toString(), xslParams, sw);
			sw.flush();
			
			// urls are encoded in xslt output, decode it
			return ResourceHelper.decodeUrlsInContent(sw.getBuffer().toString());
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		return null;
	}

}
