//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.rcp;

import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.rcp.wizards.UIExportWizardExtensionPoint;
import org.eclipse.epf.rcp.wizards.UIImportWizardExtensionPoint;
import org.osgi.framework.BundleContext;

/**
 * The main RCP application plug-in class.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class MainPlugin extends AbstractPlugin {

	// The shared plug-in instance.
	private static MainPlugin plugin;

	/**
	 * Default constructor.
	 */
	public MainPlugin() {
		super();
		plugin = this;
	}

	/**
	 * @see org.eclipse.epf.uma.core.plugin.AbstractPlugin#start(BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		UIImportWizardExtensionPoint.getInstance().loadExtension();
		UIExportWizardExtensionPoint.getInstance().loadExtension();
	}

	/**
	 * @see org.eclipse.epf.uma.core.plugin.AbstractPlugin#start(BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared plug-in instance.
	 */
	public static MainPlugin getDefault() {
		return plugin;
	}

}
