//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext;

/**
 * The interface for a rich text editor.
 * <p>
 * A rich text editor is a composite user interface object that includes a tool
 * bar, a tab folder for entering the rich text content, and a tab foler for
 * viewing and modifying the rich text content in a markup language.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public interface IRichTextEditor extends IRichText {

	/**
	 * Fills the tool bar with action items.
	 * 
	 * @param toolBar
	 *            a tool bar contain rich text actions
	 */
	public void fillToolBar(IRichTextToolBar toolBar);

	/**
	 * Selects the rich text or the markup lanaguge tab.
	 * 
	 * @param index
	 *            <code>0</code> for the rich text tab, <code>1</code> for
	 *            the mark up language tab
	 */
	public void setSelection(int index);

}
