//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextCommand;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.html.BlockTag;

/**
 * Sets the font name for the selected text in a rich text control.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class BlockTagAction extends RichTextComboAction {

	/**
	 * Creates a new instance.
	 */
	public BlockTagAction() {
		setToolTipText(RichTextResources.blockTagAction_toolTipText); //$NON-NLS-1$
		addItem(BlockTag.PARAGRAPH.getName());
		addItem(BlockTag.HEADING_1.getName());
		addItem(BlockTag.HEADING_2.getName());
		addItem(BlockTag.HEADING_3.getName());
		addItem(BlockTag.HEADING_4.getName());
		addItem(BlockTag.HEADING_5.getName());
		addItem(BlockTag.HEADING_6.getName());
		addItem(BlockTag.ADDRESS.getName());
		addItem(BlockTag.PREFORMATTED_TEXT.getName());
		setEnabled(true);
	}

	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 * @param index
	 *            the index of the selected item
	 */
	public void execute(IRichText richText, int index) {
		if (richText != null) {
			String value = BlockTag.getBlockTag(index).getValue();
			richText.executeCommand(RichTextCommand.FORMAT_BLOCK, value);
		}
	}

}