//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextCommand;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.html.FontName;

/**
 * Sets the font name for the selected text in a rich text control.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class FontNameAction extends RichTextComboAction {

	/**
	 * Creates a new instance.
	 */
	public FontNameAction() {
		setToolTipText(RichTextResources.fontNameAction_toolTipText); //$NON-NLS-1$
		addItem(FontName.DEFAULT.getName());
		addItem(FontName.ARIAL.getName());
		addItem(FontName.COURIER_NEW.getName());
		addItem(FontName.TIMES_NEW_ROMAN.getName());
		addItem(FontName.VERDANA.getName());
		setEnabled(true);
	}

	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 * @param index
	 *            the index of the selected item
	 */
	public void execute(IRichText richText, int index) {
		if (richText != null) {
			String value = FontName.getFontName(index).getValue();
			richText.executeCommand(RichTextCommand.SET_FONT_NAME, value);
		}
	}

}