//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextCommand;
import org.eclipse.epf.richtext.RichTextResources;

/**
 * Sets the font size for the selected text in a rich text control.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class FontSizeAction extends RichTextComboAction {

	/**
	 * Creates a new instance.
	 */
	public FontSizeAction() {
		setToolTipText(RichTextResources.fontSizeAction_toolTipText); //$NON-NLS-1$
		addItem("1"); //$NON-NLS-1$
		addItem("2"); //$NON-NLS-1$
		addItem("3"); //$NON-NLS-1$
		addItem("4"); //$NON-NLS-1$
		addItem("5"); //$NON-NLS-1$
		addItem("6"); //$NON-NLS-1$
		addItem("7"); //$NON-NLS-1$		
		setEnabled(true);
	}

	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 * @param index
	 *            the index of the selected item
	 */
	public void execute(IRichText richText, int index) {
		if (richText != null) {
			richText.executeCommand(RichTextCommand.SET_FONT_SIZE,
					"" + index + 1); //$NON-NLS-1$
		}
	}

}