//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextCommand;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.html.FontStyle;

/**
 * Sets the font style for the selected text in a rich text control.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class FontStyleAction extends RichTextComboAction {

	/**
	 * Creates a new instance.
	 */
	public FontStyleAction() {
		setToolTipText(RichTextResources.fontStyleAction_toolTipText); //$NON-NLS-1$
		addItem(FontStyle.NORMAL.getName());
		addItem(FontStyle.SECTION_HEADING.getName());
		addItem(FontStyle.SUBSECTION_HEADING.getName());
		addItem(FontStyle.SUB_SUBSECTION_HEADING.getName());
		addItem(FontStyle.QUOTE.getName());
		addItem(FontStyle.CODE_SAMPLE.getName());
		setEnabled(true);
	}

	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 * @param index
	 *            the index of the selected item
	 */
	public void execute(IRichText richText, int index) {
		if (richText != null) {
			String value = FontStyle.getFontStyle(index).getValue();
			richText.executeCommand(RichTextCommand.SET_FONT_STYLE, value);
		}
	}

}