//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.swt.graphics.Image;

/**
 * The abstract implementation of a rich text action.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public abstract class RichTextAction extends BaseRichTextAction implements
		IRichTextAction {

	protected Image image;

	protected Image disabledImage;

	/**
	 * Creates a new instance.
	 * 
	 * @param richText
	 *            a rich text control
	 */
	public RichTextAction() {
	}

	/**
	 * Returns the image for the action.
	 * 
	 * @return the image for the action
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * Sets the image for the action.
	 * 
	 * @param image
	 *            the image for the action
	 */
	public void setImage(Image image) {
		this.image = image;
	}

	/**
	 * Returns the disabled image for the action.
	 * 
	 * @return the disabled image for the action
	 */
	public Image getDisabledImage() {
		return disabledImage;
	}

	/**
	 * Sets the disabled image for the action.
	 * 
	 * @param disabledImage
	 *            the disabled image for the action
	 */
	public void setDisabledImage(Image disabledImage) {
		this.disabledImage = disabledImage;
	}

	/**
	 * Returns <code>true</code> if this action should be disabled when the
	 * rich text editor is in readonly mode.
	 */
	public boolean disableInReadOnlyMode() {
		return true;
	}
	
	/**
	 * Returns <code>true</code> if this action should be disabled when the
	 * rich text editor is in source editor mode.
	 */
	public boolean disableInSourceMode() {
		return true;
	}
	
	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 */
	public abstract void execute(IRichText richText);

}
