//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.epf.richtext.IRichText;

/**
 * The abstract implementation of a rich text combo action.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public abstract class RichTextComboAction extends BaseRichTextAction implements
		IRichTextComboAction {

	protected List items = new ArrayList();

	/**
	 * Adds a combo item.
	 * 
	 * @param itemText
	 *            the text for a combo item
	 */
	public void addItem(String itemText) {
		items.add(itemText);
	}

	/**
	 * Returns an array of combo items.
	 * 
	 * @return an array of combo items
	 */
	public String[] getItems() {
		return (String[]) items.toArray(new String[items.size()]);
	}

	/**
	 * Executes the action.
	 * 
	 * @param richText
	 *            a rich text control
	 * @param index
	 *            the index of the selected item
	 */
	public abstract void execute(IRichText richText, int index);

}
