//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.html;

/**
 * Models a simplified HTML Link tag (<a>).
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class Link {

	// The link name.
	private String name = ""; //$NON-NLS-1$

	// The link URL.
	private String url = ""; //$NON-NLS-1$

	/**
	 * Creates a new <code>Link</code>.
	 */
	public Link() {
	}

	/**
	 * Returns the link name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the link name.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the link URL.
	 */
	public String getURL() {
		return url;
	}

	/**
	 * Sets the hyperlink URL.
	 */
	public void setURL(String url) {
		this.url = url;
	}

	/**
	 * Returns the HTML representation of the hyperlink.
	 */
	public String toHTML() {
		return null;
	}
}
