//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.richtext.html;

/**
 * Models a simplified HTML Table tag (<a>).
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class Table {

	// The number of rows.
	private int rows = 2;

	// The number of columns.
	private int cols = 2;

	// The table width.
	private int width = 180;

	// The type of tableheaders for this table.
	private int tableHeaders = 0;

	// The table summary.
	private String summary;

	// The table caption.
	private String caption;

	// Javascript constants
	public static final int TABLE_HEADERS_NONE = 0;

	public static final int TABLE_HEADERS_COLS = 1;

	public static final int TABLE_HEADERS_ROWS = 2;

	public static final int TABLE_HEADERS_BOTH = 3;

	/**
	 * Creates a new <code>Table</code>.
	 */
	public Table() {
	}

	/**
	 * Returns the number of rows.
	 */
	public int getRows() {
		return rows;
	}

	/**
	 * Sets the number of rows.
	 */
	public void setRows(int rows) {
		this.rows = rows;
	}

	/**
	 * Returns the number of columns.
	 */
	public int getColumns() {
		return cols;
	}

	/**
	 * Sets the number of columns.
	 */
	public void setColumns(int cols) {
		this.cols = cols;
	}

	/**
	 * Returns the table width.
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * Sets the table width.
	 */
	public void setWidth(int width) {
		this.width = width;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public int getTableHeaders() {
		return tableHeaders;
	}

	public void setTableHeaders(int tableHeaders) {
		this.tableHeaders = tableHeaders;
	}

}
