//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.search;

import org.eclipse.epf.search.configuration.ConfigurationHitEntry;
import org.eclipse.epf.search.configuration.ConfigurationSearchQuery;
import org.eclipse.epf.search.configuration.internal.ConfigurationSearchService;

/**
 * The Search Service implementation.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class SearchService implements ISearchService {

	// The shared instance.
	private static SearchService instance = null;

	/**
	 * Returns the shared instance.
	 */
	public static SearchService getInstance() {
		if (instance == null) {
			synchronized (SearchService.class) {
				if (instance == null) {
					instance = new SearchService();
				}
			}
		}
		return instance;
	}

	/**
	 * Private constructor to prevent this class from being instantiated.
	 */
	private SearchService() {
	}

	/**
	 * Searches a published Configuration.
	 * 
	 * @param path
	 *            the absolute path to the published configuration
	 * @param searchQuery
	 *            the configuration search query
	 * @return an array of <code>ConfigurationHitEntry</code> objects
	 * @throws SearchServiceException
	 *             if an error occurs while executing the operation
	 */
	public ConfigurationHitEntry[] searchConfiguration(String path,
			ConfigurationSearchQuery searchQuery) throws SearchServiceException {
		ConfigurationSearchService service = new ConfigurationSearchService(
				path);
		service.index();
		return service.search(searchQuery);
	}

}
