//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.uma.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.epf.uma.DescribableElement} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DescribableElementItemProvider extends MethodElementItemProvider
		implements IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DescribableElementItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addPresentationNamePropertyDescriptor(object);
			addShapeiconPropertyDescriptor(object);
			addNodeiconPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Presentation Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPresentationNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_DescribableElement_presentationName_feature"), //$NON-NLS-1$
						getString(
								"_UI_PropertyDescriptor_description", "_UI_DescribableElement_presentationName_feature", "_UI_DescribableElement_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME,
						true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Shapeicon feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addShapeiconPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_DescribableElement_shapeicon_feature"), //$NON-NLS-1$
						getString(
								"_UI_PropertyDescriptor_description", "_UI_DescribableElement_shapeicon_feature", "_UI_DescribableElement_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						UmaPackage.Literals.DESCRIBABLE_ELEMENT__SHAPEICON,
						true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Nodeicon feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNodeiconPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_DescribableElement_nodeicon_feature"), //$NON-NLS-1$
						getString(
								"_UI_PropertyDescriptor_description", "_UI_DescribableElement_nodeicon_feature", "_UI_DescribableElement_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						UmaPackage.Literals.DESCRIBABLE_ELEMENT__NODEICON,
						true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures
					.add(UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION);
		}
		return childrenFeatures;
	}

	/**
	 * This returns DescribableElement.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage(
				"full/obj16/DescribableElement")); //$NON-NLS-1$
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((DescribableElement) object).getName();
		return label == null || label.length() == 0 ? getString("_UI_DescribableElement_type") : //$NON-NLS-1$
				getString("_UI_DescribableElement_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DescribableElement.class)) {
		case UmaPackage.DESCRIBABLE_ELEMENT__PRESENTATION_NAME:
		case UmaPackage.DESCRIBABLE_ELEMENT__SHAPEICON:
		case UmaPackage.DESCRIBABLE_ELEMENT__NODEICON:
			fireNotifyChanged(new ViewerNotification(notification, notification
					.getNotifier(), false, true));
			return;
		case UmaPackage.DESCRIBABLE_ELEMENT__PRESENTATION:
			fireNotifyChanged(new ViewerNotification(notification, notification
					.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors,
			Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createContentDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createWorkProductDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createArtifactDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createDeliverableDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createRoleDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createTaskDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createGuidanceDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createPracticeDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createBreakdownElementDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createActivityDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createProcessDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createDeliveryProcessDescription()));

		newChildDescriptors.add(createChildParameter(
				UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION,
				UmaFactory.eINSTANCE.createDescriptorDescription()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return UmaEditPlugin.INSTANCE;
	}

}
