//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.uma.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.uma.util.UmaAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class UmaItemProviderAdapterFactory extends UmaAdapterFactory implements
		ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UmaItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Constraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintItemProvider constraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Constraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createConstraintAdapter() {
		if (constraintItemProvider == null) {
			constraintItemProvider = new ConstraintItemProvider(this);
		}

		return constraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Role} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleItemProvider roleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Role}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoleAdapter() {
		if (roleItemProvider == null) {
			roleItemProvider = new RoleItemProvider(this);
		}

		return roleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Task} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskItemProvider taskItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Task}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTaskAdapter() {
		if (taskItemProvider == null) {
			taskItemProvider = new TaskItemProvider(this);
		}

		return taskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Step} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StepItemProvider stepItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Step}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStepAdapter() {
		if (stepItemProvider == null) {
			stepItemProvider = new StepItemProvider(this);
		}

		return stepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Artifact} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArtifactItemProvider artifactItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Artifact}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createArtifactAdapter() {
		if (artifactItemProvider == null) {
			artifactItemProvider = new ArtifactItemProvider(this);
		}

		return artifactItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Deliverable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeliverableItemProvider deliverableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Deliverable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDeliverableAdapter() {
		if (deliverableItemProvider == null) {
			deliverableItemProvider = new DeliverableItemProvider(this);
		}

		return deliverableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Outcome} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutcomeItemProvider outcomeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Outcome}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createOutcomeAdapter() {
		if (outcomeItemProvider == null) {
			outcomeItemProvider = new OutcomeItemProvider(this);
		}

		return outcomeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Point} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PointItemProvider pointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Point}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPointAdapter() {
		if (pointItemProvider == null) {
			pointItemProvider = new PointItemProvider(this);
		}

		return pointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DiagramLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiagramLinkItemProvider diagramLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DiagramLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDiagramLinkAdapter() {
		if (diagramLinkItemProvider == null) {
			diagramLinkItemProvider = new DiagramLinkItemProvider(this);
		}

		return diagramLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.GraphConnector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GraphConnectorItemProvider graphConnectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.GraphConnector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGraphConnectorAdapter() {
		if (graphConnectorItemProvider == null) {
			graphConnectorItemProvider = new GraphConnectorItemProvider(this);
		}

		return graphConnectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Dimension} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionItemProvider dimensionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Dimension}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDimensionAdapter() {
		if (dimensionItemProvider == null) {
			dimensionItemProvider = new DimensionItemProvider(this);
		}

		return dimensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Reference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceItemProvider referenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Reference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createReferenceAdapter() {
		if (referenceItemProvider == null) {
			referenceItemProvider = new ReferenceItemProvider(this);
		}

		return referenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Property} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyItemProvider propertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Property}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPropertyAdapter() {
		if (propertyItemProvider == null) {
			propertyItemProvider = new PropertyItemProvider(this);
		}

		return propertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.GraphEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GraphEdgeItemProvider graphEdgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.GraphEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGraphEdgeAdapter() {
		if (graphEdgeItemProvider == null) {
			graphEdgeItemProvider = new GraphEdgeItemProvider(this);
		}

		return graphEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Diagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiagramItemProvider diagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Diagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDiagramAdapter() {
		if (diagramItemProvider == null) {
			diagramItemProvider = new DiagramItemProvider(this);
		}

		return diagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.GraphNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GraphNodeItemProvider graphNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.GraphNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGraphNodeAdapter() {
		if (graphNodeItemProvider == null) {
			graphNodeItemProvider = new GraphNodeItemProvider(this);
		}

		return graphNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.SimpleSemanticModelElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleSemanticModelElementItemProvider simpleSemanticModelElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.SimpleSemanticModelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSimpleSemanticModelElementAdapter() {
		if (simpleSemanticModelElementItemProvider == null) {
			simpleSemanticModelElementItemProvider = new SimpleSemanticModelElementItemProvider(
					this);
		}

		return simpleSemanticModelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.UMASemanticModelBridge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMASemanticModelBridgeItemProvider umaSemanticModelBridgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.UMASemanticModelBridge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createUMASemanticModelBridgeAdapter() {
		if (umaSemanticModelBridgeItemProvider == null) {
			umaSemanticModelBridgeItemProvider = new UMASemanticModelBridgeItemProvider(
					this);
		}

		return umaSemanticModelBridgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.CoreSemanticModelBridge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreSemanticModelBridgeItemProvider coreSemanticModelBridgeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.CoreSemanticModelBridge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCoreSemanticModelBridgeAdapter() {
		if (coreSemanticModelBridgeItemProvider == null) {
			coreSemanticModelBridgeItemProvider = new CoreSemanticModelBridgeItemProvider(
					this);
		}

		return coreSemanticModelBridgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.TextElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextElementItemProvider textElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.TextElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTextElementAdapter() {
		if (textElementItemProvider == null) {
			textElementItemProvider = new TextElementItemProvider(this);
		}

		return textElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Image} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageItemProvider imageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Image}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createImageAdapter() {
		if (imageItemProvider == null) {
			imageItemProvider = new ImageItemProvider(this);
		}

		return imageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Polyline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PolylineItemProvider polylineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Polyline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPolylineAdapter() {
		if (polylineItemProvider == null) {
			polylineItemProvider = new PolylineItemProvider(this);
		}

		return polylineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Ellipse} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EllipseItemProvider ellipseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Ellipse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEllipseAdapter() {
		if (ellipseItemProvider == null) {
			ellipseItemProvider = new EllipseItemProvider(this);
		}

		return ellipseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Activity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityItemProvider activityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Activity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createActivityAdapter() {
		if (activityItemProvider == null) {
			activityItemProvider = new ActivityItemProvider(this);
		}

		return activityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Milestone} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MilestoneItemProvider milestoneItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Milestone}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMilestoneAdapter() {
		if (milestoneItemProvider == null) {
			milestoneItemProvider = new MilestoneItemProvider(this);
		}

		return milestoneItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Iteration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterationItemProvider iterationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Iteration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIterationAdapter() {
		if (iterationItemProvider == null) {
			iterationItemProvider = new IterationItemProvider(this);
		}

		return iterationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Phase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhaseItemProvider phaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Phase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPhaseAdapter() {
		if (phaseItemProvider == null) {
			phaseItemProvider = new PhaseItemProvider(this);
		}

		return phaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.TeamProfile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TeamProfileItemProvider teamProfileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.TeamProfile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTeamProfileAdapter() {
		if (teamProfileItemProvider == null) {
			teamProfileItemProvider = new TeamProfileItemProvider(this);
		}

		return teamProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.RoleDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleDescriptorItemProvider roleDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.RoleDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoleDescriptorAdapter() {
		if (roleDescriptorItemProvider == null) {
			roleDescriptorItemProvider = new RoleDescriptorItemProvider(this);
		}

		return roleDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.WorkOrder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WorkOrderItemProvider workOrderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.WorkOrder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWorkOrderAdapter() {
		if (workOrderItemProvider == null) {
			workOrderItemProvider = new WorkOrderItemProvider(this);
		}

		return workOrderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.PlanningData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlanningDataItemProvider planningDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.PlanningData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPlanningDataAdapter() {
		if (planningDataItemProvider == null) {
			planningDataItemProvider = new PlanningDataItemProvider(this);
		}

		return planningDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.TaskDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskDescriptorItemProvider taskDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.TaskDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTaskDescriptorAdapter() {
		if (taskDescriptorItemProvider == null) {
			taskDescriptorItemProvider = new TaskDescriptorItemProvider(this);
		}

		return taskDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.WorkProductDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WorkProductDescriptorItemProvider workProductDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.WorkProductDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWorkProductDescriptorAdapter() {
		if (workProductDescriptorItemProvider == null) {
			workProductDescriptorItemProvider = new WorkProductDescriptorItemProvider(
					this);
		}

		return workProductDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.CompositeRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeRoleItemProvider compositeRoleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.CompositeRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCompositeRoleAdapter() {
		if (compositeRoleItemProvider == null) {
			compositeRoleItemProvider = new CompositeRoleItemProvider(this);
		}

		return compositeRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.BreakdownElementDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BreakdownElementDescriptionItemProvider breakdownElementDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.BreakdownElementDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBreakdownElementDescriptionAdapter() {
		if (breakdownElementDescriptionItemProvider == null) {
			breakdownElementDescriptionItemProvider = new BreakdownElementDescriptionItemProvider(
					this);
		}

		return breakdownElementDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ActivityDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityDescriptionItemProvider activityDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ActivityDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createActivityDescriptionAdapter() {
		if (activityDescriptionItemProvider == null) {
			activityDescriptionItemProvider = new ActivityDescriptionItemProvider(
					this);
		}

		return activityDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DeliveryProcessDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeliveryProcessDescriptionItemProvider deliveryProcessDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DeliveryProcessDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDeliveryProcessDescriptionAdapter() {
		if (deliveryProcessDescriptionItemProvider == null) {
			deliveryProcessDescriptionItemProvider = new DeliveryProcessDescriptionItemProvider(
					this);
		}

		return deliveryProcessDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessDescriptionItemProvider processDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessDescriptionAdapter() {
		if (processDescriptionItemProvider == null) {
			processDescriptionItemProvider = new ProcessDescriptionItemProvider(
					this);
		}

		return processDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DescriptorDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescriptorDescriptionItemProvider descriptorDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DescriptorDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDescriptorDescriptionAdapter() {
		if (descriptorDescriptionItemProvider == null) {
			descriptorDescriptionItemProvider = new DescriptorDescriptionItemProvider(
					this);
		}

		return descriptorDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Concept} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConceptItemProvider conceptItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Concept}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createConceptAdapter() {
		if (conceptItemProvider == null) {
			conceptItemProvider = new ConceptItemProvider(this);
		}

		return conceptItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Checklist} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChecklistItemProvider checklistItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Checklist}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createChecklistAdapter() {
		if (checklistItemProvider == null) {
			checklistItemProvider = new ChecklistItemProvider(this);
		}

		return checklistItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Example} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExampleItemProvider exampleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Example}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createExampleAdapter() {
		if (exampleItemProvider == null) {
			exampleItemProvider = new ExampleItemProvider(this);
		}

		return exampleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Guideline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuidelineItemProvider guidelineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Guideline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGuidelineAdapter() {
		if (guidelineItemProvider == null) {
			guidelineItemProvider = new GuidelineItemProvider(this);
		}

		return guidelineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.EstimationConsiderations} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EstimationConsiderationsItemProvider estimationConsiderationsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.EstimationConsiderations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEstimationConsiderationsAdapter() {
		if (estimationConsiderationsItemProvider == null) {
			estimationConsiderationsItemProvider = new EstimationConsiderationsItemProvider(
					this);
		}

		return estimationConsiderationsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Report} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReportItemProvider reportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Report}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createReportAdapter() {
		if (reportItemProvider == null) {
			reportItemProvider = new ReportItemProvider(this);
		}

		return reportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Template} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateItemProvider templateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Template}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTemplateAdapter() {
		if (templateItemProvider == null) {
			templateItemProvider = new TemplateItemProvider(this);
		}

		return templateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.SupportingMaterial} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SupportingMaterialItemProvider supportingMaterialItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.SupportingMaterial}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSupportingMaterialAdapter() {
		if (supportingMaterialItemProvider == null) {
			supportingMaterialItemProvider = new SupportingMaterialItemProvider(
					this);
		}

		return supportingMaterialItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ToolMentor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolMentorItemProvider toolMentorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ToolMentor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createToolMentorAdapter() {
		if (toolMentorItemProvider == null) {
			toolMentorItemProvider = new ToolMentorItemProvider(this);
		}

		return toolMentorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Whitepaper} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WhitepaperItemProvider whitepaperItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Whitepaper}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWhitepaperAdapter() {
		if (whitepaperItemProvider == null) {
			whitepaperItemProvider = new WhitepaperItemProvider(this);
		}

		return whitepaperItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.TermDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TermDefinitionItemProvider termDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.TermDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTermDefinitionAdapter() {
		if (termDefinitionItemProvider == null) {
			termDefinitionItemProvider = new TermDefinitionItemProvider(this);
		}

		return termDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Practice} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PracticeItemProvider practiceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Practice}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPracticeAdapter() {
		if (practiceItemProvider == null) {
			practiceItemProvider = new PracticeItemProvider(this);
		}

		return practiceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ReusableAsset} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReusableAssetItemProvider reusableAssetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ReusableAsset}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createReusableAssetAdapter() {
		if (reusableAssetItemProvider == null) {
			reusableAssetItemProvider = new ReusableAssetItemProvider(this);
		}

		return reusableAssetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.State} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateItemProvider stateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.State}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStateAdapter() {
		if (stateItemProvider == null) {
			stateItemProvider = new StateItemProvider(this);
		}

		return stateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Vertex} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VertexItemProvider vertexItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Vertex}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createVertexAdapter() {
		if (vertexItemProvider == null) {
			vertexItemProvider = new VertexItemProvider(this);
		}

		return vertexItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Region} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegionItemProvider regionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Region}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRegionAdapter() {
		if (regionItemProvider == null) {
			regionItemProvider = new RegionItemProvider(this);
		}

		return regionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.StateMachine} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateMachineItemProvider stateMachineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.StateMachine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStateMachineAdapter() {
		if (stateMachineItemProvider == null) {
			stateMachineItemProvider = new StateMachineItemProvider(this);
		}

		return stateMachineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Transition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransitionItemProvider transitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Transition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTransitionAdapter() {
		if (transitionItemProvider == null) {
			transitionItemProvider = new TransitionItemProvider(this);
		}

		return transitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.PseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PseudoStateItemProvider pseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.PseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPseudoStateAdapter() {
		if (pseudoStateItemProvider == null) {
			pseudoStateItemProvider = new PseudoStateItemProvider(this);
		}

		return pseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Discipline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DisciplineItemProvider disciplineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Discipline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDisciplineAdapter() {
		if (disciplineItemProvider == null) {
			disciplineItemProvider = new DisciplineItemProvider(this);
		}

		return disciplineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.RoleSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleSetItemProvider roleSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.RoleSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoleSetAdapter() {
		if (roleSetItemProvider == null) {
			roleSetItemProvider = new RoleSetItemProvider(this);
		}

		return roleSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Domain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DomainItemProvider domainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Domain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDomainAdapter() {
		if (domainItemProvider == null) {
			domainItemProvider = new DomainItemProvider(this);
		}

		return domainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.WorkProductType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WorkProductTypeItemProvider workProductTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.WorkProductType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWorkProductTypeAdapter() {
		if (workProductTypeItemProvider == null) {
			workProductTypeItemProvider = new WorkProductTypeItemProvider(this);
		}

		return workProductTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DisciplineGrouping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DisciplineGroupingItemProvider disciplineGroupingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DisciplineGrouping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDisciplineGroupingAdapter() {
		if (disciplineGroupingItemProvider == null) {
			disciplineGroupingItemProvider = new DisciplineGroupingItemProvider(
					this);
		}

		return disciplineGroupingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Tool} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolItemProvider toolItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Tool}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createToolAdapter() {
		if (toolItemProvider == null) {
			toolItemProvider = new ToolItemProvider(this);
		}

		return toolItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.RoleSetGrouping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleSetGroupingItemProvider roleSetGroupingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.RoleSetGrouping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoleSetGroupingAdapter() {
		if (roleSetGroupingItemProvider == null) {
			roleSetGroupingItemProvider = new RoleSetGroupingItemProvider(this);
		}

		return roleSetGroupingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.CustomCategory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomCategoryItemProvider customCategoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.CustomCategory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCustomCategoryAdapter() {
		if (customCategoryItemProvider == null) {
			customCategoryItemProvider = new CustomCategoryItemProvider(this);
		}

		return customCategoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.CapabilityPattern} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CapabilityPatternItemProvider capabilityPatternItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.CapabilityPattern}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCapabilityPatternAdapter() {
		if (capabilityPatternItemProvider == null) {
			capabilityPatternItemProvider = new CapabilityPatternItemProvider(
					this);
		}

		return capabilityPatternItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DeliveryProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeliveryProcessItemProvider deliveryProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DeliveryProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDeliveryProcessAdapter() {
		if (deliveryProcessItemProvider == null) {
			deliveryProcessItemProvider = new DeliveryProcessItemProvider(this);
		}

		return deliveryProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessPlanningTemplate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPlanningTemplateItemProvider processPlanningTemplateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessPlanningTemplate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessPlanningTemplateAdapter() {
		if (processPlanningTemplateItemProvider == null) {
			processPlanningTemplateItemProvider = new ProcessPlanningTemplateItemProvider(
					this);
		}

		return processPlanningTemplateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Roadmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoadmapItemProvider roadmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Roadmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoadmapAdapter() {
		if (roadmapItemProvider == null) {
			roadmapItemProvider = new RoadmapItemProvider(this);
		}

		return roadmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ContentPackage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContentPackageItemProvider contentPackageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ContentPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createContentPackageAdapter() {
		if (contentPackageItemProvider == null) {
			contentPackageItemProvider = new ContentPackageItemProvider(this);
		}

		return contentPackageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessComponentItemProvider processComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessComponentAdapter() {
		if (processComponentItemProvider == null) {
			processComponentItemProvider = new ProcessComponentItemProvider(
					this);
		}

		return processComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessPackage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPackageItemProvider processPackageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessPackageAdapter() {
		if (processPackageItemProvider == null) {
			processPackageItemProvider = new ProcessPackageItemProvider(this);
		}

		return processPackageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessComponentInterface} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessComponentInterfaceItemProvider processComponentInterfaceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessComponentInterface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessComponentInterfaceAdapter() {
		if (processComponentInterfaceItemProvider == null) {
			processComponentInterfaceItemProvider = new ProcessComponentInterfaceItemProvider(
					this);
		}

		return processComponentInterfaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessComponentDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessComponentDescriptorItemProvider processComponentDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessComponentDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessComponentDescriptorAdapter() {
		if (processComponentDescriptorItemProvider == null) {
			processComponentDescriptorItemProvider = new ProcessComponentDescriptorItemProvider(
					this);
		}

		return processComponentDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.MethodPlugin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodPluginItemProvider methodPluginItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.MethodPlugin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMethodPluginAdapter() {
		if (methodPluginItemProvider == null) {
			methodPluginItemProvider = new MethodPluginItemProvider(this);
		}

		return methodPluginItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ContentDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContentDescriptionItemProvider contentDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ContentDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createContentDescriptionAdapter() {
		if (contentDescriptionItemProvider == null) {
			contentDescriptionItemProvider = new ContentDescriptionItemProvider(
					this);
		}

		return contentDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.Section} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SectionItemProvider sectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.Section}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSectionAdapter() {
		if (sectionItemProvider == null) {
			sectionItemProvider = new SectionItemProvider(this);
		}

		return sectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ArtifactDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArtifactDescriptionItemProvider artifactDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ArtifactDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createArtifactDescriptionAdapter() {
		if (artifactDescriptionItemProvider == null) {
			artifactDescriptionItemProvider = new ArtifactDescriptionItemProvider(
					this);
		}

		return artifactDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.WorkProductDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WorkProductDescriptionItemProvider workProductDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.WorkProductDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWorkProductDescriptionAdapter() {
		if (workProductDescriptionItemProvider == null) {
			workProductDescriptionItemProvider = new WorkProductDescriptionItemProvider(
					this);
		}

		return workProductDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.DeliverableDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeliverableDescriptionItemProvider deliverableDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.DeliverableDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDeliverableDescriptionAdapter() {
		if (deliverableDescriptionItemProvider == null) {
			deliverableDescriptionItemProvider = new DeliverableDescriptionItemProvider(
					this);
		}

		return deliverableDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.RoleDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleDescriptionItemProvider roleDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.RoleDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoleDescriptionAdapter() {
		if (roleDescriptionItemProvider == null) {
			roleDescriptionItemProvider = new RoleDescriptionItemProvider(this);
		}

		return roleDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.TaskDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskDescriptionItemProvider taskDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.TaskDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTaskDescriptionAdapter() {
		if (taskDescriptionItemProvider == null) {
			taskDescriptionItemProvider = new TaskDescriptionItemProvider(this);
		}

		return taskDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.GuidanceDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuidanceDescriptionItemProvider guidanceDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.GuidanceDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGuidanceDescriptionAdapter() {
		if (guidanceDescriptionItemProvider == null) {
			guidanceDescriptionItemProvider = new GuidanceDescriptionItemProvider(
					this);
		}

		return guidanceDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.PracticeDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PracticeDescriptionItemProvider practiceDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.PracticeDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPracticeDescriptionAdapter() {
		if (practiceDescriptionItemProvider == null) {
			practiceDescriptionItemProvider = new PracticeDescriptionItemProvider(
					this);
		}

		return practiceDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.MethodConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodConfigurationItemProvider methodConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.MethodConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMethodConfigurationAdapter() {
		if (methodConfigurationItemProvider == null) {
			methodConfigurationItemProvider = new MethodConfigurationItemProvider(
					this);
		}

		return methodConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.ProcessFamily} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessFamilyItemProvider processFamilyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.ProcessFamily}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProcessFamilyAdapter() {
		if (processFamilyItemProvider == null) {
			processFamilyItemProvider = new ProcessFamilyItemProvider(this);
		}

		return processFamilyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.epf.uma.MethodLibrary} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodLibraryItemProvider methodLibraryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.epf.uma.MethodLibrary}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMethodLibraryAdapter() {
		if (methodLibraryItemProvider == null) {
			methodLibraryItemProvider = new MethodLibraryItemProvider(this);
		}

		return methodLibraryItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class)
					|| (((Class) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (packageItemProvider != null)
			packageItemProvider.dispose();
		if (constraintItemProvider != null)
			constraintItemProvider.dispose();
		if (contentDescriptionItemProvider != null)
			contentDescriptionItemProvider.dispose();
		if (sectionItemProvider != null)
			sectionItemProvider.dispose();
		if (roleItemProvider != null)
			roleItemProvider.dispose();
		if (taskItemProvider != null)
			taskItemProvider.dispose();
		if (stepItemProvider != null)
			stepItemProvider.dispose();
		if (artifactItemProvider != null)
			artifactItemProvider.dispose();
		if (deliverableItemProvider != null)
			deliverableItemProvider.dispose();
		if (outcomeItemProvider != null)
			outcomeItemProvider.dispose();
		if (contentPackageItemProvider != null)
			contentPackageItemProvider.dispose();
		if (artifactDescriptionItemProvider != null)
			artifactDescriptionItemProvider.dispose();
		if (workProductDescriptionItemProvider != null)
			workProductDescriptionItemProvider.dispose();
		if (deliverableDescriptionItemProvider != null)
			deliverableDescriptionItemProvider.dispose();
		if (roleDescriptionItemProvider != null)
			roleDescriptionItemProvider.dispose();
		if (taskDescriptionItemProvider != null)
			taskDescriptionItemProvider.dispose();
		if (guidanceDescriptionItemProvider != null)
			guidanceDescriptionItemProvider.dispose();
		if (practiceDescriptionItemProvider != null)
			practiceDescriptionItemProvider.dispose();
		if (pointItemProvider != null)
			pointItemProvider.dispose();
		if (diagramLinkItemProvider != null)
			diagramLinkItemProvider.dispose();
		if (graphConnectorItemProvider != null)
			graphConnectorItemProvider.dispose();
		if (dimensionItemProvider != null)
			dimensionItemProvider.dispose();
		if (referenceItemProvider != null)
			referenceItemProvider.dispose();
		if (propertyItemProvider != null)
			propertyItemProvider.dispose();
		if (graphEdgeItemProvider != null)
			graphEdgeItemProvider.dispose();
		if (diagramItemProvider != null)
			diagramItemProvider.dispose();
		if (graphNodeItemProvider != null)
			graphNodeItemProvider.dispose();
		if (simpleSemanticModelElementItemProvider != null)
			simpleSemanticModelElementItemProvider.dispose();
		if (umaSemanticModelBridgeItemProvider != null)
			umaSemanticModelBridgeItemProvider.dispose();
		if (coreSemanticModelBridgeItemProvider != null)
			coreSemanticModelBridgeItemProvider.dispose();
		if (textElementItemProvider != null)
			textElementItemProvider.dispose();
		if (imageItemProvider != null)
			imageItemProvider.dispose();
		if (polylineItemProvider != null)
			polylineItemProvider.dispose();
		if (ellipseItemProvider != null)
			ellipseItemProvider.dispose();
		if (activityItemProvider != null)
			activityItemProvider.dispose();
		if (milestoneItemProvider != null)
			milestoneItemProvider.dispose();
		if (iterationItemProvider != null)
			iterationItemProvider.dispose();
		if (phaseItemProvider != null)
			phaseItemProvider.dispose();
		if (teamProfileItemProvider != null)
			teamProfileItemProvider.dispose();
		if (roleDescriptorItemProvider != null)
			roleDescriptorItemProvider.dispose();
		if (workOrderItemProvider != null)
			workOrderItemProvider.dispose();
		if (planningDataItemProvider != null)
			planningDataItemProvider.dispose();
		if (workProductDescriptorItemProvider != null)
			workProductDescriptorItemProvider.dispose();
		if (taskDescriptorItemProvider != null)
			taskDescriptorItemProvider.dispose();
		if (compositeRoleItemProvider != null)
			compositeRoleItemProvider.dispose();
		if (breakdownElementDescriptionItemProvider != null)
			breakdownElementDescriptionItemProvider.dispose();
		if (activityDescriptionItemProvider != null)
			activityDescriptionItemProvider.dispose();
		if (deliveryProcessDescriptionItemProvider != null)
			deliveryProcessDescriptionItemProvider.dispose();
		if (processDescriptionItemProvider != null)
			processDescriptionItemProvider.dispose();
		if (descriptorDescriptionItemProvider != null)
			descriptorDescriptionItemProvider.dispose();
		if (conceptItemProvider != null)
			conceptItemProvider.dispose();
		if (checklistItemProvider != null)
			checklistItemProvider.dispose();
		if (exampleItemProvider != null)
			exampleItemProvider.dispose();
		if (guidelineItemProvider != null)
			guidelineItemProvider.dispose();
		if (reportItemProvider != null)
			reportItemProvider.dispose();
		if (templateItemProvider != null)
			templateItemProvider.dispose();
		if (supportingMaterialItemProvider != null)
			supportingMaterialItemProvider.dispose();
		if (toolMentorItemProvider != null)
			toolMentorItemProvider.dispose();
		if (whitepaperItemProvider != null)
			whitepaperItemProvider.dispose();
		if (termDefinitionItemProvider != null)
			termDefinitionItemProvider.dispose();
		if (practiceItemProvider != null)
			practiceItemProvider.dispose();
		if (estimationConsiderationsItemProvider != null)
			estimationConsiderationsItemProvider.dispose();
		if (reusableAssetItemProvider != null)
			reusableAssetItemProvider.dispose();
		if (stateItemProvider != null)
			stateItemProvider.dispose();
		if (vertexItemProvider != null)
			vertexItemProvider.dispose();
		if (regionItemProvider != null)
			regionItemProvider.dispose();
		if (stateMachineItemProvider != null)
			stateMachineItemProvider.dispose();
		if (transitionItemProvider != null)
			transitionItemProvider.dispose();
		if (pseudoStateItemProvider != null)
			pseudoStateItemProvider.dispose();
		if (disciplineItemProvider != null)
			disciplineItemProvider.dispose();
		if (roleSetItemProvider != null)
			roleSetItemProvider.dispose();
		if (domainItemProvider != null)
			domainItemProvider.dispose();
		if (workProductTypeItemProvider != null)
			workProductTypeItemProvider.dispose();
		if (disciplineGroupingItemProvider != null)
			disciplineGroupingItemProvider.dispose();
		if (toolItemProvider != null)
			toolItemProvider.dispose();
		if (roleSetGroupingItemProvider != null)
			roleSetGroupingItemProvider.dispose();
		if (customCategoryItemProvider != null)
			customCategoryItemProvider.dispose();
		if (deliveryProcessItemProvider != null)
			deliveryProcessItemProvider.dispose();
		if (capabilityPatternItemProvider != null)
			capabilityPatternItemProvider.dispose();
		if (processPlanningTemplateItemProvider != null)
			processPlanningTemplateItemProvider.dispose();
		if (roadmapItemProvider != null)
			roadmapItemProvider.dispose();
		if (processComponentItemProvider != null)
			processComponentItemProvider.dispose();
		if (processPackageItemProvider != null)
			processPackageItemProvider.dispose();
		if (processComponentInterfaceItemProvider != null)
			processComponentInterfaceItemProvider.dispose();
		if (processComponentDescriptorItemProvider != null)
			processComponentDescriptorItemProvider.dispose();
		if (methodPluginItemProvider != null)
			methodPluginItemProvider.dispose();
		if (methodConfigurationItemProvider != null)
			methodConfigurationItemProvider.dispose();
		if (processFamilyItemProvider != null)
			processFamilyItemProvider.dispose();
		if (methodLibraryItemProvider != null)
			methodLibraryItemProvider.dispose();
	}

}
