/**
 * <copyright>
 * </copyright>
 *
 * $Id: ProcessDescription.java,v 1.2 2006/06/23 00:01:26 jxi Exp $
 */
package org.eclipse.epf.xml.uma;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Process Description</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A generalized Activity Description that is used to store the textual description for a Process.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.epf.xml.uma.ProcessDescription#getScope <em>Scope</em>}</li>
 *   <li>{@link org.eclipse.epf.xml.uma.ProcessDescription#getUsageNotes <em>Usage Notes</em>}</li>
 *   <li>{@link org.eclipse.epf.xml.uma.ProcessDescription#getExternalId <em>External Id</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.epf.xml.uma.UmaPackage#getProcessDescription()
 * @model extendedMetaData="name='ProcessDescription' kind='elementOnly'"
 * @generated
 */
public interface ProcessDescription extends ActivityDescription {
	/**
	 * Returns the value of the '<em><b>Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Defines the scope of the Process, i.e. which types of projects does it address and which not.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Scope</em>' attribute.
	 * @see #setScope(String)
	 * @see org.eclipse.epf.xml.uma.UmaPackage#getProcessDescription_Scope()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='Scope'"
	 * @generated
	 */
	String getScope();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.xml.uma.ProcessDescription#getScope <em>Scope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scope</em>' attribute.
	 * @see #getScope()
	 * @generated
	 */
	void setScope(String value);

	/**
	 * Returns the value of the '<em><b>Usage Notes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Any additional notes on how to apply and instantiate this process for a project.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Usage Notes</em>' attribute.
	 * @see #setUsageNotes(String)
	 * @see org.eclipse.epf.xml.uma.UmaPackage#getProcessDescription_UsageNotes()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='UsageNotes'"
	 * @generated
	 */
	String getUsageNotes();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.xml.uma.ProcessDescription#getUsageNotes <em>Usage Notes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Usage Notes</em>' attribute.
	 * @see #getUsageNotes()
	 * @generated
	 */
	void setUsageNotes(String value);

	/**
	 * Returns the value of the '<em><b>External Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * An external visible number that is used to reference this delivery patterns and models. It is used like a synonym.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>External Id</em>' attribute.
	 * @see #setExternalId(String)
	 * @see org.eclipse.epf.xml.uma.UmaPackage#getProcessDescription_ExternalId()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='attribute' name='externalId'"
	 * @generated
	 */
	String getExternalId();

	/**
	 * Sets the value of the '{@link org.eclipse.epf.xml.uma.ProcessDescription#getExternalId <em>External Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>External Id</em>' attribute.
	 * @see #getExternalId()
	 * @generated
	 */
	void setExternalId(String value);

} // ProcessDescription