/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class MethodLibraryPersister
implements IFileBasedLibraryPersister {
    public static final MethodLibraryPersister INSTANCE = new MethodLibraryPersister();
    public static final String RESOURCE_FOLDER = "resources";
    private static final List folderInfos = new ArrayList();
    protected List warnings;
    private static final ILibraryPersister.FailSafeMethodLibraryPersister nonFailSafePersister;

    static {
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getGuidance(), false));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getWorkProduct(), true));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getActivity(), true));
        nonFailSafePersister = new NonFailSafePersister();
    }

    public static String getCorrectPath(ContentDescription contentDescription) {
        return MethodLibraryPersister.getCorrectPath((DescribableElement)contentDescription.eContainer(), contentDescription);
    }

    private static String getCorrectPath(DescribableElement describableElement, ContentDescription contentDescription) {
        if (describableElement == null) {
            return null;
        }
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)describableElement);
        if (methodPlugin == null) {
            return null;
        }
        Resource resource = methodPlugin.eResource();
        URI uRI = MultiFileSaveUtil.getFinalURI(resource);
        File file = new File(uRI.toFileString()).getParentFile();
        String string = MethodLibraryPersister.staticGetFolderPath(describableElement.eClass());
        String string2 = new StringBuffer(file.getAbsolutePath()).append(File.separator).append(string).append(File.separator).toString();
        return MethodLibraryPersister.getNextAvailableFileName(string2, describableElement, contentDescription);
    }

    public static String getNextAvailableFileName(String string, String string2, MultiResourceEObject multiResourceEObject) {
        String string3;
        File file;
        String string4 = null;
        File file2 = null;
        MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)multiResourceEObject.eDirectResource();
        if (multiFileXMIResourceImpl != null && !(file = new File(string, string4 = (file2 = new File(string3 = ((MultiFileXMIResourceImpl)multiResourceEObject.eResource()).getFinalURI().toFileString())).getName())).exists()) {
            return file.getAbsolutePath();
        }
        string3 = new StringBuffer(string).append(string2).append(".xmi").toString();
        file = new File(string3);
        if (file.equals(file2)) {
            return string3;
        }
        if (string4 != null && string4.equals(string2) || file.exists()) {
            int n = 2;
            while (true) {
                if (!new File(string3 = new StringBuffer(string).append(string2).append(' ').append(n).append(".xmi").toString()).exists()) {
                    return string3;
                }
                ++n;
            }
        }
        return string3;
    }

    static String getNextAvailableFileName(String string, ContentDescription contentDescription) {
        return MethodLibraryPersister.getNextAvailableFileName(string, (DescribableElement)contentDescription.eContainer(), contentDescription);
    }

    private static String getNextAvailableFileName(String string, DescribableElement describableElement, ContentDescription contentDescription) {
        return MethodLibraryPersister.getNextAvailableFileName(string, describableElement.getName(), (MultiResourceEObject)contentDescription);
    }

    private static String staticGetFolderPath(EClass eClass) {
        int n = folderInfos.size();
        FolderInfo folderInfo = null;
        int n2 = 0;
        while (n2 < n) {
            FolderInfo folderInfo2 = (FolderInfo)folderInfos.get(n2);
            if (folderInfo2.eClazz.isSuperTypeOf(eClass)) {
                folderInfo = folderInfo2;
            }
            ++n2;
        }
        if (folderInfo != null) {
            if (folderInfo.eClazz == eClass || folderInfo.shared) {
                return folderInfo.name;
            }
            return new StringBuffer(folderInfo.name).append(File.separatorChar).append(MethodLibraryPersister.lowerAndPluralize(eClass.getName())).toString();
        }
        return MethodLibraryPersister.lowerAndPluralize(eClass.getName());
    }

    public static String lowerAndPluralize(String string) {
        if ((string = string.toLowerCase()).endsWith("children")) {
            return string;
        }
        if (string.endsWith("child")) {
            return String.valueOf(string) + "ren";
        }
        if (string.endsWith("data")) {
            return string;
        }
        if (string.endsWith("datum")) {
            return String.valueOf(string.substring(0, string.length() - 2)) + "a";
        }
        if (string.endsWith("by")) {
            return String.valueOf(string) + "s";
        }
        if (string.endsWith("y")) {
            return String.valueOf(string.substring(0, string.length() - 1)) + "ies";
        }
        if (string.endsWith("ex")) {
            return String.valueOf(string.substring(0, string.length() - 2)) + "ices";
        }
        if (string.endsWith("x")) {
            return String.valueOf(string) + "es";
        }
        if (string.endsWith("us")) {
            return String.valueOf(string.substring(0, string.length() - 2)) + "i";
        }
        if (string.endsWith("ss")) {
            return String.valueOf(string) + "es";
        }
        if (string.endsWith("s")) {
            return string;
        }
        return String.valueOf(string) + "s";
    }

    public String geResourceVirtualPath(MethodElement methodElement) {
        String string = this.getElementVirtualPath(methodElement);
        if (string == null || string.length() == 0) {
            return RESOURCE_FOLDER;
        }
        return new StringBuffer(string).append(File.separator).append(RESOURCE_FOLDER).toString();
    }

    public String getElementVirtualPath(MethodElement methodElement) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin == null) {
            if (!(methodElement instanceof MethodConfiguration) && !(methodElement instanceof MethodLibrary)) {
                System.err.println("error in MethodLibraryPersister.getElementPath(): plugin element without a valid plugin. This problem needs to be fixed.");
            }
            return "";
        }
        String string = this.getFolderRelativePath(methodElement);
        String string2 = methodPlugin.getName();
        return string.length() == 0 ? String.valueOf(string2) + File.separator : new StringBuffer(string2).append(File.separatorChar).append(string).append(File.separatorChar).toString();
    }

    private String getRelativeElementPath(MethodElement methodElement) {
        String string;
        String string2 = this.getFolderRelativePath(methodElement);
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin == null) {
            if (methodElement instanceof MethodConfiguration || methodElement instanceof MethodLibrary) {
                return string2;
            }
            System.err.println("error in MethodLibraryPersister.getElementPath(): plugin element without a valid plugin. This problem needs to be fixed.");
            return "";
        }
        if (methodPlugin.eContainer() == null) {
            System.err.println("error in MethodLibraryPersister.getElementPath(): plugin without library set. This problem needs to be fixed.");
            return "";
        }
        if (methodPlugin.eResource() != null) {
            Resource resource = UmaUtil.getMethodLibrary((EObject)methodPlugin).eResource();
            if (resource == methodPlugin.eResource()) {
                string = methodPlugin.getName();
            } else {
                URI uRI = MultiFileSaveUtil.getFinalURI(methodPlugin.eResource());
                URI uRI2 = MultiFileSaveUtil.getFinalURI(resource);
                URI uRI3 = uRI.deresolve(uRI2);
                string = uRI3.trimSegments(1).toFileString();
            }
        } else {
            string = methodPlugin.getName();
        }
        return string2.length() == 0 ? String.valueOf(string) + File.separator : new StringBuffer(string).append(File.separatorChar).append(string2).append(File.separatorChar).toString();
    }

    public static void main(String[] stringArray) {
        EClass eClass = UmaPackage.eINSTANCE.getTemplate();
        System.out.println(eClass.getName());
    }

    public void adjustLocation(Resource resource) {
        HashSet hashSet = new HashSet();
        MultiFileSaveUtil.adjustLocation(resource, hashSet);
        MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                multiFileResourceSetImpl.save((Resource)iterator.next(), null);
            }
            catch (Exception exception) {
                CommonPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public void save(Resource resource) throws Exception {
        MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)resource.getResourceSet();
        multiFileResourceSetImpl.save(resource, null);
    }

    protected void deleteFiles(MethodElement methodElement, String string, ResourceSet resourceSet) {
        if (new File(string).isDirectory() && !methodElement.eIsProxy()) {
            Iterator iterator = resourceSet.getResources().iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                MethodElement methodElement2 = PersistenceUtil.getMethodElement(resource);
                if (methodElement2 == null || !UmaUtil.isContainedBy((EObject)methodElement2, (Object)methodElement)) continue;
                resource.unload();
                iterator.remove();
            }
        }
        try {
            FileManager.getInstance().deleteResource(string, null);
        }
        catch (CoreException coreException) {
            CommonPlugin.INSTANCE.log((Object)coreException);
            throw new WrappedException((Exception)((Object)coreException));
        }
    }

    protected void delete(MethodElement methodElement, Set set) {
        Object object;
        MultiFileResourceSetImpl multiFileResourceSetImpl;
        block9: {
            if (!UmaUtil.hasDirectResource((EObject)methodElement)) {
                return;
            }
            MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)methodElement.eResource();
            multiFileResourceSetImpl = (MultiFileResourceSetImpl)multiFileXMIResourceImpl.getResourceSet();
            for (Object object2 : multiFileXMIResourceImpl.getContents()) {
                if (!(object2 instanceof MethodElement) || object2 == methodElement) continue;
                multiFileResourceSetImpl.removeURIMappings((EObject)methodElement, set);
                multiFileXMIResourceImpl.getContents().remove((Object)methodElement);
                set.add(multiFileXMIResourceImpl);
                return;
            }
            if (MultiFileSaveUtil.hasOwnFolder(methodElement)) {
                Object object2;
                object = new File(multiFileXMIResourceImpl.getFinalURI().toFileString()).getParent();
                object2 = new ArrayList();
                do {
                    object2.clear();
                    for (Resource resource : new ArrayList(multiFileResourceSetImpl.getResources())) {
                        MethodElement methodElement2;
                        if (!resource.isLoaded() || (methodElement2 = PersistenceUtil.getMethodElement(resource)) == null || !UmaUtil.isContainedBy((EObject)methodElement2, (Object)methodElement)) continue;
                        object2.add(resource);
                    }
                    for (Resource resource : object2) {
                        resource.unload();
                    }
                    multiFileResourceSetImpl.getResources().removeAll((Collection)object2);
                } while (!object2.isEmpty());
            } else {
                object = multiFileXMIResourceImpl.getFinalURI().toFileString();
            }
            try {
                multiFileResourceSetImpl.cleanUp(multiFileXMIResourceImpl, set);
            }
            catch (Exception exception) {
                CommonPlugin.INSTANCE.log((Object)exception);
                if (!MultiFileSaveUtil.DEBUG) break block9;
                exception.printStackTrace();
            }
        }
        this.deleteFiles(methodElement, (String)object, (ResourceSet)multiFileResourceSetImpl);
    }

    private static void getObjectsWithDirectResources(EObject eObject, Collection collection) {
        if (UmaUtil.hasDirectResource((EObject)eObject)) {
            collection.add(eObject);
        } else {
            Iterator iterator = eObject.eContents().iterator();
            while (iterator.hasNext()) {
                MethodLibraryPersister.getObjectsWithDirectResources((EObject)iterator.next(), collection);
            }
        }
    }

    public void delete(MethodElement methodElement) {
        ArrayList arrayList = new ArrayList();
        MethodLibraryPersister.getObjectsWithDirectResources((EObject)methodElement, arrayList);
        if (!arrayList.isEmpty()) {
            HashSet hashSet = new HashSet();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.delete((MethodElement)iterator.next(), hashSet);
            }
            for (Resource resource : hashSet) {
                try {
                    this.save(resource);
                }
                catch (Exception exception) {
                    throw new WrappedException(exception);
                }
            }
        }
    }

    private static String staticGetFolderRelativePath(MethodElement methodElement) {
        if (methodElement instanceof MethodPlugin) {
            return "";
        }
        if (methodElement instanceof ContentElement) {
            return MethodLibraryPersister.staticGetFolderPath(methodElement.eClass());
        }
        if (methodElement instanceof MethodConfiguration) {
            return "configurations";
        }
        MethodUnit methodUnit = UmaUtil.getMethodUnit((MethodElement)methodElement);
        if (methodUnit instanceof ProcessComponent) {
            Process process = ((ProcessComponent)methodUnit).getProcess();
            if (process instanceof CapabilityPattern) {
                return "capabilitypatterns";
            }
            if (process instanceof DeliveryProcess) {
                return "deliveryprocesses";
            }
        } else if (methodUnit instanceof ContentDescription) {
            return MethodLibraryPersister.staticGetFolderRelativePath((MethodElement)methodUnit.eContainer());
        }
        return "";
    }

    public String getFolderRelativePath(MethodElement methodElement) {
        return MethodLibraryPersister.staticGetFolderRelativePath(methodElement);
    }

    public List getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        return this.warnings;
    }

    FailSafePersister getFailSafePersister(Map map) {
        FailSafePersister failSafePersister = new FailSafePersister();
        failSafePersister.saveOptions.putAll(map);
        failSafePersister.saveOptions.put("TX_RECORD", failSafePersister.txRecord);
        return failSafePersister;
    }

    public boolean hasOwnFolder(Object object) {
        return MultiFileSaveUtil.hasOwnFolder(object);
    }

    public boolean hasOwnResource(Object object) {
        return MultiFileSaveUtil.hasOwnResource(object, MultiFileResourceSetImpl.DEFAULT_SAVE_SEPARATELY_CLASS_SET);
    }

    public ILibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
        return new FailSafePersister();
    }

    public String getFileExtension(Object object) {
        return ".xmi";
    }

    public void save(MethodElement methodElement) throws Exception {
        Object object;
        MultiFileXMIResourceImpl multiFileXMIResourceImpl;
        if (!this.hasOwnResourceWithoutReferrer(methodElement)) {
            return;
        }
        MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)UmaUtil.getMethodLibrary((EObject)methodElement).eResource().getResourceSet();
        Map map = multiFileResourceSetImpl.getDefaultSaveOptions();
        Resource.Internal internal = ((InternalEObject)methodElement).eDirectResource();
        if (internal instanceof MultiFileXMIResourceImpl) {
            multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)internal;
            multiFileResourceSetImpl.save(multiFileXMIResourceImpl, map);
        } else {
            object = MultiFileSaveUtil.createURI(methodElement, (ResourceSet)multiFileResourceSetImpl);
            multiFileXMIResourceImpl = MultiFileSaveUtil.save((ResourceSet)multiFileResourceSetImpl, (EObject)methodElement, object, map, false);
        }
        multiFileXMIResourceImpl.updateTimeStamps();
        object = (String)map.get("REFRESH_NEW_RESOURCE");
        if (object != null && Boolean.valueOf((String)object).booleanValue()) {
            RefreshJob.getInstance().resourceSaved(multiFileXMIResourceImpl);
            FileManager.getInstance().refresh(multiFileXMIResourceImpl);
        }
    }

    public boolean hasOwnResourceWithoutReferrer(Object object) {
        return object instanceof MethodConfiguration;
    }

    public File createMethodPluginFolder(String string, MethodLibrary methodLibrary) {
        File file = new File(methodLibrary.eResource().getURI().toFileString()).getParentFile();
        File file2 = new File(file, string);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new MultiFileIOException(NLS.bind((String)PersistenceResources.cannot_create_dir_msg, (Object)file2));
        }
        return file2;
    }

    public File getDefaultMethodConfigurationFolder(MethodLibrary methodLibrary) {
        File file = new File(methodLibrary.eResource().getURI().toFileString()).getParentFile();
        File file2 = new File(file, "configurations");
        if (!file2.exists() && !file2.mkdirs()) {
            throw new MultiFileIOException(NLS.bind((String)PersistenceResources.cannot_create_dir_msg, (Object)file2));
        }
        return file2;
    }

    public void setDefaultMethodConfigurationFolder(MethodLibrary methodLibrary, File file) {
    }

    public boolean isContainedBy(Resource resource, Resource resource2) {
        MethodElement methodElement = PersistenceUtil.getMethodElement(resource2);
        if (this.hasOwnFolder(methodElement)) {
            String string = FileManager.toFileString(resource.getURI());
            String string2 = FileManager.toFileString(resource2.getURI());
            if (string == null || string2 == null) {
                return false;
            }
            return new Path(string2).removeLastSegments(1).isPrefixOf((IPath)new Path(string));
        }
        return false;
    }

    public String getResourceFolderPath(MethodElement methodElement) {
        String string = this.getFolderAbsolutePath(methodElement);
        return string != null ? new File(string, RESOURCE_FOLDER).getAbsolutePath() : RESOURCE_FOLDER;
    }

    public String getFolderAbsolutePath(MethodElement methodElement) {
        MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)methodElement);
        File file = new File(MultiFileSaveUtil.getFinalURI(methodLibrary.eResource()).toFileString()).getParentFile();
        return new File(file, this.getRelativeElementPath(methodElement)).getAbsolutePath();
    }

    static class FailSafePersister
    extends MethodLibraryPersister
    implements ILibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions;
        private TxRecord txRecord = new TxRecord(){

            public void clear() {
                if (this.warnings != null && !this.warnings.isEmpty()) {
                    FailSafePersister.this.warnings = Collections.unmodifiableList(this.warnings);
                }
                super.clear();
            }
        };
        private Map elementToInfoMapToDeleteFiles;

        public FailSafePersister() {
            this.saveOptions = new HashMap(MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS);
            this.txRecord = new TxRecord();
            this.saveOptions.put("TX_RECORD", this.txRecord);
            this.elementToInfoMapToDeleteFiles = new HashMap();
        }

        public List getWarnings() {
            if (this.txRecord.getTxID() == null) {
                return super.getWarnings();
            }
            return this.txRecord.getWarnings();
        }

        public Map getSaveOptions() {
            return this.saveOptions;
        }

        void checkMove(Resource resource) {
            MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)resource;
            if (multiFileXMIResourceImpl.txStarted()) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.moveResourceError_msg, (Object)resource));
            }
        }

        public void save(Resource resource) throws Exception {
            if (resource.getResourceSet() instanceof MultiFileResourceSetImpl && resource instanceof MultiFileXMIResourceImpl) {
                Resource resource2;
                Object object;
                MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)resource.getResourceSet();
                if (multiFileResourceSetImpl == null) {
                    return;
                }
                Resource resource3 = null;
                MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
                if (methodElement != null && (object = UmaUtil.getMethodLibrary((EObject)methodElement)) != null && (resource2 = object.eResource()) != null && resource2 != resource && PersistenceUtil.checkToolVersion(resource2) != 0) {
                    resource3 = resource2;
                }
                if (MultiFileXMISaveImpl.checkModifyRequired(this.saveOptions)) {
                    if (resource3 != null) {
                        object = new ArrayList();
                        object.add(resource);
                        object.add(resource3);
                    } else {
                        object = Collections.singletonList(resource);
                    }
                    MultiFileSaveUtil.checkModify((Collection<Resource>)object);
                    MultiFileSaveUtil.checkOutOfSynch((Collection<Resource>)object, this.saveOptions);
                    MultiFileSaveUtil.checkFilePathLength((Collection)object);
                }
                multiFileResourceSetImpl.save(resource, this.saveOptions);
                if (resource3 != null) {
                    multiFileResourceSetImpl.save(resource3, this.saveOptions);
                }
            } else if (resource instanceof IFailSafeSavable) {
                IFailSafeSavable iFailSafeSavable = (IFailSafeSavable)resource;
                iFailSafeSavable.setTxID(this.txRecord.getTxID());
                resource.save(this.saveOptions);
                this.txRecord.getResourcesToCommit().add(resource);
            } else {
                throw new IllegalAccessException("Resource must implement org.eclipse.epf.library.persistence.internal.IFailSafeSavable");
            }
        }

        public void adjustLocation(Resource resource) {
            this.checkMove(resource);
            HashSet<Resource> hashSet = new HashSet<Resource>();
            if (MultiFileSaveUtil.prepareAdjustLocation((MultiFileXMIResourceImpl)resource, hashSet)) {
                this.txRecord.getResourcesToCommit().add(resource);
                HashSet<Resource> hashSet2 = new HashSet<Resource>(hashSet);
                hashSet2.addAll(hashSet2);
                MultiFileSaveUtil.checkModify(hashSet2);
                if (!hashSet.isEmpty()) {
                    MultiFileSaveUtil.checkOutOfSynch(hashSet, this.saveOptions);
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        try {
                            this.save((Resource)iterator.next());
                        }
                        catch (Exception exception) {
                            PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
                            throw new MultiFileIOException(exception.toString());
                        }
                    }
                }
            }
            this.commit();
        }

        public void adjustLocation(Collection collection) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Object object = collection.iterator();
            while (object.hasNext()) {
                this.checkMove((Resource)object.next());
            }
            object = new HashSet();
            HashSet<Resource> hashSet = new HashSet<Resource>();
            for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : collection) {
                if (!MultiFileSaveUtil.prepareAdjustLocation(multiFileXMIResourceImpl, (Set)object)) continue;
                this.txRecord.getResourcesToCommit().add(multiFileXMIResourceImpl);
                hashSet.add(multiFileXMIResourceImpl);
            }
            hashSet.addAll((Collection<Resource>)object);
            if (!hashSet.isEmpty()) {
                MultiFileSaveUtil.checkModify(hashSet);
            }
            if (!object.isEmpty()) {
                MultiFileSaveUtil.checkOutOfSynch((Collection<Resource>)object, this.saveOptions);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    try {
                        this.save((Resource)iterator.next());
                    }
                    catch (Exception exception) {
                        CommonPlugin.INSTANCE.log((Object)exception);
                        throw new MultiFileIOException(exception.toString());
                    }
                }
            }
            this.commit();
        }

        protected void deleteFiles(MethodElement methodElement, String string, ResourceSet resourceSet) {
            this.elementToInfoMapToDeleteFiles.put(methodElement, new Object[]{string, resourceSet});
        }

        private void superDeleteFiles(MethodElement methodElement, String string, ResourceSet resourceSet) {
            super.deleteFiles(methodElement, string, resourceSet);
        }

        public void commit() {
            int n = this.txRecord.getResourcesToCommit().size();
            int n2 = 0;
            while (n2 < n) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(n2)).commit();
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(n2)).txFinished(true);
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(n2)).deleteBackup();
                ++n2;
            }
            this.txRecord.clear();
            for (Map.Entry entry : this.elementToInfoMapToDeleteFiles.entrySet()) {
                Object[] objectArray = (Object[])entry.getValue();
                String string = (String)objectArray[0];
                try {
                    this.superDeleteFiles((MethodElement)entry.getKey(), string, (ResourceSet)objectArray[1]);
                }
                catch (Exception exception) {
                    IStatus iStatus;
                    Exception exception2;
                    if (exception instanceof WrappedException) {
                        exception2 = ((WrappedException)exception).exception();
                    }
                    String string2 = PersistenceResources.ErrMsg_CouldNotDelete;
                    String string3 = null;
                    if (exception2 instanceof CoreException && (iStatus = ((CoreException)((Object)exception2)).getStatus()) != null) {
                        string3 = UmaUtil.getMessage((IStatus)iStatus);
                    }
                    if (string3 == null) {
                        string3 = "";
                    }
                    string2 = MessageFormat.format(string2, string, string3);
                    exception2 = new Exception(string2, exception2);
                    this.getWarnings().add(exception2);
                    CommonPlugin.INSTANCE.log((Object)exception2);
                    if (!MultiFileSaveUtil.DEBUG) continue;
                    exception2.printStackTrace();
                }
            }
            this.elementToInfoMapToDeleteFiles.clear();
        }

        public void rollback() {
            if (!this.txRecord.getResourcesToCommit().isEmpty()) {
                try {
                    IFailSafeSavable iFailSafeSavable2;
                    int n = this.txRecord.getResourcesToCommit().size() - 1;
                    ArrayList<IFailSafeSavable> arrayList = new ArrayList<IFailSafeSavable>();
                    int n2 = n;
                    while (n2 > -1) {
                        iFailSafeSavable2 = (IFailSafeSavable)this.txRecord.getResourcesToCommit().get(n2);
                        if (iFailSafeSavable2.restore()) {
                            arrayList.add(iFailSafeSavable2);
                        }
                        --n2;
                    }
                    for (IFailSafeSavable iFailSafeSavable2 : arrayList) {
                        iFailSafeSavable2.setModified(true);
                    }
                    int n3 = n;
                    while (n3 > -1) {
                        block12: {
                            iFailSafeSavable2 = (Resource)this.txRecord.getResourcesToCommit().get(n3);
                            if (iFailSafeSavable2.hasTempURI()) {
                                try {
                                    new File(iFailSafeSavable2.getURI().toFileString()).delete();
                                }
                                catch (Exception exception) {
                                    CommonPlugin.INSTANCE.log((Object)exception);
                                    if (!MultiFileSaveUtil.DEBUG) break block12;
                                    exception.printStackTrace();
                                }
                            }
                        }
                        --n3;
                    }
                    n3 = n;
                    while (n3 > -1) {
                        ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(n3)).txFinished(false);
                        --n3;
                    }
                }
                catch (RuntimeException runtimeException) {
                    CommonPlugin.INSTANCE.log((Object)runtimeException);
                    if (MultiFileSaveUtil.DEBUG) {
                        runtimeException.printStackTrace();
                    }
                    throw runtimeException;
                }
            }
            this.txRecord.clear();
        }

        public ILibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
            return this;
        }

        public String getCurrentTxID() {
            return this.txRecord.getTxID();
        }
    }

    private static class FolderInfo {
        EClass eClazz;
        boolean shared;
        private String name;

        public FolderInfo(EClass eClass, boolean bl) {
            this.eClazz = eClass;
            this.shared = bl;
            this.name = MethodLibraryPersister.lowerAndPluralize(eClass.getName());
        }
    }

    public static class NonFailSafePersister
    extends MethodLibraryPersister
    implements ILibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions = new HashMap();

        public void commit() {
        }

        public void rollback() {
        }

        public String getCurrentTxID() {
            return null;
        }

        public void adjustLocation(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.adjustLocation((Resource)iterator.next());
            }
        }

        public Map getSaveOptions() {
            return this.saveOptions;
        }
    }
}

