/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;

public class MultiFileXMIHelperImpl
extends XMIHelperImpl {
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected boolean logError = true;
    protected List sameDocReferences = new UniqueEList();
    private boolean discardUnresolvedRef;

    public MultiFileXMIHelperImpl(MultiFileXMIResourceImpl multiFileXMIResourceImpl) {
        super((XMLResource)multiFileXMIResourceImpl);
        Boolean bl = (Boolean)((MultiFileResourceSetImpl)multiFileXMIResourceImpl.getResourceSet()).getDefaultSaveOptions().get("DISCARD_UNRESOLVED_REFERENCES");
        this.discardUnresolvedRef = bl != null ? bl : false;
    }

    public void setResource(XMLResource xMLResource) {
        super.setResource(xMLResource);
        if (xMLResource instanceof MultiFileXMIResourceImpl) {
            this.resourceURI = ((MultiFileXMIResourceImpl)xMLResource).getFinalURI();
            this.deresolve = this.resourceURI != null && !this.resourceURI.isRelative() && this.resourceURI.isHierarchical();
        }
    }

    public String getHREF(EObject eObject) {
        if (this.discardUnresolvedRef && eObject instanceof MultiResourceEObject && !((MultiResourceEObject)eObject).isValid()) {
            return null;
        }
        if (eObject instanceof MultiResourceEObject) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            URI uRI = internalEObject.eProxyURI();
            if (uRI == null) {
                Resource resource = eObject.eResource();
                if (resource == null) {
                    uRI = this.handleDanglingHREF(eObject);
                    if (uRI == null) {
                        return null;
                    }
                } else {
                    EObject eObject2;
                    if (this.resource == resource) {
                        return "#" + this.resource.getURIFragment(eObject);
                    }
                    if (eObject instanceof MethodConfiguration) {
                        eObject2 = eObject.eContainer();
                        if (eObject2 != null) {
                            resource = eObject2.eResource();
                        } else {
                            return null;
                        }
                    }
                    if (resource != null) {
                        eObject2 = resource.getResourceSet();
                        if (eObject2 instanceof MultiFileResourceSetImpl && ((MultiFileResourceSetImpl)eObject2).getResourceManager() == null) {
                            uRI = MultiFileSaveUtil.getFinalURI(resource).appendFragment(this.getURIFragment(resource, eObject));
                            return this.deresolve(uRI).toString();
                        }
                        ResourceDescriptor resourceDescriptor = MultiFileSaveUtil.getResourceDescriptor(resource);
                        if (resourceDescriptor != null) {
                            uRI = MultiFileURIConverter.createURI(resourceDescriptor.getId()).appendFragment(this.getURIFragment(resource, eObject));
                            return uRI.toString();
                        }
                        return null;
                    }
                }
            } else {
                if (!uRI.scheme().equals("uma")) {
                    String string = uRI.fragment();
                    if (this.resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)this.resource).getEObjectByID(string) != null) {
                        return "#" + string;
                    }
                    uRI = this.deresolve(uRI);
                }
                return uRI.toString();
            }
        }
        return super.getHREF(eObject);
    }

    public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        int n2 = this.getFeatureKind(eStructuralFeature);
        try {
            List list;
            if (n2 == 4) {
                list = (List)eObject.eGet(eStructuralFeature);
                if (n > -1 && list.indexOf(object) == -1) {
                    return;
                }
            }
            super.setValue(eObject, eStructuralFeature, object, n);
            switch (n2) {
                case 3: 
                case 4: {
                    EReference eReference;
                    list = (InternalEList)eObject.eGet(eStructuralFeature);
                    if (eStructuralFeature instanceof EReference && (eReference = (EReference)eStructuralFeature).getEOpposite() != null) {
                        InternalEObject internalEObject = (InternalEObject)eObject;
                        Iterator iterator = list.basicIterator();
                        while (iterator.hasNext()) {
                            InternalEObject internalEObject2 = (InternalEObject)iterator.next();
                            if (!internalEObject2.eIsProxy() || !internalEObject2.eProxyURI().trimFragment().equals((Object)this.resourceURI)) continue;
                            this.sameDocReferences.add(new ProxyReference(internalEObject, eReference, internalEObject2));
                        }
                    }
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.logError) {
                if (MultiFileSaveUtil.DEBUG) {
                    runtimeException.printStackTrace();
                }
                CommonPlugin.INSTANCE.log((Object)runtimeException);
                String string = new StringBuffer("MultiFileXMIHelperImpl.setValue(): ERROR").append("\n  object: ").append(eObject).append("\n  feature: ").append(eStructuralFeature).append("\n  value: ").append(object).append("\n  position: ").append(n).append("\n  kind: ").append(n2).toString();
                if (MultiFileSaveUtil.DEBUG) {
                    System.err.println(string);
                }
                CommonPlugin.INSTANCE.log((Object)string);
            }
            throw runtimeException;
        }
    }

    public Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        Object object = super.getValue(eObject, eStructuralFeature);
        if (eStructuralFeature instanceof EReference) {
            if (eStructuralFeature.isMany()) {
                if (eStructuralFeature.isChangeable() && object instanceof InternalEList) {
                    InternalEList internalEList = (InternalEList)object;
                    Iterator iterator = internalEList.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject2 = (EObject)iterator.next();
                        if (eObject2.eIsProxy() || eObject2.eResource() != null) continue;
                        iterator.remove();
                    }
                }
            } else {
                EObject eObject3 = (EObject)object;
                if (!eObject3.eIsProxy() && eObject3.eResource() == null) {
                    object = null;
                }
            }
        }
        return object;
    }

    protected static class ProxyReference {
        private InternalEObject owner;
        private EReference reference;
        private InternalEObject proxy;

        public ProxyReference(InternalEObject internalEObject, EReference eReference, InternalEObject internalEObject2) {
            this.owner = internalEObject;
            this.reference = eReference;
            this.proxy = internalEObject2;
        }

        public InternalEObject getOwner() {
            return this.owner;
        }

        public InternalEObject getProxy() {
            return this.proxy;
        }

        public EReference getReference() {
            return this.reference;
        }
    }
}

