/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.util.PatternConstructor;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class UnresolvedProxyMarkerManager
extends WorkspaceJob
implements IProxyResolutionListener {
    private static final long DELAY = 0L;
    public static final String MARKER_ID = String.valueOf(PersistencePlugin.getDefault().getId()) + ".unresolvedProxyMarker";
    public static final String PROXY_URI = "proxyURI";
    public static final String OWNER_GUID = "ownerGUID";
    private Map uriToExceptionsMap;
    private List exceptions;
    private Map resourceGUIToMarkersMap;
    private Map elementGUIToMarkersMap;
    private ResourceSet resourceSet;
    private boolean enabled;
    private List resourcesToValidateMarkers;
    private boolean autoScheduled = true;

    public UnresolvedProxyMarkerManager(ResourceSet resourceSet) {
        super(PersistenceResources.unresolvedProxyLoggerJob_name);
        this.resourceSet = resourceSet;
        this.uriToExceptionsMap = new HashMap();
        this.exceptions = new ArrayList();
        this.resourceGUIToMarkersMap = new HashMap();
        this.elementGUIToMarkersMap = new HashMap();
        this.resourcesToValidateMarkers = new UniqueEList();
    }

    public IMarker findMarker(IFile iFile, String string, int n, int n2) throws CoreException {
        IMarker[] iMarkerArray = iFile.findMarkers(MARKER_ID, false, 0);
        int n3 = 0;
        while (n3 < iMarkerArray.length) {
            IMarker iMarker = iMarkerArray[n3];
            if (string.equals(iMarker.getAttribute(PROXY_URI)) && iMarker.getAttribute("charStart", -1) == n && iMarker.getAttribute("charEnd", -1) == n2) {
                return iMarker;
            }
            ++n3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addException(ResolveException resolveException) {
        List list = this.exceptions;
        synchronized (list) {
            block5: {
                URI uRI = ((InternalEObject)resolveException.getProxy()).eProxyURI();
                HashSet<ResolveException> hashSet = (HashSet<ResolveException>)this.uriToExceptionsMap.get(uRI);
                if (hashSet == null) {
                    hashSet = new HashSet<ResolveException>();
                    this.uriToExceptionsMap.put(uRI, hashSet);
                }
                if (!hashSet.add(resolveException)) break block5;
                this.exceptions.add(resolveException);
                return true;
            }
            return false;
        }
    }

    private void addMarker(Resource resource, URI uRI, String string, String string2, IProgressMonitor iProgressMonitor) {
        block9: {
            URI uRI2 = resource.getURI();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(uRI2.toFileString());
            IFile iFile = iWorkspace.getRoot().getFileForLocation((IPath)path);
            if (iFile != null) {
                String string3 = uRI2 != null ? uRI2.toFileString() : "";
                try {
                    iFile.refreshLocal(0, null);
                    ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
                    try {
                        iTextFileBufferManager.connect((IPath)path, iProgressMonitor);
                        ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer((IPath)path);
                        iTextFileBuffer.requestSynchronizationContext();
                        iTextFileBuffer.getDocument();
                        IDocument iDocument = iTextFileBuffer.getDocument();
                        if (iDocument != null) {
                            String string4 = uRI.toString();
                            Pattern pattern = PatternConstructor.createPattern(string4, true, false);
                            Matcher matcher = pattern.matcher(new DocumentCharSequence(iDocument));
                            while (matcher.find()) {
                                int n;
                                int n2 = matcher.start();
                                if (n2 == (n = matcher.end()) || resource == null || resource.getResourceSet() == null) continue;
                                IMarker iMarker = this.findMarker(iFile, string4, n2, n);
                                if (iMarker == null) {
                                    iMarker = iFile.createMarker(MARKER_ID);
                                    iMarker.setAttribute("severity", 2);
                                    iMarker.setAttribute("message", (Object)string);
                                    iMarker.setAttribute("location", (Object)string3);
                                    iMarker.setAttribute("transient", true);
                                    iMarker.setAttribute("charStart", n2);
                                    iMarker.setAttribute("charEnd", n);
                                    iMarker.setAttribute(PROXY_URI, (Object)string4);
                                    iMarker.setAttribute(OWNER_GUID, (Object)string2);
                                    this.cacheMarker(iMarker, uRI);
                                    continue;
                                }
                                iMarker.setAttribute(OWNER_GUID, (Object)string2);
                            }
                        }
                        iTextFileBuffer.releaseSynchronizationContext();
                    }
                    finally {
                        iTextFileBufferManager.disconnect((IPath)path, iProgressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    CommonPlugin.INSTANCE.log((Object)coreException);
                    if (!MultiFileSaveUtil.DEBUG) break block9;
                    coreException.printStackTrace();
                }
            }
        }
    }

    private void addMarker(ResolveException resolveException, IProgressMonitor iProgressMonitor) {
        InternalEObject internalEObject = (InternalEObject)resolveException.getProxy();
        URI uRI = null;
        Resource resource = null;
        if (resolveException.getResolver() != null && (resource = resolveException.getResolver().eResource()) != null && resource.getResourceSet() != null) {
            uRI = resource.getURI();
        }
        if (uRI != null) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(uRI.toFileString());
            IFile iFile = iWorkspace.getRoot().getFileForLocation((IPath)path);
            if (iFile != null) {
                String string = resolveException.exception() != null && resolveException.exception().getLocalizedMessage() != null && resolveException.exception().getLocalizedMessage().trim().length() > 0 ? resolveException.exception().getLocalizedMessage() : (resolveException.getMessage() == null ? NLS.bind((String)PersistenceResources.UnresolvedProxyMarkerManager_couldNotResolveProxy, (Object)internalEObject.eProxyURI()) : resolveException.getMessage());
                this.addMarker(resource, internalEObject.eProxyURI(), string, MultiFileSaveUtil.getGuid(resolveException.getResolver()), iProgressMonitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMarker(IMarker iMarker, URI uRI) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            HashSet<Object> hashSet;
            Object object;
            String string = uRI.authority();
            if (string != null) {
                object = (ValidObject)this.resourceGUIToMarkersMap.get(string);
                if (object == null) {
                    object = new ValidObject(new HashSet());
                    this.resourceGUIToMarkersMap.put(string, object);
                }
                hashSet = (Collection)((ValidObject)object).object;
                hashSet.add(iMarker);
            }
            if ((hashSet = (HashSet<Object>)this.elementGUIToMarkersMap.get(object = uRI.fragment())) == null) {
                hashSet = new HashSet<Object>();
                this.elementGUIToMarkersMap.put(object, hashSet);
            }
            hashSet.add(new ValidObject(iMarker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        boolean bl = this.enabled;
        try {
            this.enabled = false;
            this.cancel();
            Object object = this.exceptions;
            synchronized (object) {
                this.uriToExceptionsMap.clear();
                this.exceptions.clear();
            }
            object = this.elementGUIToMarkersMap;
            synchronized (object) {
                if (!this.elementGUIToMarkersMap.isEmpty()) {
                    for (Collection collection : this.elementGUIToMarkersMap.values()) {
                        for (ValidObject validObject : collection) {
                            IMarker iMarker = (IMarker)validObject.object;
                            try {
                                if (!iMarker.exists()) continue;
                                iMarker.delete();
                            }
                            catch (Exception exception) {
                                CommonPlugin.INSTANCE.log((Object)exception);
                            }
                        }
                        collection.clear();
                    }
                    this.elementGUIToMarkersMap.clear();
                    this.resourceGUIToMarkersMap.clear();
                }
            }
            object = this.resourcesToValidateMarkers;
            synchronized (object) {
                this.resourcesToValidateMarkers.clear();
            }
        }
        finally {
            this.enabled = bl;
        }
    }

    public boolean hasUnresolvedProxy() {
        return !this.elementGUIToMarkersMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveException nextException() {
        List list = this.exceptions;
        synchronized (list) {
            block6: {
                if (!this.exceptions.isEmpty()) break block6;
                return null;
            }
            ResolveException resolveException = (ResolveException)this.exceptions.remove(0);
            URI uRI = ((InternalEObject)resolveException.getProxy()).eProxyURI();
            Collection collection = (Collection)this.uriToExceptionsMap.get(uRI);
            if (collection != null) {
                collection.remove(resolveException);
                if (collection.isEmpty()) {
                    this.uriToExceptionsMap.remove(uRI);
                }
            }
            return resolveException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource nextResourceToValidateMarkers() {
        List list = this.resourcesToValidateMarkers;
        synchronized (list) {
            block4: {
                if (!this.resourcesToValidateMarkers.isEmpty()) break block4;
                return null;
            }
            return (Resource)this.resourcesToValidateMarkers.remove(0);
        }
    }

    private void yield() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Exception decompiling
     */
    public IStatus runInWorkspace(IProgressMonitor var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean removeFromResourceGUIDToMarkersMap(String string, IMarker iMarker) {
        ValidObject validObject;
        URI uRI = URI.createURI((String)string);
        String string2 = uRI.authority();
        if (string2 != null && (validObject = (ValidObject)this.resourceGUIToMarkersMap.get(string2)) != null) {
            Collection collection = (Collection)validObject.object;
            boolean bl = collection.remove(iMarker);
            if (collection.isEmpty()) {
                this.resourceGUIToMarkersMap.remove(string2);
            }
            return bl;
        }
        return false;
    }

    private void removeFromElementGUIDToMarkersMap(String string, IMarker iMarker) {
        Collection collection;
        URI uRI = URI.createURI((String)string);
        String string2 = uRI.fragment();
        if (string2 != null && (collection = (Collection)this.elementGUIToMarkersMap.get(string2)) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ValidObject validObject = (ValidObject)iterator.next();
                if (validObject.object != iMarker) continue;
                iterator.remove();
            }
            if (collection.isEmpty()) {
                this.elementGUIToMarkersMap.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMarkers(IProgressMonitor iProgressMonitor) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            String string;
            IMarker iMarker;
            Object object;
            Object object2;
            for (Object object3 : this.elementGUIToMarkersMap.values()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (ValidObject)object2.next();
                    if (((ValidObject)object).valid) continue;
                    try {
                        iMarker = (IMarker)((ValidObject)object).object;
                        if (iMarker.exists()) {
                            string = (String)iMarker.getAttribute(PROXY_URI);
                            iMarker.delete();
                            this.removeFromResourceGUIDToMarkersMap(string, iMarker);
                        }
                        object2.remove();
                    }
                    catch (Exception exception) {
                        CommonPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
            Iterator iterator = this.resourceGUIToMarkersMap.values().iterator();
            while (iterator.hasNext()) {
                Object object3;
                object3 = (ValidObject)iterator.next();
                if (((ValidObject)object3).valid) continue;
                ((ValidObject)object3).valid = true;
                object2 = (Collection)((ValidObject)object3).object;
                object = object2.iterator();
                while (object.hasNext()) {
                    try {
                        iMarker = (IMarker)object.next();
                        if (iMarker.exists()) {
                            string = (String)iMarker.getAttribute(PROXY_URI);
                            URI uRI = URI.createURI((String)string);
                            String string2 = uRI.fragment();
                            EObject eObject = (EObject)((MultiFileResourceSetImpl)this.resourceSet).getGuidToMethodElementMap().get(string2);
                            if (eObject == null || eObject.eIsProxy()) continue;
                            iMarker.delete();
                            object.remove();
                            this.removeFromElementGUIDToMarkersMap(string, iMarker);
                            continue;
                        }
                        object.remove();
                    }
                    catch (Exception exception) {
                        CommonPlugin.INSTANCE.log((Object)exception);
                    }
                }
                if (!object2.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void notifyException(Exception exception) {
        ResolveException resolveException;
        if (!this.enabled) {
            return;
        }
        if (exception instanceof ResolveException && this.addException(resolveException = (ResolveException)exception) && this.autoScheduled) {
            this.schedule(0L);
        }
    }

    public void setAutoScheduled(boolean bl) {
        this.autoScheduled = bl;
    }

    public boolean isAutoScheduled() {
        return this.autoScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        if (!this.enabled) {
            return false;
        }
        List list = this.exceptions;
        synchronized (list) {
            block5: {
                if (this.exceptions.isEmpty()) break block5;
                this.schedule(0L);
                return true;
            }
            return false;
        }
    }

    public void proxyResolved(Object object, Object object2) {
        if (!this.enabled) {
            return;
        }
        if (object instanceof InternalEObject) {
            URI uRI = ((InternalEObject)object).eProxyURI();
            this.removeExceptions(uRI);
            if (this.invalidateMarkers(uRI)) {
                this.schedule(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidateMarkers(URI uRI) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            Collection collection;
            Object object;
            boolean bl = false;
            String string = uRI.authority();
            if (string != null && (object = (ValidObject)this.resourceGUIToMarkersMap.get(string)) != null) {
                ((ValidObject)object).valid = false;
                bl = true;
            }
            if ((object = uRI.fragment()) != null && (collection = (Collection)this.elementGUIToMarkersMap.get(object)) != null && !collection.isEmpty()) {
                bl = true;
                for (ValidObject validObject : collection) {
                    validObject.valid = false;
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExceptions(URI uRI) {
        List list = this.exceptions;
        synchronized (list) {
            Collection collection = (Collection)this.uriToExceptionsMap.get(uRI);
            if (collection == null || collection.isEmpty()) {
                return;
            }
            this.exceptions.removeAll(collection);
            this.uriToExceptionsMap.remove(uRI);
        }
    }

    public void clearMarkers(Resource resource) {
        try {
            IResource iResource = FileManager.getResourceForLocation(resource.getURI().toFileString());
            if (iResource instanceof IFile) {
                IMarker[] iMarkerArray = iResource.findMarkers(MARKER_ID, false, 0);
                int n = 0;
                while (n < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n];
                    this.removeMarker(iMarker);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarker(IMarker iMarker) {
        String string = null;
        try {
            if (iMarker.exists()) {
                string = (String)iMarker.getAttribute(PROXY_URI);
                iMarker.delete();
            }
        }
        catch (Exception exception) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        if (string != null) {
            Map map = this.elementGUIToMarkersMap;
            synchronized (map) {
                this.removeFromElementGUIDToMarkersMap(string, iMarker);
                this.removeFromResourceGUIDToMarkersMap(string, iMarker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMarkers(Resource resource) {
        boolean bl = false;
        List list = this.resourcesToValidateMarkers;
        synchronized (list) {
            bl = this.resourcesToValidateMarkers.add(resource);
        }
        if (bl) {
            this.schedule(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAllMarkers() {
        boolean bl = false;
        List list = this.resourcesToValidateMarkers;
        synchronized (list) {
            if (!this.elementGUIToMarkersMap.isEmpty()) {
                for (Collection collection : this.elementGUIToMarkersMap.values()) {
                    for (ValidObject validObject : collection) {
                        IMarker iMarker = (IMarker)validObject.object;
                        try {
                            String string = (String)iMarker.getAttribute("location");
                            URI uRI = URI.createFileURI((String)string);
                            Resource resource = this.resourceSet.getResource(uRI, true);
                            bl = this.resourcesToValidateMarkers.add(resource) | bl;
                        }
                        catch (CoreException coreException) {
                            PersistencePlugin.getDefault().getLogger().logError((Throwable)coreException);
                        }
                    }
                }
            }
        }
        if (bl) {
            this.schedule(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doValidateMarkers(Resource resource) {
        block13: {
            try {
                IResource iResource = FileManager.getResourceForLocation(resource.getURI().toFileString());
                if (!(iResource instanceof IFile)) break block13;
                IMarker[] iMarkerArray = iResource.findMarkers(MARKER_ID, false, 0);
                HashSet<Object> hashSet = new HashSet<Object>();
                int n = 0;
                while (n < iMarkerArray.length) {
                    IMarker object = iMarkerArray[n];
                    String string = (String)object.getAttribute(PROXY_URI);
                    if (string != null) {
                        Object object2;
                        URI uRI = URI.createURI((String)string);
                        String string2 = uRI.fragment();
                        EObject eObject = (EObject)((MultiFileResourceSetImpl)this.resourceSet).getGuidToMethodElementMap().get(string2);
                        if (eObject == null || eObject.eIsProxy()) {
                            object2 = new MarkerInfo();
                            ((MarkerInfo)object2).message = (String)object.getAttribute("message");
                            ((MarkerInfo)object2).ownerGUID = (String)object.getAttribute(OWNER_GUID);
                            ((MarkerInfo)object2).proxyURI = string;
                            hashSet.add(object2);
                        }
                        if (object.exists()) {
                            try {
                                object.delete();
                            }
                            catch (Exception exception) {
                                PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
                            }
                        }
                        object2 = this.elementGUIToMarkersMap;
                        synchronized (object2) {
                            this.removeFromElementGUIDToMarkersMap(string, object);
                            this.removeFromResourceGUIDToMarkersMap(string, object);
                        }
                    }
                    ++n;
                }
                if (!hashSet.isEmpty()) {
                    for (MarkerInfo markerInfo : hashSet) {
                        this.addMarker(resource, URI.createURI((String)markerInfo.proxyURI), markerInfo.message, markerInfo.ownerGUID, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
            catch (Exception exception) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    private static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;

        public DocumentCharSequence(IDocument iDocument) {
            this.fDocument = iDocument;
        }

        public int length() {
            return this.fDocument.getLength();
        }

        public char charAt(int n) {
            try {
                return this.fDocument.getChar(n);
            }
            catch (BadLocationException badLocationException) {
                throw new IndexOutOfBoundsException(badLocationException.getLocalizedMessage());
            }
        }

        public CharSequence subSequence(int n, int n2) {
            try {
                return this.fDocument.get(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                throw new IndexOutOfBoundsException(badLocationException.getLocalizedMessage());
            }
        }
    }

    private static class MarkerInfo {
        String proxyURI;
        String ownerGUID;
        String message;

        private MarkerInfo() {
        }

        public boolean equals(Object object) {
            if (object instanceof MarkerInfo) {
                MarkerInfo markerInfo = (MarkerInfo)object;
                if (this.proxyURI != null && this.ownerGUID != null && this.proxyURI.equals(markerInfo.proxyURI) && this.ownerGUID.equals(markerInfo.ownerGUID)) {
                    return true;
                }
            }
            return super.equals(object);
        }

        public int hashCode() {
            int n = this.proxyURI.hashCode();
            n ^= this.ownerGUID.hashCode();
            return n ^= this.message.hashCode();
        }
    }

    private static class ValidObject {
        boolean valid;
        Object object;

        public ValidObject(Object object) {
            this.object = object;
            this.valid = true;
        }
    }
}

