/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.resourcemanager.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerPackage;
import org.eclipse.epf.resourcemanager.impl.ResourceDescriptorImpl;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;

public class ResourceManagerImpl
extends MultiResourceEObject
implements ResourceManager {
    private static final long serialVersionUID = -5164471475509169204L;
    protected static final String GUID_EDEFAULT = null;
    protected String guid = GUID_EDEFAULT;
    protected static final String URI_BASE_EDEFAULT = null;
    protected String uriBase = URI_BASE_EDEFAULT;
    protected EList subManagers = null;
    protected EList resourceDescriptors = null;
    private Map idToResourceDescriptorMap;

    protected ResourceManagerImpl() {
        this.guid = UmaUtil.generateGUID();
    }

    protected EClass eStaticClass() {
        return ResourcemanagerPackage.Literals.RESOURCE_MANAGER;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String string) {
        String string2 = this.guid;
        this.guid = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)string2, (Object)this.guid));
        }
    }

    public String getUriBase() {
        return this.uriBase;
    }

    public void setUriBase(String string) {
        String string2 = this.uriBase;
        this.uriBase = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)string2, (Object)this.uriBase));
        }
    }

    public List getSubManagers() {
        if (this.subManagers == null) {
            this.subManagers = new EObjectContainmentEList.Resolving(ResourceManager.class, (InternalEObject)this, 2);
        }
        return this.subManagers;
    }

    public List getResourceDescriptors() {
        if (this.resourceDescriptors == null) {
            this.resourceDescriptors = new EObjectContainmentEList.Resolving(ResourceDescriptor.class, (InternalEObject)this, 3);
        }
        return this.resourceDescriptors;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (guid: ");
        stringBuffer.append(this.guid);
        stringBuffer.append(", uriBase: ");
        stringBuffer.append(this.uriBase);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public EObject eResolveProxy(InternalEObject internalEObject) {
        return super.eResolveProxy(internalEObject);
    }

    public void resolve() {
        URI uRI = MultiFileSaveUtil.getFinalURI(this.eResource());
        for (ResourceDescriptorImpl resourceDescriptorImpl : this.getResourceDescriptors()) {
            resourceDescriptorImpl.resolvedURI = URI.createURI((String)resourceDescriptorImpl.getUri()).resolve(uRI);
        }
    }

    public void deresolve() {
        URI uRI = MultiFileSaveUtil.getFinalURI(this.eResource());
        for (ResourceDescriptor resourceDescriptor : this.getResourceDescriptors()) {
            resourceDescriptor.setUri(resourceDescriptor.getResolvedURI().deresolve(uRI).toString());
        }
    }

    public List removeResourceDescriptor(URI uRI, boolean bl) {
        Object object;
        ArrayList<ResourceDescriptor> arrayList = new ArrayList<ResourceDescriptor>();
        Object object2 = this.getResourceDescriptors().iterator();
        while (object2.hasNext()) {
            object = (ResourceDescriptor)object2.next();
            if (!uRI.equals((Object)object.getResolvedURI().trimFragment())) continue;
            object2.remove();
            arrayList.add((ResourceDescriptor)object);
        }
        if (bl) {
            object2 = String.valueOf(new File(uRI.toFileString()).getParent()) + File.separator;
            object = this.getResourceDescriptors().iterator();
            while (object.hasNext()) {
                ResourceDescriptor resourceDescriptor = (ResourceDescriptor)object.next();
                if (!resourceDescriptor.getResolvedURI().toFileString().startsWith((String)object2)) continue;
                object.remove();
                arrayList.add(resourceDescriptor);
            }
        }
        return arrayList;
    }

    public ResourceDescriptor getResourceDescriptor(String string) {
        if (this.idToResourceDescriptorMap == null) {
            this.idToResourceDescriptorMap = new HashMap();
            this.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    switch (notification.getFeatureID(ResourceManager.class)) {
                        case 3: {
                            switch (notification.getEventType()) {
                                case 3: {
                                    ResourceDescriptor resourceDescriptor = (ResourceDescriptor)notification.getNewValue();
                                    ResourceManagerImpl.this.idToResourceDescriptorMap.put(resourceDescriptor.getId(), resourceDescriptor);
                                    return;
                                }
                                case 5: {
                                    for (ResourceDescriptor resourceDescriptor : (Collection)notification.getNewValue()) {
                                        ResourceManagerImpl.this.idToResourceDescriptorMap.put(resourceDescriptor.getId(), resourceDescriptor);
                                    }
                                    return;
                                }
                                case 4: {
                                    ResourceManagerImpl.this.idToResourceDescriptorMap.remove(((ResourceDescriptor)notification.getOldValue()).getId());
                                    return;
                                }
                                case 6: {
                                    Iterator iterator = ((Collection)notification.getOldValue()).iterator();
                                    while (iterator.hasNext()) {
                                        ResourceManagerImpl.this.idToResourceDescriptorMap.remove(((ResourceDescriptor)iterator.next()).getId());
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
            });
            for (ResourceDescriptor resourceDescriptor : this.getResourceDescriptors()) {
                this.idToResourceDescriptorMap.put(resourceDescriptor.getId(), resourceDescriptor);
            }
        }
        return (ResourceDescriptor)this.idToResourceDescriptorMap.get(string);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 2: {
                return ((InternalEList)this.getSubManagers()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 3: {
                return ((InternalEList)this.getResourceDescriptors()).basicRemove((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 0: {
                return this.getGuid();
            }
            case 1: {
                return this.getUriBase();
            }
            case 2: {
                return this.getSubManagers();
            }
            case 3: {
                return this.getResourceDescriptors();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 0: {
                this.setGuid((String)object);
                return;
            }
            case 1: {
                this.setUriBase((String)object);
                return;
            }
            case 2: {
                this.getSubManagers().clear();
                this.getSubManagers().addAll((Collection)object);
                return;
            }
            case 3: {
                this.getResourceDescriptors().clear();
                this.getResourceDescriptors().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 0: {
                this.setGuid(GUID_EDEFAULT);
                return;
            }
            case 1: {
                this.setUriBase(URI_BASE_EDEFAULT);
                return;
            }
            case 2: {
                this.getSubManagers().clear();
                return;
            }
            case 3: {
                this.getResourceDescriptors().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        EStructuralFeature eStructuralFeature = this.getFeatureWithOverridenDefaultValue(n);
        if (eStructuralFeature != null) {
            return this.isFeatureWithOverridenDefaultValueSet(eStructuralFeature);
        }
        switch (n) {
            case 0: {
                return GUID_EDEFAULT == null ? this.guid != null : !GUID_EDEFAULT.equals(this.guid);
            }
            case 1: {
                return URI_BASE_EDEFAULT == null ? this.uriBase != null : !URI_BASE_EDEFAULT.equals(this.uriBase);
            }
            case 2: {
                return this.subManagers != null && !this.subManagers.isEmpty();
            }
            case 3: {
                return this.resourceDescriptors != null && !this.resourceDescriptors.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    public void dispose() {
        if (this.idToResourceDescriptorMap != null) {
            this.idToResourceDescriptorMap.clear();
            this.idToResourceDescriptorMap = null;
        }
        this.eAdapters().clear();
        Iterator iterator = ((InternalEList)this.getSubManagers()).basicIterator();
        while (iterator.hasNext()) {
            ResourceManager resourceManager = (ResourceManager)iterator.next();
            if (((InternalEObject)resourceManager).eIsProxy()) continue;
            resourceManager.dispose();
        }
    }
}

