/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.InvalidMethodElementNameException;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPropertyListener;

public abstract class AbstractLibraryManager
implements ILibraryManager {
    public static final int PROP_DIRTY = 1;
    public static final String ARG_LIBRARY_NAME = "library.name";
    public static final String ARG_LIBRARY_REGISTER_TYPE = "libraryRegisterType";
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected AdapterFactoryEditingDomain editingDomain;
    private List libraryChangedListeners = new ArrayList();
    private ListenerList resourceChangeListeners = new ListenerList();
    private Map saveOptions;
    protected boolean skipEventProcessing = false;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(final EventObject eventObject) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"commandStackChanged", (String)("event=" + eventObject));
            }
            if (!AbstractLibraryManager.this.skipEventProcessing) {
                SafeUpdateController.asyncExec(new Runnable(){

                    public void run() {
                        Command command = LibraryUtil.unwrap(((CommandStack)eventObject.getSource()).getMostRecentCommand());
                        if (command != null) {
                            if (command instanceof AddCommand) {
                                AddCommand addCommand = (AddCommand)command;
                                EObject eObject = addCommand.getOwner();
                                Collection collection = new ArrayList<EObject>();
                                collection.add(eObject);
                                AbstractLibraryManager.this.notifyListeners(8, collection);
                                if (!(eObject instanceof MethodConfiguration)) {
                                    collection = command.getResult();
                                    if (eObject instanceof MethodPackage && !(collection = LibraryUtil.getContainedElements(eObject, collection)).isEmpty()) {
                                        AbstractLibraryManager.this.addNewPackagesToConfiguration(collection);
                                    }
                                    AbstractLibraryManager.this.notifyListeners(32, collection);
                                }
                            } else if (command instanceof PasteFromClipboardCommand) {
                                Collection collection = command.getResult();
                                AbstractLibraryManager.this.notifyListeners(32, collection);
                                PasteFromClipboardCommand pasteFromClipboardCommand = (PasteFromClipboardCommand)command;
                                if (pasteFromClipboardCommand.getOwner() instanceof MethodPackage && !(collection = LibraryUtil.getContainedElements(pasteFromClipboardCommand.getOwner(), collection)).isEmpty()) {
                                    AbstractLibraryManager.this.addNewPackagesToConfiguration(collection);
                                }
                            } else if (command instanceof CreateChildCommand) {
                                AbstractLibraryManager.this.notifyListeners(32, command.getAffectedObjects());
                            } else if (command != null) {
                                AbstractLibraryManager.this.notifyListeners(8, command.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        }
    };
    private INotifyChangedListener notifyChangedListener = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyChanged", (String)("notification=" + notification));
            }
            if (!AbstractLibraryManager.this.skipEventProcessing) {
                int n = notification.getEventType();
                switch (n) {
                    case 3: {
                        Object object = notification.getNotifier();
                        Object object2 = notification.getNewValue();
                        if (!(object instanceof MethodLibrary) || !(object2 instanceof MethodPlugin)) break;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object2);
                        AbstractLibraryManager.this.notifyListeners(32, arrayList);
                        break;
                    }
                    case 1: {
                        Object object = notification.getNotifier();
                        if (object == null) break;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object);
                        AbstractLibraryManager.this.notifyListeners(8, arrayList);
                        break;
                    }
                    case 4: {
                        Object object = notification.getNotifier();
                        Object object3 = notification.getOldValue();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        if (object3 instanceof EObject && ((EObject)object3).eContainer() == null) {
                            arrayList.add(object3);
                            AbstractLibraryManager.this.notifyListeners(16, arrayList);
                            break;
                        }
                        arrayList.add(object);
                        AbstractLibraryManager.this.notifyListeners(8, arrayList);
                        break;
                    }
                    case 6: {
                        ArrayList arrayList = new ArrayList((Collection)notification.getOldValue());
                        ArrayList arrayList2 = new ArrayList();
                        ArrayList arrayList3 = new ArrayList();
                        if (!arrayList.isEmpty()) {
                            for (Object e : arrayList) {
                                if (!(e instanceof EObject)) continue;
                                if (((EObject)e).eContainer() == null) {
                                    arrayList2.add(e);
                                    continue;
                                }
                                arrayList3.add(e);
                            }
                        }
                        if (!arrayList2.isEmpty()) {
                            AbstractLibraryManager.this.notifyListeners(16, arrayList2);
                        }
                        if (arrayList3.isEmpty()) break;
                        AbstractLibraryManager.this.notifyListeners(8, arrayList3);
                    }
                }
            }
        }
    };
    private Adapter resourceChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (debug) {
                DebugTrace.print((Object)((Object)this), (String)"notifyChanged", (String)("msg=" + notification));
            }
            if (notification.getFeatureID(null) == 3 && notification.getEventType() == 1) {
                AbstractLibraryManager.this.firePropertyChange(notification.getNotifier(), 1);
            }
        }
    };
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent iRefreshEvent) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyRefreshed", (String)("event=" + iRefreshEvent));
            }
            AbstractLibraryManager.this.handleRefreshEvent(iRefreshEvent);
        }
    };
    private IPropertyChangeListener preferenceStoreChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("discardUnresolvedReferences")) {
                AbstractLibraryManager.this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", propertyChangeEvent.getNewValue());
            }
        }
    };

    public AbstractLibraryManager() {
        this.init();
    }

    protected void init() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"init");
        }
        LibraryPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceStoreChangeListener);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ResourceItemProviderAdapterFactory());
        arrayList.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(arrayList);
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        ILibraryResourceSet iLibraryResourceSet = this.createResourceSet();
        iLibraryResourceSet.addRefreshListener(this.refreshListener);
        RefreshJob.getInstance().setResourceSet((ResourceSet)iLibraryResourceSet);
        this.saveOptions = iLibraryResourceSet.getDefaultSaveOptions();
        this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", LibraryPreferences.getDiscardUnresolvedReferences());
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)composedAdapterFactory, (CommandStack)basicCommandStack, (ResourceSet)iLibraryResourceSet);
        this.registerEditingDomain(this.editingDomain);
    }

    public void saveMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"saveMethodLibrary");
        }
        try {
            try {
                if (this.library != null) {
                    this.skipEventProcessing = true;
                    ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
                    iLibraryResourceSet.save(this.saveOptions);
                    ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                    this.skipEventProcessing = false;
                    this.firePropertyChange(this.library, 1);
                }
            }
            catch (Exception exception) {
                throw new LibraryServiceException(exception);
            }
        }
        finally {
            this.skipEventProcessing = false;
        }
    }

    public void discardMethodLibraryChanges() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"discardMethodLibraryChanges");
        }
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            resource.setModified(false);
        }
    }

    public void closeMethodLibrary() throws LibraryServiceException {
        Object object;
        if (debug) {
            object = "library=" + this.library + ", memory on entry=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)object);
        }
        object = new File(this.library.eResource().getURI().toFileString());
        String string = ((File)object).getParentFile().getAbsolutePath();
        LibraryService.getInstance().removeConfigurationManagers(this.library);
        this.removeResourceChangedListeners();
        LayoutResources.clear();
        ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
        iLibraryResourceSet.unload();
        try {
            MethodLibraryProject.closeProject(string, null);
        }
        catch (Exception exception) {
            throw new LibraryServiceException(exception);
        }
        RefreshJob.getInstance().reset();
        Runtime.getRuntime().gc();
        if (debug) {
            String string2 = "library=" + this.library + ", memory on exit=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)string2);
        }
    }

    public MethodLibrary getMethodLibrary() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public void setMethodLibrary(MethodLibrary methodLibrary) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"setMethodLibrary", (String)("library=" + methodLibrary));
        }
        if (this.library != null && (resource = this.library.eResource()) != null) {
            resource.getContents().clear();
            resource.getContents().add((Object)methodLibrary);
        }
        this.library = methodLibrary;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getAdapterFactory");
        }
        return (ComposedAdapterFactory)this.getEditingDomain().getAdapterFactory();
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getEditingDomain", (String)("editingDomain=" + this.editingDomain));
        }
        return this.editingDomain;
    }

    public void registerEditingDomain(AdapterFactoryEditingDomain adapterFactoryEditingDomain) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"registerEditingDomain", (String)("domain=" + adapterFactoryEditingDomain));
        }
        ((ComposedAdapterFactory)adapterFactoryEditingDomain.getAdapterFactory()).addListener(this.notifyChangedListener);
        adapterFactoryEditingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILibraryChangeListener iLibraryChangeListener) {
        List list = this.libraryChangedListeners;
        synchronized (list) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"addListener", (String)("listener=" + iLibraryChangeListener));
            }
            if (!this.libraryChangedListeners.contains(iLibraryChangeListener)) {
                this.libraryChangedListeners.add(iLibraryChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(ILibraryChangeListener iLibraryChangeListener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"removeListener", (String)("listener=" + iLibraryChangeListener));
        }
        if (iLibraryChangeListener != null) {
            List list = this.libraryChangedListeners;
            synchronized (list) {
                this.libraryChangedListeners.remove(iLibraryChangeListener);
            }
        }
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addPropertyListener", (String)("listener=" + iPropertyListener));
        }
        this.resourceChangeListeners.add((Object)iPropertyListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"removePropertyListener", (String)("listener=" + iPropertyListener));
        }
        this.resourceChangeListeners.remove((Object)iPropertyListener);
    }

    public void startListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    public void stopListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.removeCommandStackListener(this.commandStackListener);
    }

    public void startListeningTo(ComposedAdapterFactory composedAdapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("adapterFactory=" + composedAdapterFactory));
        }
        composedAdapterFactory.addListener(this.notifyChangedListener);
    }

    public void stopListeningTo(ComposedAdapterFactory composedAdapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("adapterFactory=" + composedAdapterFactory));
        }
        composedAdapterFactory.removeListener(this.notifyChangedListener);
    }

    public MethodElement getMethodElement(String string) {
        try {
            ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.library.eResource().getResourceSet();
            if (iLibraryResourceSet != null) {
                return (MethodElement)iLibraryResourceSet.getEObject(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public URI getElementRelativeURI(MethodElement methodElement) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"getElementRelativeURI", (String)("element=" + methodElement));
        }
        if (methodElement != null && (resource = this.library.eResource()) != null) {
            URI uRI = resource.getURI();
            URI uRI2 = methodElement.eResource().getURI();
            return uRI2.deresolve(uRI);
        }
        return null;
    }

    public boolean isMethodLibraryReadOnly() {
        URI uRI;
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryReadOnly");
        }
        if ((uRI = this.library.eResource().getURI()).isFile()) {
            File file = new File(uRI.toFileString());
            return file.exists() && !file.canWrite();
        }
        return false;
    }

    public boolean isMethodLibraryModified() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryModified");
        }
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            if (!resource.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedProxy() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"hasUnresolvedProxy");
        }
        ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
        return iLibraryResourceSet.hasUnresolvedProxy();
    }

    public Collection reloadResources(final Collection collection) {
        if (debug) {
            System.out.println("AbstractLibraryManager.reloadResources(): START");
        }
        try {
            final ArrayList arrayList = new ArrayList();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    arrayList.addAll(AbstractLibraryManager.this.doReloadResources(collection));
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (ISchedulingRule)new LibrarySchedulingRule(this.library), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (debug) {
                System.out.println("AbstractLibraryManager.doReloadResources(): END");
            }
        }
    }

    private Collection doReloadResources(Collection collection) {
        Object object;
        Object object22;
        if (debug) {
            DebugTrace.print((Object)this, (String)"reloadResources");
        }
        if (this.library == null) {
            return Collections.EMPTY_LIST;
        }
        LibraryService libraryService = (LibraryService)LibraryService.getInstance();
        Object object3 = null;
        ILibraryManager iLibraryManager = null;
        Object object4 = null;
        MethodConfiguration methodConfiguration = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object22 : collection) {
            object = PersistenceUtil.getMethodElement((Resource)object22);
            if (object == libraryService.getCurrentMethodLibrary()) {
                iLibraryManager = libraryService.getCurrentLibraryManager();
                object3 = object22;
                continue;
            }
            if (object == libraryService.getCurrentMethodConfiguration()) {
                object4 = object22;
                methodConfiguration = libraryService.getCurrentMethodConfiguration();
                continue;
            }
            if (!(object instanceof MethodConfiguration)) continue;
            arrayList.add(object22);
            arrayList2.add(object);
        }
        ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.library.eResource().getResourceSet();
        object22 = iLibraryResourceSet.reloadResources(collection);
        if (!object22.isEmpty()) {
            if (object3 != null || object4 != null) {
                object = object22.iterator();
                while (object.hasNext()) {
                    int n;
                    MethodLibrary methodLibrary;
                    MethodElement methodElement;
                    Resource resource = (Resource)object.next();
                    if (resource == object3 && (methodElement = PersistenceUtil.getMethodElement((Resource)resource)) instanceof MethodLibrary) {
                        methodLibrary = (MethodLibrary)methodElement;
                        libraryService.setCurrentMethodLibrary(methodLibrary);
                        if (iLibraryManager instanceof AbstractLibraryManager) {
                            libraryService.removeLibraryManager(iLibraryManager);
                            ((AbstractLibraryManager)iLibraryManager).updateMethodLibrary(methodLibrary);
                            libraryService.setLibraryManager(iLibraryManager);
                        }
                    }
                    if (resource == object4) {
                        methodElement = PersistenceUtil.getMethodElement((Resource)resource);
                        if (!(methodElement instanceof MethodConfiguration)) continue;
                        libraryService.removeConfigurationManager(methodConfiguration);
                        methodLibrary = (MethodConfiguration)methodElement;
                        libraryService.setCurrentMethodConfiguration((MethodConfiguration)methodLibrary);
                        continue;
                    }
                    if (arrayList.isEmpty() || (n = arrayList.indexOf(resource)) == -1) continue;
                    libraryService.removeConfigurationManager((MethodConfiguration)arrayList2.get(n));
                }
            }
            Suppression.cleanUp();
        }
        return object22;
    }

    private void updateMethodLibrary(MethodLibrary methodLibrary) {
        this.library = methodLibrary;
    }

    public Map getSaveOptions() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getSaveOptions");
        }
        return this.saveOptions;
    }

    public void addMethodPlugin(final MethodPlugin methodPlugin) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addMethodPlugin", (String)("plugin=" + methodPlugin));
        }
        final Exception[] exceptionArray = new Exception[1];
        try {
            SafeUpdateController.syncExec(new Runnable(){

                public void run() {
                    AbstractLibraryManager.this.library.getMethodPlugins().add(methodPlugin);
                    ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = Services.getLibraryPersister((String)AbstractLibraryManager.this.getLibraryPersisterType()).getFailSafePersister();
                    try {
                        failSafeMethodLibraryPersister.save(AbstractLibraryManager.this.library.eResource());
                        failSafeMethodLibraryPersister.commit();
                    }
                    catch (Exception exception) {
                        failSafeMethodLibraryPersister.rollback();
                        exceptionArray[0] = exception;
                        return;
                    }
                    methodPlugin.eResource().eAdapters().add((Object)AbstractLibraryManager.this.resourceChangedListener);
                }
            });
        }
        catch (Exception exception) {
            throw new LibraryServiceException(exception);
        }
        if (exceptionArray[0] != null) {
            throw new LibraryServiceException(exceptionArray[0]);
        }
    }

    public void dispose() {
        if (this.preferenceStoreChangeListener != null) {
            LibraryPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceStoreChangeListener);
        }
        if (this.libraryChangedListeners.size() > 0) {
            this.libraryChangedListeners.clear();
        }
        if (this.resourceChangeListeners.size() > 0) {
            this.resourceChangeListeners.clear();
        }
        this.editingDomain = null;
        this.library = null;
    }

    protected void checkElementCreationArguments(MethodElement methodElement, String string) throws LibraryServiceException {
        if (methodElement == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw new InvalidMethodElementNameException();
        }
    }

    protected void handleRefreshEvent(IRefreshEvent iRefreshEvent) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"handleRefreshEvent", (String)("refreshedResources=" + iRefreshEvent.getRefreshedResources()));
        }
        if (!iRefreshEvent.getUnloadedObjects().isEmpty()) {
            TngAdapterFactory.INSTANCE.cleanUp();
        }
    }

    protected synchronized void notifyListeners(int n, Collection collection) {
        HashSet hashSet = new HashSet();
        while (this._doNotifyListeners(n, collection, hashSet)) {
        }
    }

    private boolean _doNotifyListeners(final int n, final Collection collection, Collection collection2) {
        boolean bl;
        block4: {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyListeners", (String)("option=" + n));
            }
            bl = false;
            try {
                for (final ILibraryChangeListener iLibraryChangeListener : new ArrayList(this.libraryChangedListeners)) {
                    if (iLibraryChangeListener == null || collection2.contains(iLibraryChangeListener)) continue;
                    collection2.add(iLibraryChangeListener);
                    bl = true;
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            if (debug) {
                                DebugTrace.print((Object)this, (String)"notifyListeners", (String)("listener=" + iLibraryChangeListener));
                            }
                            iLibraryChangeListener.libraryChanged(n, collection);
                        }
                    });
                }
            }
            catch (Exception exception) {
                if (!debug) break block4;
                DebugTrace.print((Object)this, (String)"notifyListeners", (Throwable)exception);
            }
        }
        return bl;
    }

    protected void firePropertyChange(final Object object, final int n) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("source=" + object));
        }
        Object[] objectArray = this.resourceChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            SafeUpdateController.asyncExec(new Runnable(){

                public void run() {
                    if (debug) {
                        DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("listener=" + iPropertyListener));
                    }
                    iPropertyListener.propertyChanged(object, n);
                }
            });
            ++n2;
        }
    }

    protected void addResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        if (!this.library.eResource().eAdapters().contains((Object)this.resourceChangedListener)) {
            this.library.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        for (MethodPlugin methodPlugin : this.library.getMethodPlugins()) {
            if (methodPlugin.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            methodPlugin.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        for (MethodPlugin methodPlugin : this.library.getPredefinedConfigurations()) {
            if (methodPlugin.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            methodPlugin.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
    }

    protected void removeResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        this.library.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        for (MethodPlugin methodPlugin : this.library.getMethodPlugins()) {
            methodPlugin.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
        for (MethodPlugin methodPlugin : this.library.getPredefinedConfigurations()) {
            methodPlugin.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
    }

    protected Resource getMethodLibraryResource() {
        return this.library != null ? this.library.eResource() : null;
    }

    public java.net.URI getMethodLibraryURI() {
        Resource resource = this.getMethodLibraryResource();
        if (resource != null) {
            URI uRI = resource.getURI();
            try {
                File file = new File(uRI.toFileString());
                return file.getParentFile().toURI();
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return null;
    }

    private void addNewPackagesToConfiguration(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        LibraryModificationHelper libraryModificationHelper = new LibraryModificationHelper();
        try {
            try {
                for (EObject eObject : collection) {
                    Object object;
                    EObject eObject2;
                    if (!(eObject instanceof MethodPackage) || (eObject2 = eObject.eContainer()) == null || !(eObject2 instanceof MethodPackage) || !((object = ((MultiResourceEObject)eObject2).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations)) instanceof List)) continue;
                    for (MethodConfiguration methodConfiguration : (List)object) {
                        List list = methodConfiguration.getMethodPackageSelection();
                        if (list.contains(eObject)) continue;
                        libraryModificationHelper.getActionManager().doAction(3, (EObject)methodConfiguration, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), (Object)eObject, -1);
                    }
                }
                libraryModificationHelper.save();
            }
            catch (RuntimeException runtimeException) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
                libraryModificationHelper.dispose();
            }
        }
        finally {
            libraryModificationHelper.dispose();
        }
    }

    protected abstract String getLibraryPersisterType();

    protected abstract ILibraryResourceSet createResourceSet();
}

