/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public abstract class ElementRealizer {
    protected MethodConfiguration config;
    private boolean discardContributor = false;
    private boolean resolveContributor = true;
    private boolean resolveReplacer = true;
    private boolean showSubtracted = false;
    protected IFilter filter = null;
    private static boolean defaultEnableExtendReplace = false;
    private static boolean defaultIgnoreBaseToManyAssociations = false;

    static {
        String string = LibraryPlugin.getDefault().getString("EnableExtendReplace");
        if (string != null && string.trim().equals("true")) {
            defaultEnableExtendReplace = true;
        }
        defaultIgnoreBaseToManyAssociations = LibraryPreferences.getUseNewExtendsSemantics();
    }

    public ElementRealizer(MethodConfiguration methodConfiguration) {
        this(methodConfiguration, true, true);
    }

    public ElementRealizer(MethodConfiguration methodConfiguration, boolean bl, boolean bl2) {
        this.config = methodConfiguration;
        this.resolveContributor = bl;
        this.resolveReplacer = bl2;
    }

    public static boolean isExtendReplaceEnabled() {
        return defaultEnableExtendReplace;
    }

    public static boolean ignoreBaseToManyAssociations() {
        return defaultIgnoreBaseToManyAssociations;
    }

    public static void setIgnoreBaseToManyAssociations(boolean bl) {
        defaultIgnoreBaseToManyAssociations = bl;
    }

    public void setDiscardContributor(boolean bl) {
        this.discardContributor = bl;
    }

    public void setResolveContributor(boolean bl) {
        this.resolveContributor = bl;
    }

    public void setResolveReplacer(boolean bl) {
        this.resolveReplacer = bl;
    }

    public boolean showSubtracted() {
        return this.showSubtracted;
    }

    public void setShowSubtracted(boolean bl) {
        this.showSubtracted = bl;
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public MethodElement realize(MethodElement methodElement) {
        if (methodElement == null || !this.inConfig(methodElement)) {
            return null;
        }
        Task task = null;
        if (methodElement instanceof TaskDescriptor) {
            task = ((TaskDescriptor)methodElement).getTask();
        } else if (methodElement instanceof WorkProductDescriptor) {
            task = ((WorkProductDescriptor)methodElement).getWorkProduct();
        } else if (methodElement instanceof RoleDescriptor) {
            task = ((RoleDescriptor)methodElement).getRole();
        }
        if (task != null && !this.inConfig((MethodElement)task)) {
            return null;
        }
        if (this.config == null) {
            return methodElement;
        }
        if (methodElement instanceof VariabilityElement) {
            VariabilityElement variabilityElement;
            VariabilityElement variabilityElement2 = (VariabilityElement)methodElement;
            if (this.discardContributor && ConfigurationHelper.isContributor(variabilityElement2)) {
                return null;
            }
            if (this.resolveContributor) {
                while (ConfigurationHelper.isContributor(variabilityElement2)) {
                    variabilityElement = variabilityElement2.getVariabilityBasedOnElement();
                    if (this.inConfig((MethodElement)variabilityElement)) {
                        variabilityElement2 = variabilityElement;
                        continue;
                    }
                    System.out.println("Configuration closure error: Base element '" + LibraryUtil.getTypeName((MethodElement)variabilityElement2) + "' not in configuration");
                    break;
                }
            }
            if (this.resolveReplacer) {
                variabilityElement = ConfigurationHelper.getReplacer(variabilityElement2, this.config);
                if (variabilityElement != null) {
                    return variabilityElement;
                }
            } else if (!this.inConfig((MethodElement)variabilityElement2)) {
                return null;
            }
            variabilityElement = variabilityElement2;
            while (variabilityElement != null && ConfigurationHelper.isReplacer(variabilityElement)) {
                if (!ConfigurationHelper.isContributor(variabilityElement = variabilityElement.getVariabilityBasedOnElement())) continue;
                return this.realize((MethodElement)variabilityElement);
            }
            if (this.canShow((MethodElement)variabilityElement2)) {
                return variabilityElement2;
            }
            return null;
        }
        if (this.canShow(methodElement)) {
            return methodElement;
        }
        return null;
    }

    public abstract List realize(MethodElement var1, EStructuralFeature var2, List var3);

    public boolean inConfig(MethodElement methodElement) {
        return ConfigurationHelper.inConfig(methodElement, this.config, !this.showSubtracted());
    }

    public boolean canShow(MethodElement methodElement) {
        return ConfigurationHelper.canShow(methodElement, this.config, !this.showSubtracted());
    }

    public void dispose() {
        this.filter = null;
    }
}

