/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationClosure;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.closure.ClosureListener;
import org.eclipse.epf.library.configuration.closure.ConfigurationErrorMatrix;
import org.eclipse.epf.library.configuration.closure.DependencyManager;
import org.eclipse.epf.library.configuration.closure.ElementDependencyError;
import org.eclipse.epf.library.configuration.closure.ElementError;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.configuration.closure.PackageDependency;
import org.eclipse.epf.library.configuration.closure.PackageError;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationClosure
implements IConfigurationClosure {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config = null;
    protected MethodLibrary library = null;
    protected IConfigurationManager configManager = null;
    protected DependencyManager dependencyManager = null;
    protected IActionManager actionMgr;
    protected List selectedNotes = new ArrayList();
    private List<ElementError> errors = new ArrayList<ElementError>();
    protected Map<Object, ElementDependencyError> invalidNodesMap = new HashMap<Object, ElementDependencyError>();
    private List<ClosureListener> listeners;

    public ConfigurationClosure(IActionManager iActionManager, MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
        this.actionMgr = iActionManager;
        this.configManager = LibraryService.getInstance().getConfigurationManager(methodConfiguration);
        if (this.configManager != null) {
            this.library = this.configManager.getMethodLibrary();
            this.dependencyManager = this.configManager.getDependencyManager();
        }
        this.checkError();
    }

    @Override
    public IConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    @Override
    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public MethodLibrary getLibrary() {
        return this.library;
    }

    public void checkError() {
        LibraryUtil.validateMethodConfiguration(this.actionMgr, this.config);
        this.selectedNotes.clear();
        this.selectedNotes.addAll(this.config.getMethodPluginSelection());
        this.selectedNotes.addAll(this.config.getMethodPackageSelection());
        this.clearErrorMarks();
        this.invalidNodesMap.clear();
        this.processChangedNodes(this.getSelection());
    }

    private void clearErrorMarks() {
        for (ElementError elementError : this.errors) {
            this.notifyError(elementError, 0);
        }
    }

    @Override
    public boolean isSelected(Object object) {
        return object instanceof MethodLibrary || object == this.config || this.selectedNotes.contains(object);
    }

    @Override
    public ElementDependencyError getError(Object object) {
        return this.getError(object, false);
    }

    private ElementDependencyError getError(Object object, boolean bl) {
        ElementDependencyError elementDependencyError = this.invalidNodesMap.get(object);
        if (elementDependencyError == null && bl) {
            elementDependencyError = new ElementDependencyError(object);
            this.invalidNodesMap.put(object, elementDependencyError);
        }
        return elementDependencyError;
    }

    @Override
    public boolean hasError() {
        for (ElementDependencyError elementDependencyError : this.invalidNodesMap.values()) {
            if (!elementDependencyError.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProblem() {
        return this.invalidNodesMap.size() > 0;
    }

    @Override
    public List<PackageError> getAllErrors() {
        ArrayList<PackageError> arrayList = new ArrayList<PackageError>();
        for (ElementDependencyError elementDependencyError : this.invalidNodesMap.values()) {
            arrayList.addAll(elementDependencyError.getAll());
        }
        return arrayList;
    }

    @Override
    public Object[] getDependencyErrors() {
        return this.invalidNodesMap.values().toArray();
    }

    @Override
    public List getInvalidElements() {
        return new ArrayList(this.invalidNodesMap.keySet());
    }

    private void removeError(Object object) {
        if (this.invalidNodesMap.containsKey(object)) {
            this.invalidNodesMap.remove(object);
        }
    }

    @Override
    public Object[] getSelection() {
        return this.selectedNotes.toArray();
    }

    private void processChangedNodes(Object[] objectArray) {
        List list;
        PackageDependency packageDependency;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            packageDependency = this.dependencyManager.getDependency((MethodElement)object);
            if (packageDependency != null && (list = packageDependency.getAllElementReferences()) != null && list.size() != 0) {
                for (ElementReference elementReference : list) {
                    this.checkReference(elementReference);
                }
            }
            ++n;
        }
        for (MethodElement methodElement : this.configManager.getConfigurationData().getAddedElements()) {
            packageDependency = this.dependencyManager.getDependency((MethodElement)methodElement.eContainer());
            if (packageDependency == null || (list = packageDependency.getAllElementReferences()) == null || list.size() == 0) continue;
            for (ElementReference elementReference : list) {
                if (elementReference.getElement() != methodElement) continue;
                this.checkReference(elementReference);
            }
        }
    }

    private void checkReference(ElementReference elementReference) {
        MethodElement methodElement = elementReference.getElement();
        MethodElement methodElement2 = elementReference.getRefElement();
        if (methodElement instanceof MethodPackage || methodElement instanceof MethodConfiguration) {
            return;
        }
        if (!ConfigurationHelper.inConfig(methodElement, this.config)) {
            return;
        }
        if (!ConfigurationHelper.inConfig(methodElement2, this.config)) {
            ElementError elementError = ConfigurationErrorMatrix.getError(this.config, elementReference);
            if (elementError == null) {
                return;
            }
            this.errors.add(elementError);
            this.notifyError(elementError, 1);
            this.processPackageError(LibraryUtil.getSelectable((EObject)methodElement), LibraryUtil.getSelectable((EObject)methodElement2), elementError.getErrorLevel());
        }
    }

    private void processPackageError(Object object, Object object2, int n) {
        if (n > 0) {
            ElementDependencyError elementDependencyError = this.getError(object, true);
            PackageError packageError = elementDependencyError.getError(object2);
            if (packageError == null) {
                String string = LibraryResources.configClosureWarning_msg1;
                packageError = new PackageError(n, string, object, object2, 16);
                elementDependencyError.addError(packageError);
            } else {
                packageError.setErrorLevel(n);
                elementDependencyError.calculateErrorBits();
            }
        } else {
            this.removeError(object);
        }
        this.updateParentsForErrors((EObject)object);
    }

    private void notifyError(ElementError elementError, int n) {
        if (elementError == null || this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        try {
            for (ClosureListener closureListener : this.listeners) {
                closureListener.fireEvent(n, this.config, elementError);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateParentError(EObject eObject, EObject eObject2, int n) {
        if (eObject == null || eObject instanceof MethodLibrary) {
            return;
        }
        ElementDependencyError elementDependencyError = this.getError(eObject, false);
        if (elementDependencyError != null && elementDependencyError.size() > 0) {
            elementDependencyError.removeError(eObject2);
        }
        if (n != 0) {
            elementDependencyError = this.getError(eObject, true);
            String string = LibraryResources.configClosureWarning_msg1;
            PackageError packageError = new PackageError(n, string, eObject, eObject2, 0);
            elementDependencyError.addError(packageError);
        } else if (elementDependencyError != null && elementDependencyError.size() == 0) {
            this.removeError(eObject);
        }
        this.updateParentError(eObject.eContainer(), eObject2, n);
    }

    private void updateParentsForErrors(EObject eObject) {
        int n = 0;
        ElementDependencyError elementDependencyError = this.getError(eObject);
        if (elementDependencyError != null && elementDependencyError.size() > 0) {
            if (elementDependencyError.isError() || elementDependencyError.isChildError()) {
                n = 8;
            } else if (elementDependencyError.isWarning() || elementDependencyError.isChildWarning()) {
                n = 16;
            }
        }
        this.updateParentError(eObject.eContainer(), eObject, n);
    }

    @Override
    public void fixErrors() {
        boolean bl = true;
        boolean bl2 = true;
        while (bl) {
            bl = this.fixProblems(true, bl2);
            bl2 = false;
        }
    }

    @Override
    public void fixProblems() {
        boolean bl = true;
        boolean bl2 = true;
        while (bl) {
            bl = this.fixProblems(false, bl2);
            bl2 = false;
        }
    }

    private boolean fixProblems(boolean bl, boolean bl2) {
        boolean bl3 = bl2;
        List<PackageError> list = this.getAllErrors();
        if (list.size() > 0) {
            this.invalidNodesMap.clear();
            for (PackageError packageError : list) {
                EObject eObject = (EObject)packageError.getCauseElement();
                boolean bl4 = packageError.isError();
                boolean bl5 = packageError.isWarning();
                if (!bl4 && !bl5 || !bl4 && bl || this.isSelected(eObject) || !this.selectErrorElement(eObject)) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            this.checkError();
        }
        return bl3;
    }

    private boolean selectErrorElement(EObject eObject) {
        boolean bl = true;
        if (eObject instanceof MethodPlugin && !this.config.getMethodPluginSelection().contains(eObject)) {
            this.config.getMethodPluginSelection().add(eObject);
        } else if (eObject instanceof MethodPackage && !this.config.getMethodPackageSelection().contains(eObject)) {
            this.config.getMethodPackageSelection().add(eObject);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public MethodLibrary packageLibrary(boolean bl) {
        this.processSelection((EObject)this.library, bl);
        List list = this.library.getPredefinedConfigurations();
        list.clear();
        list.add(this.config);
        return this.library;
    }

    private void processSelection(EObject eObject, boolean bl) {
        EList eList;
        if (bl && (eList = eObject.eCrossReferences()) != null) {
            for (EObject eObject2 : new ArrayList(eList)) {
                EObject eObject3 = LibraryUtil.getSelectable(eObject2);
                if (eObject3 == null || this.isSelected(eObject3)) continue;
                this.removeReference(eObject, eObject2);
            }
        }
        if ((eList = eObject.eContents()) != null) {
            for (EObject eObject2 : new ArrayList(eList)) {
                if (LibraryUtil.selectable(eObject2) && !this.isSelected(eObject2)) {
                    EcoreUtil.remove((EObject)eObject2);
                    continue;
                }
                this.processSelection(eObject2, bl);
            }
        }
    }

    private void removeReference(EObject eObject, EObject eObject2) {
        AdapterFactoryContentProvider adapterFactoryContentProvider = this.configManager.getContentProvider();
        IPropertySource iPropertySource = adapterFactoryContentProvider.getPropertySource((Object)eObject);
        IPropertyDescriptor[] iPropertyDescriptorArray = iPropertySource.getPropertyDescriptors();
        if (iPropertyDescriptorArray != null && iPropertyDescriptorArray.length > 0) {
            int n = 0;
            while (n < iPropertyDescriptorArray.length) {
                IPropertyDescriptor iPropertyDescriptor = iPropertyDescriptorArray[n];
                Object object = iPropertyDescriptor.getId();
                Object object2 = iPropertySource.getPropertyValue(object);
                IPropertySource iPropertySource2 = adapterFactoryContentProvider.getPropertySource(object2);
                if (iPropertySource2 != null) {
                    object2 = iPropertySource2.getEditableValue();
                }
                if (object2 instanceof EList) {
                    EList eList = (EList)object2;
                    if (eList.contains((Object)eObject2)) {
                        if (debug) {
                            System.out.println("Reference [" + LibraryUtil.getName(eObject2) + "] removed from [" + LibraryUtil.getName(eObject) + "]'s reference list");
                        }
                        eList.remove((Object)eObject2);
                        iPropertySource.setPropertyValue(object, (Object)eList);
                    }
                } else if (object2 instanceof MethodElement) {
                    if (debug) {
                        System.out.println("Reference [" + LibraryUtil.getName(eObject2) + "] removed from [" + LibraryUtil.getName(eObject) + "]");
                    }
                    iPropertySource.setPropertyValue(object, null);
                }
                ++n;
            }
        }
    }

    @Override
    public void dispose() {
        this.clearErrorMarks();
        this.configManager = null;
        this.config = null;
        this.library = null;
        this.dependencyManager = null;
        this.actionMgr = null;
        if (this.invalidNodesMap != null) {
            this.invalidNodesMap.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public void addListener(ClosureListener closureListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ClosureListener>();
        }
        if (!this.listeners.contains(closureListener)) {
            this.listeners.add(closureListener);
        }
        this.notifyListener(closureListener, this.errors);
    }

    public void removeListener(ClosureListener closureListener) {
        if (this.listeners != null && this.listeners.contains(closureListener)) {
            this.listeners.remove(closureListener);
        }
    }

    private void notifyListener(ClosureListener closureListener, List list) {
        for (ElementError elementError : list) {
            closureListener.fireEvent(1, this.config, elementError);
        }
    }
}

