/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.layout.util.XmlElement;

public class Bookmark {
    static final long serialVersionUID = -3652582791326323863L;
    private String _fileName = "";
    private String _closedIconName = "";
    private String _openIconName = "";
    private String _presentationName = "";
    private boolean _isExist = true;
    private boolean _isFromContentLibrary = true;
    private String _uniqueId = null;
    private boolean _isVisible = true;
    private boolean _isEnabled = true;
    private boolean _isTransparent = false;
    private boolean _isDefault = false;
    private boolean _isCurrent = false;
    private String queryString = "";
    private List children = new ArrayList();
    private Bookmark parent = null;
    private Object owner = null;

    public Bookmark(String string) {
        this._presentationName = string;
        if (this._presentationName == null) {
            this._presentationName = "";
        }
    }

    public Bookmark(String string, String string2) {
        this(string);
        this._uniqueId = string2;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getUserObject() {
        return this._presentationName;
    }

    public void setUserObject(Object object) {
        this._presentationName = (String)object;
        if (this._presentationName == null) {
            this._presentationName = "";
        }
    }

    public void setPresentationName(String string) {
        this._presentationName = string;
        if (this._presentationName == null) {
            this._presentationName = "";
        }
    }

    public String getPresentationName() {
        return this._presentationName;
    }

    public void setFileName(String string) {
        this._fileName = string;
        if (this._fileName == null) {
            this._fileName = "";
        }
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setClosedIconName(String string) {
        this._closedIconName = string;
    }

    public String getClosedIconName() {
        return this._closedIconName;
    }

    public String getOpenIconName() {
        return this._openIconName;
    }

    public void setOpenIconName(String string) {
        this._openIconName = string;
    }

    public void setExist(boolean bl) {
        this._isExist = bl;
    }

    public boolean isExist() {
        return this._isExist;
    }

    public void setFromContentLibrary(boolean bl) {
        this._isFromContentLibrary = bl;
    }

    public boolean isFromContentLibrary() {
        return this._isFromContentLibrary;
    }

    public String getUniqueId() {
        return this._uniqueId;
    }

    public void setUniqueId(String string) {
        this._uniqueId = string;
    }

    public void setVisible(boolean bl) {
        this._isVisible = bl;
        int n = 0;
        while (n < this.getChildCount()) {
            Bookmark bookmark = (Bookmark)this.getChildAt(n);
            bookmark.setVisible(bl);
            ++n;
        }
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setEnabled(boolean bl) {
        this._isEnabled = bl;
        int n = 0;
        while (n < this.getChildCount()) {
            Bookmark bookmark = (Bookmark)this.getChildAt(n);
            bookmark.setEnabled(bl);
            ++n;
        }
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setTransparency(boolean bl) {
        this._isTransparent = bl;
    }

    public boolean isTransparent() {
        return this._isTransparent;
    }

    public void setDefault(boolean bl) {
        this._isDefault = bl;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setCurrent(boolean bl) {
        this._isCurrent = bl;
    }

    public boolean isCurrent() {
        return this._isCurrent;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getActualChildCount() {
        return this.getChildCount();
    }

    public Object getChildAt(int n) {
        return this.children.get(n);
    }

    public Object getActualChildAt(int n) {
        return this.children.get(n);
    }

    public void addChild(Bookmark bookmark) {
        this.children.add(bookmark);
        bookmark.parent = this;
    }

    public Bookmark getParent() {
        return this.parent;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public XmlElement getXmlElement() {
        XmlElement xmlElement = new XmlElement("Element").setAttribute("guid", this.getUniqueId()).setAttribute("name", this.getPresentationName().trim()).setAttribute("closedIconName", this.getClosedIconName()).setAttribute("openIconName", this.getOpenIconName()).setAttribute("exist", this.isExist() ? "true" : "false").setAttribute("fromContentLibrary", this.isFromContentLibrary() ? "true" : "false").setAttribute("visible", this.isVisible() ? "true" : "false").setAttribute("enabled", this.isEnabled() ? "true" : "false").setAttribute("transparent", this.isTransparent() ? "true" : "false").setAttribute("default", this.isDefault() ? "true" : "false").setAttribute("current", this.isCurrent() ? "true" : "false");
        xmlElement.setAttribute("closedIconId", this.getIconId(this.getClosedIconName()));
        String string = this.getQueryString();
        string = string == null || string.length() == 0 ? "?nodeId=" + xmlElement.getId() : String.valueOf(string) + "&nodeId=" + xmlElement.getId();
        xmlElement.setAttribute("url", String.valueOf(this.getFileName()) + string);
        int n = 0;
        while (n < this.getChildCount()) {
            Bookmark bookmark = (Bookmark)this.getActualChildAt(n);
            xmlElement.addChild(bookmark.getXmlElement());
            ++n;
        }
        return xmlElement;
    }

    public String getUrl() {
        return String.valueOf(this.getFileName()) + this.getQueryString();
    }

    public String getIconId(String string) {
        if (string == null) {
            return "";
        }
        return Integer.toHexString(string.hashCode());
    }
}

