/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.ProcessComponent;

public class LinkInfo {
    public static final String LINK_ATTR_CLASS = "class";
    public static final String LINK_ATTR_GUID = "guid";
    public static final String LINK_ATTR_HREF = "href";
    public static final String LINK_ATTR_KEY = "key";
    public static final String LINK_ATTR_TEXT = "text";
    public static final String LINK_ATTR_NAME = "name";
    private String linkedText = "";
    private MethodElement linkElement = null;
    private MethodElement ownerElement = null;
    private boolean isMissingReference = false;
    private Map<String, String> attributeMap = new LinkedHashMap<String, String>();
    private IContentValidator validator;
    private String pubDir;
    private String tag;
    private static MethodLibrary library;

    public LinkInfo(MethodElement methodElement, IContentValidator iContentValidator, String string, String string2) {
        this.ownerElement = methodElement;
        this.validator = iContentValidator;
        this.pubDir = string;
        this.tag = string2;
    }

    public boolean isElementLink() {
        return ResourceHelper.isElementLink(this.getElementLinkType());
    }

    public String getElementLinkType() {
        return this.getAttribute(LINK_ATTR_CLASS);
    }

    public String getGuid() {
        return this.getAttribute(LINK_ATTR_GUID);
    }

    public String getUrl() {
        return this.getAttribute(LINK_ATTR_HREF);
    }

    public String getLinkedText() {
        return this.linkedText;
    }

    public MethodElement getLinkedElement() {
        return this.linkElement;
    }

    public StringBuffer getHtml(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMissingReference && this.pubDir != null) {
            Object object = "";
            if (!bl) {
                stringBuffer.append(this.linkedText);
                return stringBuffer;
            }
            object = this.getMissingElementUrl();
            stringBuffer.append("<img alt=\"\" src=\"" + ResourceHelper.getBackPath(this.ownerElement) + "images/no_rup.gif\">&#160;");
            this.setUrl((String)object);
        }
        stringBuffer.append("<" + this.tag);
        for (Map.Entry entry : this.attributeMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (LINK_ATTR_HREF.equals(string) && (string2 == null || string2.length() == 0)) continue;
            stringBuffer.append(" ").append((String)entry.getKey()).append("=").append("\"").append((String)entry.getValue()).append("\"");
        }
        stringBuffer.append(">").append(this.linkedText).append("</" + this.tag + ">");
        return stringBuffer;
    }

    public void validateLink(String string, String string2, MethodConfiguration methodConfiguration) {
        String string3;
        String string4;
        this.linkedText = string2;
        Matcher matcher = ResourceHelper.p_tag_attributes.matcher(string);
        while (matcher.find()) {
            string4 = matcher.group(1).trim().toLowerCase();
            string3 = "";
            if (matcher.group(3) != null) {
                string3 = matcher.group(3).trim();
            } else if (matcher.group(2) != null) {
                string3 = matcher.group(2).trim();
            }
            if (string4.equals(LINK_ATTR_HREF)) {
                try {
                    string3 = this.decode(string3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.attributeMap.put(string4, string3);
        }
        string4 = this.getGuid();
        if (string4 == null && (string4 = ResourceHelper.getGuidFromFileName(string3 = this.getUrl())) != null) {
            this.setGuid(string4);
        }
        this.validateElementUrl(methodConfiguration);
    }

    protected String decode(String string) throws UnsupportedEncodingException {
        return URLDecoder.decode(string, "UTF-8");
    }

    private String getAttribute(String string) {
        return this.attributeMap.get(string);
    }

    private void setGuid(String string) {
        this.attributeMap.put(LINK_ATTR_GUID, string);
    }

    private void setUrl(String string) {
        this.attributeMap.put(LINK_ATTR_HREF, string);
    }

    private void validateElementUrl(MethodConfiguration methodConfiguration) {
        String string = this.getGuid();
        if (string != null) {
            Object object;
            MethodElement methodElement = null;
            methodElement = LinkInfo.getMethodElement(string);
            if (methodElement instanceof ProcessComponent) {
                methodElement = ((ProcessComponent)methodElement).getProcess();
            }
            if (methodElement instanceof MethodPackage || methodElement instanceof MethodConfiguration || methodElement instanceof MethodLibrary) {
                methodElement = null;
                this.setUrl(null);
                return;
            }
            if (methodElement != null) {
                if (methodConfiguration != null) {
                    object = ConfigurationHelper.getCalculatedElement(methodElement, methodConfiguration);
                    if (object != null) {
                        methodElement = object;
                    } else {
                        this.isMissingReference = true;
                        this.validator.logMissingReference(this.ownerElement, methodElement);
                    }
                }
            } else {
                this.isMissingReference = true;
                this.validator.logMissingReference(this.ownerElement, string, this.linkedText);
            }
            if (methodElement != null) {
                String string2;
                string = methodElement.getGuid();
                this.setGuid(string);
                object = this.getUrl();
                if (object != null && !((String)(object = ((String)object).trim())).toLowerCase().startsWith("javascript:")) {
                    object = ResourceHelper.getUrl(methodElement, this.ownerElement, ".html", (String)object);
                    this.setUrl((String)object);
                }
                if (this.isElementLink() && !this.tag.equals("area") && (string2 = ResourceHelper.getLinkText(methodElement, this.getElementLinkType())) != null) {
                    this.linkedText = string2;
                }
                if (this.validator.isDiscarded(this.ownerElement, null, methodElement)) {
                    this.isMissingReference = true;
                    this.validator.logMissingReference(this.ownerElement, methodElement);
                    methodElement = null;
                }
            }
            this.linkElement = methodElement;
        }
    }

    public static MethodElement getMethodElement(String string) {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        MethodElement methodElement = iLibraryManager != null && LinkInfo.getLibrary() == null ? iLibraryManager.getMethodElement(string) : LinkInfo.getMethodElement_(string);
        return methodElement;
    }

    private String getMissingElementUrl() {
        if (!this.isMissingReference) {
            return "";
        }
        String string = null;
        string = "pages_not_installed/pages_not_installed.html";
        File file = new File(this.pubDir, string);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        XmlElement xmlElement = new XmlElement("Element");
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        xmlElement.setAttribute("lang", string2);
        if (this.linkElement == null) {
            xmlElement.setAttribute("invalidLink", "true").setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute(LINK_ATTR_NAME, this.linkedText);
        } else {
            xmlElement.setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute("type", this.linkElement.getType().getName()).setAttribute(LINK_ATTR_NAME, this.linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)this.linkElement).getName());
        }
        String string3 = LayoutResources.getDefaultXslPath("page_not_installed", null);
        this.saveHtml(xmlElement, string3, file);
        return String.valueOf(ResourceHelper.getBackPath(this.ownerElement).replace(File.separatorChar, '/')) + string;
    }

    public void saveHtml(XmlElement xmlElement, String string, File file) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            Properties properties = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)string, (String)stringBuffer.toString(), (Properties)properties, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static MethodElement getMethodElement_(String string) {
        block4: {
            if (LinkInfo.getLibrary() != null) break block4;
            return null;
        }
        try {
            ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)LinkInfo.getLibrary().eResource().getResourceSet();
            if (iLibraryResourceSet != null) {
                return (MethodElement)iLibraryResourceSet.getEObject(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static MethodLibrary getLibrary() {
        return library;
    }

    public static void setLibrary(MethodLibrary methodLibrary) {
        library = methodLibrary;
    }
}

