/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public abstract class AbstractElementLayout
implements IElementLayout {
    public static final String TAG_REFERENCE = "reference";
    public static final String TAG_REFERENCELIST = "referenceList";
    protected ElementLayoutManager layoutManager;
    protected MethodElement element;
    protected MethodElement ownerElement;
    protected String url = null;
    protected String elementPath = "";
    protected String backPath = "";
    protected List layouts = null;
    protected MethodElement targetElement = null;
    protected boolean showElementLink = true;
    protected boolean debug = LibraryPlugin.getDefault().isDebugging();

    public void setContentTarget(MethodElement methodElement) {
        this.targetElement = methodElement;
    }

    public void setElementOwner(MethodElement methodElement) {
        this.ownerElement = methodElement;
    }

    public void setShowElementLink(boolean bl) {
        this.showElementLink = bl;
    }

    public abstract void init(ElementLayoutManager var1, MethodElement var2);

    protected void __init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        Object object;
        this.layoutManager = elementLayoutManager;
        this.element = methodElement;
        if (!ConfigurationHelper.isDescriptionElement(methodElement)) {
            if (!(methodElement instanceof MethodConfiguration || (object = LibraryUtil.getMethodPlugin((EObject)methodElement)) != null && object.eContainer() != null)) {
                if (this.debug && this.getLayoutMgr().isPublishingMode()) {
                    System.out.println("Error: Element without a valid container: " + LibraryUtil.getTypeName(methodElement));
                }
                LibraryUtil.getMethodPlugins(LibraryService.getInstance().getCurrentMethodLibrary());
            }
            this.buildPath();
            this.url = String.valueOf(this.elementPath) + this.getFileName(".html");
        }
        if (!(this.layoutManager.isPublishingMode() || methodElement instanceof ContentDescription || methodElement.eContainer() instanceof ContentDescription || methodElement instanceof MethodConfiguration)) {
            try {
                object = String.valueOf(this.layoutManager.getPublishDir()) + this.getFilePath() + this.getFileName(".html");
                File file = new File((String)object);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void setLayoutInfo(LayoutInfo layoutInfo) {
        if (this.layouts == null) {
            this.layouts = new ArrayList();
        }
        this.layouts.add(layoutInfo);
    }

    public List getLayouts() {
        return this.layouts;
    }

    public LayoutInfo getLayoutInfo(String string) {
        if (this.layouts == null || this.layouts.size() == 0) {
            return null;
        }
        for (LayoutInfo layoutInfo : this.layouts) {
            if (!layoutInfo.name.equals(string)) continue;
            return layoutInfo;
        }
        return null;
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.layoutManager;
    }

    public MethodElement getElement() {
        return this.element;
    }

    public String getType() {
        return this.element.getType().getName();
    }

    public String getName() {
        return this.element.getName();
    }

    public String getDisplayName() {
        return ConfigurationHelper.getPresentationName(this.element, this.getLayoutMgr().getConfiguration());
    }

    public String getId() {
        return this.element.getGuid();
    }

    public String getUrl() {
        return this.url;
    }

    public String getBackPath() {
        return this.backPath;
    }

    public String getFilePath() {
        return this.elementPath;
    }

    public String getFilePath(IElementLayout iElementLayout) {
        return String.valueOf(iElementLayout.getBackPath()) + this.getFilePath();
    }

    public String getFileName(String string) {
        return ResourceHelper.getFileName(this.element, string);
    }

    public String getXslUrl() {
        if (this.element instanceof ContentElement) {
            return LayoutResources.getXslUri(this.getType().toLowerCase(), "contentelement");
        }
        return LayoutResources.getXslUri(this.getType().toLowerCase(), null);
    }

    private void buildPath() {
        String string;
        this.elementPath = "";
        this.backPath = "./";
        if (!(this.element instanceof MethodConfiguration) && !(this.element instanceof MethodLibrary) && (string = ResourceHelper.getElementPath(this.element)) != null) {
            this.elementPath = string.replace(File.separatorChar, '/');
            this.backPath = ResourceHelper.getBackPath(this.element);
        }
    }

    public boolean needContentScan(String string) {
        return true;
    }

    protected IElementLayout getChildLayout(MethodElement methodElement) {
        return this.layoutManager.getLayout(methodElement, true);
    }

    protected void processChild(Object object, XmlElement xmlElement, MethodElement methodElement, boolean bl) {
        IElementLayout iElementLayout;
        if (methodElement != null && (iElementLayout = this.getChildLayout(methodElement)) != null) {
            boolean bl2;
            boolean bl3 = bl2 = methodElement instanceof MethodElement && ConfigurationHelper.isDescriptionElement(methodElement);
            if (bl2) {
                if (this.targetElement != null) {
                    iElementLayout.setContentTarget(this.targetElement);
                }
                iElementLayout.setElementOwner(this.element);
            }
            xmlElement.addChild(iElementLayout.getXmlElement(bl));
        }
    }

    protected void processChild(Object object, XmlElement xmlElement, List list, boolean bl) {
        if (list != null && list.size() > 0) {
            for (Object object2 : list) {
                IElementLayout iElementLayout;
                MethodElement methodElement;
                if (!(object2 instanceof MethodElement) || (object2 = ConfigurationHelper.getCalculatedElement(methodElement = (MethodElement)object2, this.layoutManager.getConfiguration())) == null || (iElementLayout = this.getChildLayout(methodElement)) == null) continue;
                xmlElement.addChild(iElementLayout.getXmlElement(ConfigurationHelper.isDescriptionElement(methodElement) ? true : bl));
            }
        }
    }

    public void calculate0nReferences(XmlElement xmlElement, boolean bl) {
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature.isMany()) {
                    this.loadFeature(eStructuralFeature, xmlElement, bl);
                }
                ++n;
            }
        }
    }

    protected XmlElement getXmlElement() {
        XmlElement xmlElement = new XmlElement("Element").setAttribute("Id", this.getId()).setAttribute("Type", this.getType()).setAttribute("TypeName", TngUtil.getTypeText((EObject)this.element)).setAttribute("Name", this.getName()).setAttribute("BackPath", this.getBackPath()).setAttribute("ShapeiconUrl", this.getShapeiconUrl()).setAttribute("DisplayName", this.getDisplayName());
        if (this.showElementLink) {
            xmlElement.setAttribute("Url", this.getUrl());
        }
        return xmlElement;
    }

    public void loadAttributes(XmlElement xmlElement) {
        boolean bl = this.element instanceof Activity || this.element instanceof ContentDescription && (this.element.eContainer() instanceof Activity || this.ownerElement instanceof Activity);
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)eStructuralFeature;
                    String string = eStructuralFeature.getName();
                    Object object = string.equals("presentationName") ? ConfigurationHelper.getPresentationName(this.element, this.layoutManager.getConfiguration()) : (bl && String.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass()) ? ConfigurationHelper.getActivityStringAttribute(this.element, this.ownerElement, eAttribute, this.getLayoutMgr().getConfiguration()) : this.getAttributeFeatureValue(eStructuralFeature));
                    if (string.equals("briefDescription") && object instanceof String) {
                        MultiFileXMISaveImpl.MyEscape myEscape = new MultiFileXMISaveImpl.MyEscape();
                        object = myEscape.convert((String)object);
                        object = StrUtil.convertNewlinesToHTML((String)((String)object));
                    }
                    xmlElement.newChild("attribute").setAttribute("name", string).setValue(object == null ? "" : object.toString());
                }
                ++n;
            }
        }
    }

    public Object getAttributeFeatureValue(EStructuralFeature eStructuralFeature) {
        Object object = ConfigurationHelper.calcAttributeFeatureValue(this.element, this.ownerElement, eStructuralFeature, this.layoutManager.getConfiguration());
        if (this.targetElement != null && object != null && object.toString().length() > 0) {
            String string = ResourceHelper.getElementPath(this.element instanceof ContentDescription ? (this.ownerElement == null ? (MethodElement)this.element.eContainer() : this.ownerElement) : this.element);
            String string2 = ResourceHelper.getBackPath(this.targetElement instanceof ContentDescription ? (MethodElement)this.targetElement.eContainer() : this.targetElement);
            object = ResourceHelper.fixContentUrlPath(object.toString(), string, string2);
        }
        return object;
    }

    public void loadCopyright(XmlElement xmlElement) {
        String string = ConfigurationHelper.getCopyrightText(this.element, this.layoutManager.getConfiguration());
        if (string != null && string.length() > 0) {
            xmlElement.newChild("copyright").setValue(string);
        }
    }

    public void calculate01References(XmlElement xmlElement, boolean bl) {
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                EClassifier eClassifier = eStructuralFeature.getEType();
                if (eClassifier instanceof EClass && !eStructuralFeature.isMany()) {
                    this.loadFeature(eStructuralFeature, xmlElement, bl);
                }
                ++n;
            }
        }
    }

    public void loadFeature(EStructuralFeature eStructuralFeature, XmlElement xmlElement, boolean bl) {
        List list;
        if (!(eStructuralFeature.getEType() instanceof EClass)) {
            return;
        }
        String string = eStructuralFeature.getName();
        if (!eStructuralFeature.isMany()) {
            MethodElement methodElement = ConfigurationHelper.calc01FeatureValue(this.element, this.ownerElement, eStructuralFeature, this.layoutManager.getElementRealizer());
            if (methodElement != null && methodElement != this.element) {
                boolean bl2;
                boolean bl3 = bl2 = ConfigurationHelper.isDescriptionElement(methodElement) ? true : bl;
                if (this.acceptFeatureValue(eStructuralFeature, (Object)methodElement)) {
                    this.processChild((Object)eStructuralFeature, xmlElement.newChild(TAG_REFERENCE).setAttribute("name", string), methodElement, bl2);
                }
            }
        } else if (eStructuralFeature.isMany() && this.acceptFeatureValue(eStructuralFeature, (Object)(list = ConfigurationHelper.calc0nFeatureValue(this.element, this.ownerElement, eStructuralFeature, this.layoutManager.getElementRealizer())))) {
            this.addReferences(eStructuralFeature, xmlElement, string, list);
        }
    }

    public void loadFeature(OppositeFeature oppositeFeature, XmlElement xmlElement, boolean bl) {
        List list;
        String string = oppositeFeature.getName();
        if (!oppositeFeature.isMany()) {
            MethodElement methodElement = ConfigurationHelper.calc01FeatureValue(this.element, oppositeFeature, this.layoutManager.getElementRealizer());
            if (methodElement != null && methodElement != this.element) {
                boolean bl2;
                boolean bl3 = bl2 = ConfigurationHelper.isDescriptionElement(methodElement) ? true : bl;
                if (this.acceptFeatureValue(oppositeFeature, (Object)methodElement)) {
                    this.processChild((Object)oppositeFeature, xmlElement.newChild(TAG_REFERENCE).setAttribute("name", string), methodElement, bl2);
                }
            }
        } else if (oppositeFeature.isMany() && this.acceptFeatureValue(oppositeFeature, (Object)(list = ConfigurationHelper.calc0nFeatureValue(this.element, oppositeFeature, this.layoutManager.getElementRealizer()))) && list.size() > 0) {
            this.addReferences(oppositeFeature, xmlElement, string, list);
        }
    }

    public void loadReferences(XmlElement xmlElement, boolean bl) {
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature.getEType() instanceof EClass) {
                    this.loadFeature(eStructuralFeature, xmlElement, bl);
                }
                ++n;
            }
        }
        ArrayList arrayList = new ArrayList(this.element.getOppositeFeatures());
        for (OppositeFeature oppositeFeature : arrayList) {
            this.loadFeature(oppositeFeature, xmlElement, bl);
        }
    }

    public void addReference(Object object, XmlElement xmlElement, String string, MethodElement methodElement) {
        this.processChild(object, xmlElement.newChild(TAG_REFERENCE).setAttribute("name", string), methodElement, false);
    }

    public void addReferences(Object object, XmlElement xmlElement, String string, List list) {
        this.processChild(object, xmlElement.newChild(TAG_REFERENCELIST).setAttribute("name", string), list, false);
    }

    public XmlElement getXmlElement(boolean bl) {
        XmlElement xmlElement = this.getXmlElement();
        if (bl) {
            this.loadCopyright(xmlElement);
            this.loadAttributes(xmlElement);
            this.loadReferences(xmlElement, false);
        }
        return xmlElement;
    }

    protected boolean acceptFeatureValue(EStructuralFeature eStructuralFeature, Object object) {
        return true;
    }

    protected boolean acceptFeatureValue(OppositeFeature oppositeFeature, Object object) {
        if (oppositeFeature == AssociationHelper.DescribableElement_CustomCategories) {
            if (object instanceof CustomCategory) {
                return this.getPublishCategoryProperty((MethodElement)object);
            }
            if (object instanceof List) {
                List list = (List)object;
                int n = 0;
                while (n < list.size()) {
                    MethodElement methodElement = (MethodElement)list.get(n);
                    if (!this.getPublishCategoryProperty(methodElement)) {
                        list.remove(n);
                        continue;
                    }
                    ++n;
                }
                return true;
            }
        }
        return true;
    }

    private boolean getPublishCategoryProperty(MethodElement methodElement) {
        MethodElementProperty methodElementProperty = TngUtil.getPublishCategoryProperty((MethodElement)methodElement);
        if (methodElementProperty == null) {
            return false;
        }
        String string = methodElementProperty.getValue();
        return string != null && string.toString().equals("true");
    }

    public String getShapeiconUrl() {
        URI uRI = null;
        if (this.element instanceof DescribableElement) {
            uRI = ((DescribableElement)this.element).getShapeicon();
        }
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(this.element);
        String string = uRI == null || iLibraryResourceManager == null ? this.getDefaultShapeiconUrl() : NetUtil.decodedFileUrl((String)uRI.toString());
        if (!string.startsWith("images/")) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)this.element);
            if (methodPlugin != null && !string.startsWith(methodPlugin.getName())) {
                string = NetUtil.encodeFileURL((String)(String.valueOf(methodPlugin.getName()) + "/" + string));
            }
            if (iLibraryResourceManager != null) {
                File file = new File(iLibraryResourceManager.resolve(this.element, string));
                File file2 = new File(this.getLayoutMgr().getPublishDir(), string);
                FileUtil.copyFile((File)file, (File)file2);
            }
        }
        return string;
    }

    public String getNodeiconUrl() {
        return "";
    }

    public String getDefaultShapeiconUrl() {
        return LayoutResources.getDefaultShapeiconUrl(this.element.getType().getName().toLowerCase());
    }

    public String getDiagramiconUrl() {
        return "icons/" + this.element.getType().getName() + ".gif";
    }

    protected void loadWorkOrder(XmlElement xmlElement) {
        EReference eReference = UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor();
        List list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)eReference, this.layoutManager.getElementRealizer());
        XmlElement xmlElement2 = xmlElement.newChild(TAG_REFERENCELIST).setAttribute("name", eReference.getName());
        if (list != null && list.size() > 0) {
            for (WorkOrder workOrder : list) {
                IElementLayout iElementLayout;
                MethodElement methodElement = ConfigurationHelper.calc01FeatureValue((MethodElement)workOrder, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkOrder_Pred(), this.layoutManager.getElementRealizer());
                if (methodElement == null || (iElementLayout = this.getChildLayout(methodElement)) == null) continue;
                xmlElement2.addChild(iElementLayout.getXmlElement(false));
            }
        }
    }

    protected void processDescriptors(XmlElement xmlElement) {
        Object object;
        Object object2;
        if (!this.getLayoutMgr().getValidator().showRelatedDescriptors()) {
            return;
        }
        OppositeFeature oppositeFeature = null;
        if (this.element instanceof Role) {
            oppositeFeature = AssociationHelper.Role_RoleDescriptors;
        } else if (this.element instanceof Task) {
            oppositeFeature = AssociationHelper.Task_TaskDescriptors;
        } else if (this.element instanceof WorkProduct) {
            oppositeFeature = AssociationHelper.WorkProduct_WorkProductDescriptors;
        }
        if (!this.getLayoutMgr().isPublishingMode() && (object2 = this.element.eResource().getResourceSet()) instanceof ILibraryResourceSet) {
            object = new ArrayList();
            HashSet<String> hashSet = new HashSet<String>();
            object.add(oppositeFeature);
            hashSet.add(this.element.getGuid());
            ((ILibraryResourceSet)object2).loadOppositeFeatures((List)object, hashSet);
        }
        object2 = ConfigurationHelper.calc0nFeatureValue(this.element, oppositeFeature, this.layoutManager.getElementRealizer());
        object = xmlElement.newChild(TAG_REFERENCELIST).setAttribute("name", "descriptors");
        int n = 0;
        while (n < object2.size()) {
            Descriptor descriptor = (Descriptor)object2.get(n);
            IElementLayout iElementLayout = this.getChildLayout((MethodElement)descriptor);
            XmlElement xmlElement2 = iElementLayout.getXmlElement(false);
            ((XmlElement)object).addChild(xmlElement2);
            List list = LibraryUtil.getSuperActivities((BreakdownElement)descriptor);
            int n2 = 0;
            while (n2 < list.size()) {
                Activity activity = (Activity)list.get(n2);
                iElementLayout = this.getChildLayout((MethodElement)activity);
                XmlElement xmlElement3 = iElementLayout.getXmlElement(false);
                xmlElement2.addChild(xmlElement3);
                ++n2;
            }
            ++n;
        }
    }
}

