/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;

public class ProcessLayout
extends AbstractElementLayout {
    public void init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        super.__init(elementLayoutManager, methodElement);
    }

    public XmlElement getXmlElement(boolean bl) {
        XmlElement xmlElement = super.getXmlElement();
        if (!bl) {
            return xmlElement;
        }
        XmlElement xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Work Breakdown Structure");
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        this.iterate(this.element, xmlElement2, composedAdapterFactory);
        xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Team Breakdown Structure");
        composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        this.iterate(this.element, xmlElement2, composedAdapterFactory);
        xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Work Product Breakdown Structure");
        composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        this.iterate(this.element, xmlElement2, composedAdapterFactory);
        return xmlElement;
    }

    private void iterate(Object object, XmlElement xmlElement, ComposedAdapterFactory composedAdapterFactory) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)composedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(iterator.next());
                IElementLayout iElementLayout = this.layoutManager.getLayout(methodElement, true);
                if (iElementLayout == null) continue;
                XmlElement xmlElement2 = iElementLayout.getXmlElement(false);
                xmlElement.addChild(xmlElement2);
                if (!(methodElement instanceof Activity)) continue;
                this.iterate(methodElement, xmlElement2, composedAdapterFactory);
            }
        }
    }
}

