/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDescriptorLayout
extends DescriptorLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromTask = Arrays.asList(UmaPackage.eINSTANCE.getTask_ToolMentors());

    @Override
    public void init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        super.__init(elementLayoutManager, methodElement);
    }

    @Override
    public XmlElement getXmlElement(boolean bl) {
        return super.getXmlElement(bl);
    }

    @Override
    public void loadReferences(XmlElement xmlElement, boolean bl) {
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()) {
                    this.processSteps(xmlElement, bl);
                } else if (eStructuralFeature == UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor()) {
                    super.loadWorkOrder(xmlElement);
                } else if (eStructuralFeature.getEType() instanceof EClass) {
                    this.loadFeature(eStructuralFeature, xmlElement, bl);
                }
                ++n;
            }
        }
        xmlElement.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        if (this.elementLayout != null && this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            for (EStructuralFeature eStructuralFeature : this.getExtraFeaturesFromContentElement()) {
                this.elementLayout.loadFeature(eStructuralFeature, xmlElement, false);
            }
        }
    }

    private void processSteps(XmlElement xmlElement, boolean bl) {
        List list;
        Object object;
        EReference eReference = UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps();
        String string = eReference.getName();
        if (this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            object = UmaPackage.eINSTANCE.getTask_Steps();
            list = ConfigurationHelper.calc0nFeatureValue(this.linkedElement, (EStructuralFeature)object, this.getLayoutMgr().getElementRealizer());
        } else {
            list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)eReference, this.getLayoutMgr().getElementRealizer());
        }
        object = xmlElement.newChild("referenceList").setAttribute("name", string);
        if (list != null && list.size() > 0) {
            for (Object object2 : list) {
                IElementLayout iElementLayout;
                MethodElement methodElement;
                if (!(object2 instanceof MethodElement) || (object2 = ConfigurationHelper.getCalculatedElement(methodElement = (MethodElement)object2, this.layoutManager.getConfiguration())) == null || (iElementLayout = this.layoutManager.getLayout(methodElement, true)) == null) continue;
                iElementLayout.setContentTarget(this.element);
                ((XmlElement)object).addChild(iElementLayout.getXmlElement(ConfigurationHelper.isDescriptionElement(methodElement) ? true : bl));
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        ArrayList<EStructuralFeature> arrayList = new ArrayList<EStructuralFeature>(extraFeaturesFromTask);
        arrayList.addAll(super.getExtraFeaturesFromContentElement());
        return arrayList;
    }
}

