/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.RichTextSelection;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.PastePlainTextAction;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichText
implements IRichText {
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private static final String ENCODED_NEWLINE = "%EOL%";
    private static final String STATUS_PREFIX = "$$$";
    private static final int STATUS_PREFIX_LENGTH = "$$$".length();
    private static final int STATUS_NOP = 0;
    private static final int STATUS_INITIALIZED = 1;
    private static final int STATUS_MODIFIED = 2;
    private static final int STATUS_GET_TEXT = 3;
    private static final int STATUS_KEY_DOWN = 4;
    private static final int STATUS_KEY_UP = 5;
    private static final int STATUS_SELECT_TEXT = 6;
    private static final int STATUS_SELECT_CONTROL = 7;
    private static final int STATUS_SELECT_NONE = 8;
    private static final int STATUS_EXEC_CMD = 9;
    private static final int STATUS_REFORMAT_LINKS = 10;
    private static final String DEFAULT_BASE_PATH = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "rte";
    protected boolean debug;
    protected Logger logger;
    protected Browser editor;
    protected Control editorControl;
    protected static URL copyURL;
    protected Menu contextMenu;
    protected String rteFolder;
    protected String rteURL;
    protected String basePath;
    protected boolean initialized;
    protected boolean initializedWithFocus;
    protected String initialText;
    protected String currentText;
    protected boolean editable;
    protected boolean modified;
    protected boolean hasSelection;
    protected RichTextSelection richTextSelection;
    protected int status;
    protected HTMLFormatter htmlFormatter;
    protected Map<Listener, RichTextListener> listeners;
    protected List<ModifyListener> modifyListeners;
    protected boolean notifyingModifyListeners;
    protected boolean hasFocus;
    protected boolean processingJSEvent;
    protected FindReplaceAction findReplaceAction;
    protected boolean isIE;

    public RichText(Composite composite, int n, String string) {
        block3: {
            this.currentText = "";
            this.editable = true;
            this.richTextSelection = new RichTextSelection();
            this.status = 0;
            this.notifyingModifyListeners = false;
            this.hasFocus = false;
            this.processingJSEvent = false;
            this.isIE = false;
            this.debug = RichTextPlugin.getDefault().isDebugging();
            this.logger = RichTextPlugin.getDefault().getLogger();
            this.findReplaceAction = new FindReplaceAction(this);
            this.rteFolder = String.valueOf(RichTextPlugin.getDefault().getInstallPath()) + "rte/";
            this.rteURL = XMLUtil.escape((String)("file://" + this.rteFolder));
            this.setBasePath(string);
            try {
                this.editor = new Browser(composite, 0);
                if (this.debug) {
                    this.printDebugMessage("RichText", "basePath=" + string);
                }
                this.editor.setLayoutData((Object)new GridData(1808));
                this.editor.setData("richText", (Object)this);
                this.init(composite, n);
            }
            catch (Exception exception) {
                this.editor = null;
                String string2 = "Failed to create RichText with basePath=" + string;
                this.logger.logError(string2, (Throwable)exception);
                if (!this.debug) break block3;
                System.out.println(string2);
                exception.printStackTrace();
            }
        }
    }

    public RichText(Composite composite, int n) {
        this(composite, n, null);
    }

    protected void setBasePath(String string) {
        this.basePath = string != null && string.length() > 0 ? (string.startsWith("\\\\") ? "\\\\" + FileUtil.appendSeparator((String)string.substring(FileUtil.UNC_PATH_PREFIX_LENGTH).replace('\\', '/'), (String)"/") : FileUtil.appendSeparator((String)string).replace('\\', '/')) : FileUtil.appendSeparator((String)DEFAULT_BASE_PATH).replace('\\', '/');
    }

    protected void init(Composite composite, int n) throws Exception {
        try {
            this.addStatusTextListener();
            if (this.debug) {
                this.printDebugMessage("init", "added status text listener");
            }
            String string = this.generateEditorHTML();
            if (this.debug) {
                this.printDebugMessage("init", "generated editor HTML");
            }
            this.editor.setText(string);
            if (this.debug) {
                this.printDebugMessage("init", "loaded editor HTML");
            }
            this.contextMenu = new Menu((Decorations)composite.getShell(), 8);
            this.editor.setMenu(this.contextMenu);
            this.fillContextMenu(this.contextMenu);
            if (this.debug) {
                this.printDebugMessage("init", "added context menu");
            }
            this.addListeners();
            if (this.debug) {
                this.printDebugMessage("init", "added listeners");
            }
            this.htmlFormatter = new HTMLFormatter();
            if (this.debug) {
                this.printDebugMessage("init", "instantiated HTMLFormatter");
            }
        }
        catch (Exception exception) {
            this.editor = null;
            this.dispose();
            throw exception;
        }
    }

    @Override
    public Control getControl() {
        return this.editor;
    }

    @Override
    public void setLayoutData(Object object) {
        if (this.editor != null) {
            this.editor.setLayoutData(object);
        }
    }

    @Override
    public Object getLayoutData() {
        if (this.editor != null) {
            return this.editor.getLayoutData();
        }
        return null;
    }

    @Override
    public void setFocus() {
        if (this.debug) {
            this.printDebugMessage("setFocus, editable=" + this.editable);
        }
        if (this.editor != null) {
            if (this.initialized) {
                if (!Platform.getOS().equals("win32")) {
                    this.editor.setFocus();
                }
                this.executeCommand("setFocus");
                this.hasFocus = true;
            } else {
                this.initializedWithFocus = true;
            }
        }
    }

    @Override
    public void setBlur() {
        if (this.debug) {
            this.printDebugMessage("setBlur, editable=" + this.editable);
        }
        if (this.editor != null) {
            if (this.initialized) {
                this.hasFocus = false;
            } else {
                this.initializedWithFocus = false;
            }
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.editor != null) {
            return this.hasFocus;
        }
        return false;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public URL getCopyURL() {
        return copyURL;
    }

    @Override
    public void setCopyURL() {
        try {
            copyURL = new File(this.basePath).toURL();
        }
        catch (Exception exception) {
            copyURL = null;
        }
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.initialized) {
            this.executeCommand("setEditable", "" + bl);
        }
    }

    @Override
    public boolean getModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.modified = bl;
    }

    @Override
    public String getText() {
        if (this.editor != null && this.initialized) {
            try {
                this.executeCommand("getText");
                if (this.currentText != null && this.currentText.length() > 0) {
                    this.currentText = this.currentText.replaceAll("<P>&nbsp;</P>", "<br/>");
                    this.currentText = this.tidyText(this.currentText);
                    this.currentText = this.formatHTML(this.currentText);
                } else {
                    this.currentText = "";
                }
                if (this.debug) {
                    this.printDebugMessage("getText", "text=", this.currentText);
                }
                return this.currentText;
            }
            catch (Exception exception) {
                this.logger.logError((Throwable)exception);
            }
        }
        return "";
    }

    protected String formatHTML(String string) {
        try {
            String string2 = this.htmlFormatter.formatHTML(string);
            if (this.htmlFormatter.getLastErrorStr() != null) {
                this.logger.logError(this.htmlFormatter.getLastErrorStr());
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.logError((Throwable)unsupportedEncodingException);
            return string;
        }
    }

    @Override
    public void setText(String string) {
        if (this.editor != null) {
            String string2;
            if (this.debug) {
                this.printDebugMessage("setText", "text=", string);
            }
            if ((string2 = string) != null) {
                string2 = this.tidyText(string2);
                string2 = this.formatHTML(string2);
            } else {
                string2 = "";
            }
            if (this.initialized) {
                this.modified = !string2.equals(this.currentText);
            }
            this.initialText = string2;
            if (this.initialText.equals("") && !this.isIE) {
                this.initialText = "<br />";
            }
            if (this.debug) {
                this.printDebugMessage("setText", "modified=" + this.modified + ", newText=", string2);
            }
            if (this.initialized) {
                try {
                    this.executeCommand("setText", string2);
                    this.executeCommand("setEditable", "" + this.editable);
                }
                catch (Exception exception) {
                    this.logger.logError((Throwable)exception);
                }
            }
            this.currentText = string2;
        }
    }

    @Override
    public void restoreText() {
        this.setText(this.initialText);
        this.modified = false;
    }

    public String getSelectedText() {
        return this.richTextSelection.getText();
    }

    @Override
    public RichTextSelection getSelected() {
        return this.richTextSelection;
    }

    @Override
    public Object getData(String string) {
        if (this.editor != null) {
            this.editor.getData(string);
        }
        return null;
    }

    @Override
    public void setData(String string, Object object) {
        if (this.editor != null) {
            this.editor.setData(string, object);
        }
    }

    protected int execute(final String string) {
        block6: {
            this.status = 0;
            if (this.editor != null && string != null && string.length() > 0) {
                try {
                    if (!this.isIE && this.processingJSEvent) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                RichText.this.editor.execute(string);
                            }
                        });
                    } else {
                        this.editor.execute(string);
                    }
                    if (this.debug) {
                        this.printDebugMessage("execute", string);
                    }
                }
                catch (Exception exception) {
                    String string2 = "Failed to execute " + string;
                    this.logger.logError(string2, (Throwable)exception);
                    if (!this.debug) break block6;
                    this.printDebugMessage("execute", string2);
                    exception.printStackTrace();
                }
            }
        }
        return this.status;
    }

    @Override
    public int executeCommand(String string) {
        this.status = 0;
        if (string != null && string.equals("clearContent")) {
            String string2 = this.initialText;
            this.setText("");
            this.initialText = string2;
            this.status = 1;
            this.modified = true;
            this.notifyModifyListeners();
        } else {
            this.status = this.execute(String.valueOf(string) + "();");
        }
        return this.status;
    }

    @Override
    public int executeCommand(String string, String string2) {
        if (string2 == null) {
            return this.executeCommand(string);
        }
        return this.execute(String.valueOf(string) + "('" + this.formatText(string2) + "');");
    }

    @Override
    public int executeCommand(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this.executeCommand(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('\'').append(this.formatText(stringArray[n2])).append('\'');
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        return this.execute(String.valueOf(string) + "(" + string2 + ");");
    }

    @Override
    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.modifyListeners != null) {
            this.modifyListeners.clear();
            this.modifyListeners = null;
        }
        if (this.htmlFormatter != null) {
            this.htmlFormatter = null;
        }
        if (this.findReplaceAction != null) {
            this.findReplaceAction.dispose();
            this.findReplaceAction = null;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    @Override
    public Iterator<ModifyListener> getModifyListeners() {
        return this.modifyListeners.iterator();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.editor != null) {
            this.editor.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.editor != null) {
            this.editor.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addModifyListener(ModifyListener modifyListener) {
        if (this.editor != null && modifyListener != null && !this.modifyListeners.contains(modifyListener)) {
            this.modifyListeners.add(modifyListener);
        }
    }

    @Override
    public void removeModifyListener(ModifyListener modifyListener) {
        if (this.editor != null && modifyListener != null && this.modifyListeners.contains(modifyListener)) {
            this.modifyListeners.remove(modifyListener);
        }
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        if (this.editor != null) {
            this.editor.addDisposeListener(disposeListener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        if (this.editor != null) {
            this.editor.removeDisposeListener(disposeListener);
        }
    }

    @Override
    public void addHelpListener(HelpListener helpListener) {
        if (this.editor != null) {
            this.editor.addHelpListener(helpListener);
        }
    }

    @Override
    public void removeHelpListener(HelpListener helpListener) {
        if (this.editor != null) {
            this.editor.removeHelpListener(helpListener);
        }
    }

    @Override
    public void addListener(int n, Listener listener) {
        if (this.editor != null && !this.listeners.containsKey(listener)) {
            if (n != 2 && (this.editorControl == null || n != 26 && n != 27 && n != 15 && n != 16)) {
                this.editor.addListener(n, listener);
            }
            this.listeners.put(listener, new RichTextListener(n, listener));
        }
    }

    @Override
    public void removeListener(int n, Listener listener) {
        if (this.editor != null && this.listeners.containsKey(listener)) {
            if (this.editorControl == null || n != 26 && n != 27 && n != 15 && n != 16) {
                this.editor.removeListener(n, listener);
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public Iterator<RichTextListener> getListeners() {
        return this.listeners.values().iterator();
    }

    protected void addStatusTextListener() {
        this.editor.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent statusTextEvent) {
                String string = statusTextEvent.text;
                int n = string.length();
                if (string.startsWith(RichText.STATUS_PREFIX) && n > STATUS_PREFIX_LENGTH) {
                    try {
                        try {
                            RichText.this.processingJSEvent = true;
                            int n2 = STATUS_PREFIX_LENGTH + 1;
                            if (string.length() > STATUS_PREFIX_LENGTH + 1 && Character.isDigit(string.charAt(n2))) {
                                ++n2;
                            }
                            int n3 = Integer.parseInt(string.substring(STATUS_PREFIX_LENGTH, n2));
                            switch (n3) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    if (!RichText.this.initialized) {
                                        RichText.this.initialized = true;
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("statusTextListener", "STATUS_INITIALIZED");
                                        }
                                        if (!Platform.getOS().equals("win32")) {
                                            RichText.this.executeCommand("setHeight", "" + RichText.this.editor.getBounds().height);
                                        }
                                        RichText.this.executeCommand("setText", RichText.this.currentText);
                                        if (RichText.this.initializedWithFocus) {
                                            RichText.this.setFocus();
                                        }
                                        if (!RichText.this.editable) {
                                            RichText.this.executeCommand("setEditable", "" + RichText.this.editable);
                                        }
                                    }
                                    break;
                                }
                                case 2: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_MODIFIED");
                                    }
                                    RichText.this.checkModify();
                                    break;
                                }
                                case 3: {
                                    RichText.this.currentText = n >= STATUS_PREFIX_LENGTH + 2 ? string.substring(STATUS_PREFIX_LENGTH + 2) : "";
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_GET_TEXT, currentText=", RichText.this.currentText);
                                    }
                                    break;
                                }
                                case 4: {
                                    if (n >= STATUS_PREFIX_LENGTH + 2) {
                                        String string2 = string.substring(STATUS_PREFIX_LENGTH + 2);
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_DOWN, cmd=" + string2);
                                        }
                                        if (string2.equals("copy")) {
                                            RichText.this.setCopyURL();
                                            break;
                                        }
                                        if (string2.equals("cut")) {
                                            RichText.this.setCopyURL();
                                            CutAction cutAction = new CutAction(RichText.this);
                                            cutAction.execute(RichText.this);
                                            break;
                                        }
                                        if (string2.equals("findText")) {
                                            RichText.this.getFindReplaceAction().execute(RichText.this);
                                            break;
                                        }
                                        if (string2.equals("paste")) {
                                            PasteAction pasteAction = new PasteAction(RichText.this);
                                            pasteAction.execute(RichText.this);
                                            break;
                                        }
                                        if (string2.equals("save")) {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().doSave(null);
                                            break;
                                        }
                                        if (string2.equals("saveAll")) {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
                                        }
                                    }
                                    break;
                                }
                                case 5: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_UP, modified=" + RichText.this.modified);
                                    }
                                    RichText.this.checkModify();
                                    break;
                                }
                                case 6: {
                                    if (n >= STATUS_PREFIX_LENGTH + 2) {
                                        String[] stringArray = string.substring(STATUS_PREFIX_LENGTH + 2).split("\\$", 5);
                                        try {
                                            RichText.this.richTextSelection.setFontName(stringArray[0]);
                                            RichText.this.richTextSelection.setFontSize(stringArray[1]);
                                            RichText.this.richTextSelection.setBlockStyle(stringArray[2]);
                                            RichText.this.richTextSelection.setFlags(Integer.parseInt(stringArray[3]));
                                            RichText.this.richTextSelection.setText(stringArray[4]);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            RichText.this.logger.logError((Throwable)numberFormatException);
                                        }
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("selectionStatusListener", "current selection is=" + RichText.this.richTextSelection);
                                        }
                                        RichText.this.hasSelection = true;
                                        if (RichText.this.hasFocus()) {
                                            RichText.this.notifyListeners(2, new Event());
                                        }
                                    } else {
                                        RichText.this.richTextSelection.setText("");
                                        RichText.this.hasSelection = false;
                                    }
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_TEXT, selectedText=", RichText.this.richTextSelection.getText());
                                    }
                                    break;
                                }
                                case 7: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_CONTROL, control selected");
                                    }
                                    RichText.this.hasSelection = true;
                                    break;
                                }
                                case 8: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_NONE, no selection");
                                    }
                                    RichText.this.hasSelection = false;
                                    break;
                                }
                                case 9: {
                                    if (n >= STATUS_PREFIX_LENGTH + 3) {
                                        try {
                                            RichText.this.status = Integer.parseInt(string.substring(STATUS_PREFIX_LENGTH + 2, STATUS_PREFIX_LENGTH + 3));
                                        }
                                        catch (Exception exception) {
                                            RichText.this.status = -1;
                                        }
                                    }
                                    if (RichText.this.debug && RichText.this.status != 1) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_EXEC_CMD, status=" + RichText.this.status);
                                    }
                                    break;
                                }
                                case 10: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_REFORMAT_LINKS");
                                    }
                                    if (Platform.getOS().equals("win32") && RichText.this.modified) {
                                        RichText.this.setText(RichText.this.getText());
                                        RichText.this.modified = true;
                                    }
                                    RichText.this.checkModify();
                                }
                            }
                        }
                        catch (Exception exception) {
                            RichText.this.processingJSEvent = false;
                        }
                    }
                    finally {
                        RichText.this.processingJSEvent = false;
                    }
                }
            }
        });
    }

    protected String generateEditorHTML() throws Exception {
        String string = this.basePath;
        if (string.startsWith("\\\\")) {
            string = string.replaceFirst("^\\\\\\\\", "\\\\\\\\\\\\\\\\");
        }
        string = XMLUtil.escape((String)("file://" + string.replaceAll("'", "\\\\'")));
        String string2 = this.rteURL.replaceAll("&apos;", "%27");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rte id=\"").append("rte").append("\" css=\"").append(String.valueOf(string2) + "rte.css").append("\" js=\"").append(String.valueOf(string2) + "rte.js").append("\" baseURL=\"").append(string).append("\"/>");
        StringWriter stringWriter = new StringWriter();
        XSLTProcessor.transform((String)(String.valueOf(this.rteFolder) + "rte.xsl"), (String)stringBuffer.toString(), (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected void fillContextMenu(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(RichTextResources.cutAction_text);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CutAction cutAction = new CutAction(RichText.this);
                cutAction.execute(RichText.this);
            }
        });
        final MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(RichTextResources.copyAction_text);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CopyAction copyAction = new CopyAction(RichText.this);
                copyAction.execute(RichText.this);
            }
        });
        final MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(RichTextResources.pasteAction_text);
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PasteAction pasteAction = new PasteAction(RichText.this);
                pasteAction.execute(RichText.this);
            }
        });
        final MenuItem menuItem4 = new MenuItem(menu, 8);
        menuItem4.setText(RichTextResources.pastePlainTextAction_text);
        menuItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PastePlainTextAction pastePlainTextAction = new PastePlainTextAction(RichText.this);
                pastePlainTextAction.execute(RichText.this);
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent menuEvent) {
            }

            public void menuShown(MenuEvent menuEvent) {
                RichText.this.getSelectedText();
                menuItem.setEnabled(RichText.this.editable && RichText.this.hasSelection);
                menuItem2.setEnabled(RichText.this.hasSelection);
                menuItem3.setEnabled(RichText.this.editable);
                menuItem4.setEnabled(RichText.this.editable);
            }
        });
    }

    protected void addListeners() {
        this.editorControl = this.getControlSite((Composite)this.editor);
        if (this.editorControl != null) {
            if (this.debug) {
                this.printDebugMessage("init", "editorControl=" + this.editorControl.getClass().getName());
            }
            this.isIE = true;
            this.editorControl.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("activateListener");
                    }
                    RichText.this.setFocus();
                    RichText.this.notifyListeners(26, event);
                }
            });
            this.editorControl.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("deactivateListener");
                    }
                    RichText.this.setBlur();
                    RichText.this.notifyListeners(27, event);
                }
            });
            this.editorControl.addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("focusInListener");
                    }
                    RichText.this.executeCommand("updateSelection");
                    RichText.this.notifyListeners(15, event);
                }
            });
            this.editorControl.addListener(2, new Listener(){

                public void handleEvent(Event event) {
                    int n = event.keyCode;
                    int n2 = event.stateMask;
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("keyUpListener", "keyCode=" + n + ", stateMask=" + n2 + ", editable=" + RichText.this.editable);
                    }
                    if ((n2 & 0x40000) > 0 || (n2 & 0x10000) > 0 || (n2 & 0x20000) > 0 && n == n2) {
                        return;
                    }
                    if (RichText.this.editable) {
                        switch (event.keyCode) {
                            case 9: 
                            case 0x1000001: 
                            case 0x1000002: 
                            case 0x1000003: 
                            case 0x1000004: 
                            case 0x1000005: 
                            case 0x1000006: 
                            case 0x1000007: 
                            case 0x1000008: {
                                return;
                            }
                        }
                        RichText.this.checkModify();
                    }
                }
            });
            this.editor.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent locationEvent) {
                    locationEvent.doit = RichText.this.editable;
                }
            });
        } else {
            this.editor.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("activateListener");
                    }
                    RichText.this.setFocus();
                }
            });
            this.editor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.keyCode == 9) {
                        if ((keyEvent.stateMask & 0x20000) != 0) {
                            RichText.this.editor.traverse(8);
                        } else {
                            RichText.this.editor.traverse(16);
                        }
                        return;
                    }
                    if (!RichText.this.editable) {
                        keyEvent.doit = false;
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if ((keyEvent.stateMask & 0x40000) > 0 || (keyEvent.stateMask & 0x10000) > 0) {
                        return;
                    }
                    if (RichText.this.editable) {
                        switch (keyEvent.keyCode) {
                            case 9: 
                            case 131072: 
                            case 0x1000001: 
                            case 0x1000002: 
                            case 0x1000003: 
                            case 0x1000004: 
                            case 0x1000005: 
                            case 0x1000006: 
                            case 0x1000007: 
                            case 0x1000008: {
                                break;
                            }
                            default: {
                                RichText.this.checkModify();
                            }
                        }
                    }
                }
            });
        }
        this.editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (RichText.this.debug) {
                    RichText.this.printDebugMessage("disposeListener");
                }
                RichText.this.dispose();
            }
        });
        this.listeners = new Hashtable<Listener, RichTextListener>();
        this.modifyListeners = new ArrayList<ModifyListener>();
    }

    protected void notifyListeners(int n, Event event) {
        if (this.notifyingModifyListeners) {
            return;
        }
        if (this.listeners != null) {
            event.display = Display.getCurrent();
            event.widget = this.editor;
            for (RichTextListener richTextListener : this.listeners.values()) {
                if (richTextListener.getEventType() != n) continue;
                if (this.debug) {
                    this.printDebugMessage("notifyListeners", "notifying listener, " + richTextListener + ", eventType=" + n);
                }
                richTextListener.getListener().handleEvent(event);
                if (!this.debug) continue;
                this.printDebugMessage("notifyListeners", "notified listener, " + richTextListener + ", eventType=" + n);
            }
        }
    }

    @Override
    public void notifyModifyListeners() {
        this.notifyingModifyListeners = true;
        Event event = new Event();
        event.display = Display.getCurrent();
        event.widget = this.editor;
        for (ModifyListener modifyListener : this.modifyListeners) {
            if (this.debug) {
                this.printDebugMessage("notifyModifyListeners", "notifying listener, " + modifyListener);
            }
            modifyListener.modifyText(new ModifyEvent(event));
            if (!this.debug) continue;
            this.printDebugMessage("notifyModifyListeners", "notified listener, " + modifyListener);
        }
        this.notifyingModifyListeners = false;
    }

    @Override
    public void checkModify() {
        if (this.modified) {
            this.notifyModifyListeners();
        } else if (!this.isIE && this.processingJSEvent) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!RichText.this.getText().equals(RichText.this.initialText)) {
                        RichText.this.modified = true;
                        RichText.this.notifyModifyListeners();
                    }
                }
            });
        } else if (!this.getText().equals(this.initialText)) {
            this.modified = true;
            this.notifyModifyListeners();
        }
        if (this.debug) {
            this.printDebugMessage("checkModify", "modified=" + this.modified);
        }
    }

    protected String tidyText(String string) {
        return string;
    }

    protected String formatText(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    break;
                }
                case '\t': {
                    stringBuffer.append(' ');
                    break;
                }
                case '\n': {
                    stringBuffer.append(ENCODED_NEWLINE);
                    break;
                }
                case '\'': {
                    stringBuffer.append(ENCODED_SINGLE_QUOTE);
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected Control getControlSite(Composite composite) {
        if (Platform.getOS().equals("win32")) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                String string = controlArray[n].getClass().getName();
                if (string.equals("org.eclipse.swt.browser.WebSite")) {
                    return controlArray[n];
                }
                if (controlArray[n] instanceof Composite) {
                    return this.getControlSite((Composite)controlArray[n]);
                }
                ++n;
            }
        }
        return null;
    }

    protected void printDebugMessage(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RichText[").append(this.editor.handle).append(']').append('.').append(string);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(": ").append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append('\n').append(string3);
        }
        System.out.println(stringBuffer);
    }

    protected void printDebugMessage(String string, String string2) {
        this.printDebugMessage(string, string2, null);
    }

    protected void printDebugMessage(String string) {
        this.printDebugMessage(string, null);
    }

    @Override
    public FindReplaceAction getFindReplaceAction() {
        return this.findReplaceAction;
    }

    @Override
    public void setFindReplaceAction(FindReplaceAction findReplaceAction) {
        if (findReplaceAction != null) {
            if (this.findReplaceAction != null && this.findReplaceAction != findReplaceAction) {
                this.findReplaceAction.dispose();
            }
            this.findReplaceAction = findReplaceAction;
            this.findReplaceAction.setRichText(this);
        }
    }

    @Override
    public void setInitialText(String string) {
        this.setText(string);
        this.initialText = string == null ? "" : string;
        this.modified = false;
    }
}

