/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.RAMFile;

class RAMInputStream
extends BufferedIndexInput
implements Cloneable {
    private RAMFile file;
    private int pointer = 0;
    private long length;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
    }

    public void readInternal(byte[] dest, int destOffset, int len) {
        int bytesToCopy;
        int start = this.pointer;
        for (int remainder = len; remainder != 0; remainder -= bytesToCopy) {
            int bufferNumber = start / 1024;
            int bufferOffset = start % 1024;
            int bytesInBuffer = 1024 - bufferOffset;
            bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += bytesToCopy;
        }
        this.pointer += len;
    }

    public void close() {
    }

    public void seekInternal(long pos) {
        this.pointer = (int)pos;
    }

    public long length() {
        return this.length;
    }
}

