/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.export.msp.ui.ExportMSPUIResources;
import org.eclipse.epf.export.msp.ui.preferences.ExportMSPUIPreferences;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SelectExportOptionsPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectExportOptionsPage.class.getName();
    protected Composite composite;
    protected Composite configComposite;
    protected Text processText;
    protected Combo configCombo;
    protected Composite optionsComposite;
    protected Button publishWebSiteRadioButton;
    protected Composite publishOptionsComposite;
    protected Button publishConfigRadioButton;
    protected Button publishProcessRadioButton;
    protected Button exportOnlyPlannedWBSElementsCheckBox;

    public SelectExportOptionsPage(String string) {
        super(string);
        this.setTitle(ExportMSPUIResources.selectExportOptionsWizardPage_title);
        this.setDescription(ExportMSPUIResources.selectExportOptionsWizardPage_text);
        this.setImageDescriptor(ExportMSPUIPlugin.getDefault().getImageDescriptor("full/wizban/ExportMSProject.gif"));
    }

    public SelectExportOptionsPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.composite = SelectExportOptionsPage.createGridLayoutComposite((Composite)composite, (int)1);
        this.configComposite = SelectExportOptionsPage.createGridLayoutComposite((Composite)this.composite, (int)2);
        SelectExportOptionsPage.createLabel((Composite)this.configComposite, (String)ExportMSPUIResources.selectedProcessLabel_text);
        this.processText = SelectExportOptionsPage.createText((Composite)this.configComposite, (String)"");
        SelectExportOptionsPage.createLabel((Composite)this.configComposite, (String)ExportMSPUIResources.configurationLabel_text);
        this.configCombo = new Combo(this.configComposite, 2056);
        this.configCombo.setLayoutData((Object)new GridData(768));
        this.optionsComposite = SelectExportOptionsPage.createGridLayoutComposite((Composite)this.composite, (int)1);
        this.publishWebSiteRadioButton = SelectExportOptionsPage.createCheckbox((Composite)this.optionsComposite, (String)ExportMSPUIResources.publishWebSiteCheckBox_text);
        this.publishOptionsComposite = SelectExportOptionsPage.createGridLayoutComposite((Composite)this.optionsComposite, (int)1);
        GridLayout gridLayout = (GridLayout)this.publishOptionsComposite.getLayout();
        gridLayout.marginTop = -5;
        gridLayout.marginLeft = 12;
        this.publishConfigRadioButton = SelectExportOptionsPage.createRadioButton((Composite)this.publishOptionsComposite, (String)ExportMSPUIResources.publishConfigButton_text);
        this.publishProcessRadioButton = SelectExportOptionsPage.createRadioButton((Composite)this.publishOptionsComposite, (String)ExportMSPUIResources.publishProcessButton_text);
        this.exportOnlyPlannedWBSElementsCheckBox = SelectExportOptionsPage.createCheckbox((Composite)this.optionsComposite, (String)ExportMSPUIResources.exportOnlyPlannedElementsCheckBox_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        if (ExportMSPUIPreferences.getPublishWebSite()) {
            this.publishWebSiteRadioButton.setSelection(true);
        }
        boolean bl = ExportMSPUIPreferences.getPublishConfiguration();
        this.publishConfigRadioButton.setSelection(bl);
        this.publishProcessRadioButton.setSelection(!bl);
        this.updatePublishOptionsButtons();
        this.exportOnlyPlannedWBSElementsCheckBox.setSelection(ExportMSPUIPreferences.getExportOnlyPlannedWBSElements());
    }

    protected void addListeners() {
        this.configCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SelectExportOptionsPage.this.setPageComplete(SelectExportOptionsPage.this.isPageComplete());
            }
        });
        this.publishWebSiteRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectExportOptionsPage.this.updatePublishOptionsButtons();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    protected void updateConfigCombo(Process process) {
        String[] stringArray = LibraryServiceUtil.getContexts((Process)process);
        this.configCombo.setItems(stringArray);
        String string = process.getDefaultContext().getName();
        this.configCombo.setText(string);
    }

    protected void updatePublishOptionsButtons() {
        boolean bl = this.getPublishWebSiteSelection();
        this.publishConfigRadioButton.setEnabled(bl);
        this.publishProcessRadioButton.setEnabled(bl);
        this.setPageComplete(this.isPageComplete());
    }

    public void onEnterPage(Object object) {
        if (object != null && object instanceof Process) {
            Process process = (Process)object;
            this.processText.setText(process.getName());
            this.updateConfigCombo(process);
        }
    }

    public boolean isPageComplete() {
        MethodConfiguration methodConfiguration = this.getMethodConfiguration();
        if (methodConfiguration == null) {
            return false;
        }
        if (this.getPublishWebSiteSelection() && methodConfiguration.getProcessViews().size() == 0) {
            this.setErrorMessage(PublishingUIResources.missingViewError_msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Object getNextPageData() {
        return this.getMethodConfiguration();
    }

    public IWizardPage getNextPage() {
        IWizardPage iWizardPage = null;
        iWizardPage = this.getPublishWebSiteSelection() ? super.getNextPage() : super.getNextPage().getNextPage();
        return iWizardPage;
    }

    public MethodConfiguration getMethodConfiguration() {
        String string = this.configCombo.getText().trim();
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        return LibraryServiceUtil.getMethodConfiguration((MethodLibrary)methodLibrary, (String)string);
    }

    public boolean getPublishWebSiteSelection() {
        return this.publishWebSiteRadioButton.getSelection();
    }

    public boolean getPublishConfigSelection() {
        return this.publishConfigRadioButton.getSelection();
    }

    public boolean getPublishProcessSelection() {
        return this.publishProcessRadioButton.getSelection();
    }

    public boolean getExportOnlyPlannedWBSElementsSelection() {
        return this.exportOnlyPlannedWBSElementsCheckBox.getSelection();
    }

    public void dispose() {
        ExportMSPUIPreferences.setPublishWebSite(this.getPublishWebSiteSelection());
        ExportMSPUIPreferences.setPublishConfiguration(this.getPublishConfigSelection());
        ExportMSPUIPreferences.setExportOnlyPlannedWBSElements(this.getExportOnlyPlannedWBSElementsSelection());
        MethodConfiguration methodConfiguration = this.getMethodConfiguration();
        if (methodConfiguration != null) {
            ExportMSPUIPreferences.setConfigurationName(methodConfiguration.getName());
        }
        super.dispose();
    }
}

