/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishConfigOperation
implements IRunnableWithProgress {
    private static final String PUBLISH_CONFIG_ERROR_TITLE = PublishingUIResources.publishConfigDialog_title;
    private static final String PUBLISH_CONFIG_ERROR_MSG = PublishingUIResources.publishConfigError_msg;
    private static final String PUBLISH_CONFIG_ERROR_REASON = PublishingUIResources.publishConfigError_reason;
    private static final String PREVIEW_CONFIG_ERROR_TITLE = PublishingUIResources.previewConfigError_title;
    private static final String PREVIEW_CONFIG_ERROR_MSG = PublishingUIResources.previewConfigError_msg;
    private static final String VIEW_REPORT_ERROR_TITLE = PublishingUIResources.viewReportError_title;
    private static final String VIEW_REPORT_ERROR_MSG = PublishingUIResources.viewReportError_msg;
    private static final String OPEN_BROWSER_ERROR_REASON = PublishingUIResources.openBrowserError_reason;
    private static final String PUBLISH_CONFIG_CANCEL_MSG = PublishingUIResources.cancelPublishConfig_msg;
    private AbstractPublishManager publishMgr;
    private String published_url;
    private String report_url;
    private MsgDialog msgDialog;
    private Exception runException;

    public PublishConfigOperation(AbstractPublishManager abstractPublishManager) {
        this.publishMgr = abstractPublishManager;
        this.msgDialog = PublishingUIPlugin.getDefault().getMsgDialog();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.publishMgr.getViewBuilder();
    }

    public String getPublishedUrl() {
        return this.published_url;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        this.runException = null;
        try {
            iProgressMonitor.setTaskName(PublishingResources.publishingConfigurationTask_name);
            this.publishMgr.publish(iProgressMonitor);
            this.published_url = this.publishMgr.getPublishedUrl();
            this.report_url = this.publishMgr.getPublishReportUrl();
        }
        catch (Exception exception) {
            this.runException = exception;
        }
        final boolean bl = iProgressMonitor.isCanceled();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String string;
                if (bl) {
                    PublishConfigOperation.this.msgDialog.displayInfo(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_CANCEL_MSG);
                    return;
                }
                if (PublishConfigOperation.this.published_url == null || PublishConfigOperation.this.report_url == null) {
                    PublishConfigOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishConfigOperation.this.runException);
                    return;
                }
                PublishOptions publishOptions = PublishConfigOperation.this.publishMgr.getViewBuilder().getOptions();
                if (publishOptions instanceof PublishHTMLOptions && !((PublishHTMLOptions)publishOptions).isPublishDynamicWebApp() && !PublishConfigOperation.this.openBrowser(PublishConfigOperation.this.published_url)) {
                    string = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishConfigOperation.this.published_url);
                    PublishConfigOperation.this.msgDialog.displayError(PREVIEW_CONFIG_ERROR_TITLE, PREVIEW_CONFIG_ERROR_MSG, string);
                }
                if (!PublishConfigOperation.this.openBrowser(PublishConfigOperation.this.report_url)) {
                    string = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishConfigOperation.this.report_url);
                    PublishConfigOperation.this.msgDialog.displayError(VIEW_REPORT_ERROR_TITLE, VIEW_REPORT_ERROR_MSG, string);
                }
            }
        });
    }

    public boolean openBrowser(final String string) {
        boolean bl = false;
        try {
            if (SWT.getPlatform().equals("win32")) {
                bl = Program.launch((String)string);
            } else {
                bl = true;
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = new Shell();
                        shell.setText(string);
                        GridLayout gridLayout = new GridLayout();
                        gridLayout.marginHeight = 0;
                        gridLayout.marginWidth = 0;
                        shell.setLayout((Layout)gridLayout);
                        Browser browser = new Browser((Composite)shell, 0);
                        browser.setLayoutData((Object)new GridData(1808));
                        browser.setUrl(string);
                        shell.open();
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

