/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class PublishingOperation
implements IRunnableWithProgress {
    private static final String PUBLISH_CONFIG_ERROR_TITLE = PublishingUIResources.publishConfigDialog_title;
    private static final String PUBLISH_CONFIG_ERROR_MSG = PublishingUIResources.publishConfigError_msg;
    private static final String PUBLISH_CONFIG_ERROR_REASON = PublishingUIResources.publishConfigError_reason;
    private static final String PREVIEW_CONFIG_ERROR_TITLE = PublishingUIResources.previewConfigError_title;
    private static final String PREVIEW_CONFIG_ERROR_MSG = PublishingUIResources.previewConfigError_msg;
    private static final String VIEW_REPORT_ERROR_TITLE = PublishingUIResources.viewReportError_title;
    private static final String VIEW_REPORT_ERROR_MSG = PublishingUIResources.viewReportError_msg;
    private static final String OPEN_BROWSER_ERROR_REASON = PublishingUIResources.openBrowserError_reason;
    private static final String PUBLISH_CONFIG_CANCEL_MSG = PublishingUIResources.cancelPublishConfig_msg;
    private AbstractPublishManager publishMgr;
    private String published_url;
    private String report_url;
    private MsgDialog msgDialog;
    private Exception runException;

    public PublishingOperation(AbstractPublishManager abstractPublishManager) {
        this.publishMgr = abstractPublishManager;
        this.msgDialog = PublishingUIPlugin.getDefault().getMsgDialog();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.publishMgr.getViewBuilder();
    }

    public String getPublishedUrl() {
        return this.published_url;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            this._runIt(iProgressMonitor);
        }
        finally {
            this.publishMgr = null;
            this.msgDialog = null;
        }
    }

    private void _runIt(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        this.runException = null;
        try {
            iProgressMonitor.setTaskName(PublishingResources.publishingConfigurationTask_name);
            this.publishMgr.publish(iProgressMonitor);
            this.published_url = this.publishMgr.getPublishedUrl();
            this.report_url = this.publishMgr.getPublishReportUrl();
        }
        catch (Exception exception) {
            this.runException = exception;
        }
        final boolean bl = iProgressMonitor.isCanceled();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String string;
                if (bl) {
                    PublishingOperation.this.msgDialog.displayInfo(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_CANCEL_MSG);
                    return;
                }
                if (PublishingOperation.this.report_url == null) {
                    PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                    return;
                }
                PublishOptions publishOptions = PublishingOperation.this.publishMgr.getViewBuilder().getOptions();
                boolean bl2 = false;
                if (publishOptions instanceof PublishHTMLOptions && !((PublishHTMLOptions)publishOptions).isPublishDynamicWebApp()) {
                    bl2 = true;
                    if (PublishingOperation.this.published_url == null) {
                        PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                        return;
                    }
                }
                if (bl2 && !PublishingOperation.this.openBrowser(PublishingOperation.this.published_url)) {
                    string = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.published_url);
                    PublishingOperation.this.msgDialog.displayError(PREVIEW_CONFIG_ERROR_TITLE, PREVIEW_CONFIG_ERROR_MSG, string);
                }
                if (!PublishingOperation.this.openSWTBrowser(PublishingOperation.this.report_url)) {
                    string = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.report_url);
                    PublishingOperation.this.msgDialog.displayError(VIEW_REPORT_ERROR_TITLE, VIEW_REPORT_ERROR_MSG, string);
                }
            }
        });
    }

    public boolean openSWTBrowser(String string) {
        boolean bl = false;
        try {
            Shell shell = new Shell(Display.getDefault(), 1264);
            shell.setText(string);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            shell.setLayout((Layout)gridLayout);
            Browser browser = new Browser((Composite)shell, 0);
            browser.setLayoutData((Object)new GridData(4, 4, true, true));
            browser.setUrl(string);
            shell.open();
            bl = true;
        }
        catch (Exception exception) {
            PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return bl;
    }

    public boolean openBrowser(String string) {
        boolean bl;
        block7: {
            bl = false;
            try {
                if (SWT.getPlatform().equals("win32")) {
                    bl = Program.launch((String)string);
                    break block7;
                }
                bl = true;
                IWebBrowser iWebBrowser = null;
                IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    iWebBrowser = iWorkbenchBrowserSupport.getExternalBrowser();
                    if (iWebBrowser != null) {
                        URL uRL = new File(string).toURL();
                        iWebBrowser.openURL(uRL);
                    }
                }
                catch (PartInitException partInitException) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
                }
                catch (MalformedURLException malformedURLException) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)malformedURLException);
                }
            }
            catch (Exception exception) {
                PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                bl = false;
            }
        }
        return bl;
    }
}

