/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectConfigPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectConfigPage.class.getName();
    protected Table table;
    protected TableViewer configViewer;
    protected Text briefDescText;
    protected List processViews;
    protected String selectedConfigName;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int n) {
            return super.getColumnText(object, n);
        }

        public Image getColumnImage(Object object, int n) {
            return super.getColumnImage(object, n);
        }
    };

    public SelectConfigPage() {
        super(PAGE_NAME);
        this.setTitle(PublishingUIResources.selectConfigWizardPage_title);
        this.setDescription(PublishingUIResources.selectConfigWizardPage_text);
        this.setImageDescriptor(PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = SelectConfigPage.createGridLayoutComposite((Composite)composite, (int)1);
        SelectConfigPage.createLabel((Composite)composite2, (String)PublishingUIResources.configLabel_text);
        this.table = new Table(composite2, 2560);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 120;
        gridData.widthHint = 280;
        this.table.setLayoutData((Object)gridData);
        this.configViewer = new TableViewer(this.table);
        SelectConfigPage.createLabel((Composite)composite2, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = SelectConfigPage.createMultiLineText((Composite)composite2, (String)"", (int)360, (int)80, (int)1);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
    }

    protected void initControls() {
        this.configViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.configViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        MethodConfiguration[] methodConfigurationArray = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(methodConfigurationArray));
        Collections.sort(arrayList, Comparators.DEFAULT_COMPARATOR);
        this.configViewer.setInput((Object)arrayList.toArray());
        if (methodConfigurationArray.length > 0) {
            this.table.select(0);
            this.setBriefDescription(methodConfigurationArray[0]);
        }
    }

    protected void addListeners() {
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (!structuredSelection.isEmpty()) {
                    Object[] objectArray = structuredSelection.toArray();
                    SelectConfigPage.this.setBriefDescription((MethodConfiguration)objectArray[0]);
                }
                SelectConfigPage.this.setPageComplete(SelectConfigPage.this.isPageComplete());
                SelectConfigPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        this.setErrorMessage(null);
        if (this.table.getSelectionCount() > 0) {
            TableItem[] tableItemArray = this.table.getSelection();
            this.selectedConfigName = tableItemArray[0].getText();
            MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)this.selectedConfigName);
            this.processViews = null;
            if (methodConfiguration != null) {
                this.processViews = this.getValidConfigViews(methodConfiguration);
            }
            if (this.processViews != null && this.processViews.size() > 0) {
                return true;
            }
            this.setErrorMessage(PublishingUIResources.missingViewError_msg);
        }
        return false;
    }

    public Object getNextPageData() {
        return this.getConfigName();
    }

    protected List<ContentCategory> getValidConfigViews(MethodConfiguration methodConfiguration) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<ContentCategory> arrayList = new ArrayList<ContentCategory>();
        for (ContentCategory contentCategory : methodConfiguration.getProcessViews()) {
            if (ConfigurationHelper.isContributor((VariabilityElement)contentCategory)) {
                string = PublishingUIResources.bind((String)PublishingUIResources.invalidViewContributorInfo_msg, (Object)contentCategory.getPresentationName());
                stringBuffer.append("\t").append(string).append(StrUtil.LINE_FEED);
                continue;
            }
            if ((contentCategory = (ContentCategory)ConfigurationHelper.getCalculatedElement((MethodElement)contentCategory, (MethodConfiguration)methodConfiguration)) == null) continue;
            if (arrayList.contains(contentCategory)) {
                string = PublishingUIResources.bind((String)PublishingUIResources.invalidViewSameViewInfo_msg, (Object)contentCategory.getPresentationName());
                stringBuffer.append("\t").append(string).append(StrUtil.LINE_FEED);
                continue;
            }
            arrayList.add(contentCategory);
        }
        if (stringBuffer.length() > 0) {
            string = PublishingUIResources.bind((String)PublishingUIResources.invalidViewsInfo_msg, (Object)methodConfiguration.getName());
            stringBuffer.insert(0, String.valueOf(string) + StrUtil.LINE_FEED + StrUtil.LINE_FEED);
            this.briefDescText.setText(stringBuffer.toString());
        }
        return arrayList;
    }

    public String getConfigName() {
        return this.selectedConfigName;
    }

    private void setBriefDescription(MethodConfiguration methodConfiguration) {
        this.briefDescText.setText(methodConfiguration.getBriefDescription());
    }

    protected class ConfigurationTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ConfigurationTableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            MethodConfiguration methodConfiguration = (MethodConfiguration)object;
            return methodConfiguration.getName();
        }
    }
}

