/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LibraryUIUtil {
    public static void updateShellTitle() {
        Shell shell;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (shell = iWorkbenchWindow.getShell()) != null) {
            String string = "";
            if (LibraryService.getInstance().getCurrentMethodLibrary() != null && (string = LibraryServiceUtil.getCurrentMethodLibraryPath()) == null) {
                string = LibraryService.getInstance().getCurrentMethodLibrary().getName();
            }
            String string2 = Platform.getProduct().getName();
            String string3 = NLS.bind((String)LibraryUIResources.application_title, (Object[])new Object[]{string2, string});
            shell.setText(string3);
        }
    }

    public static int displaySaveDirtyEditorsDialog() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null && iLibraryManager.isMethodLibraryModified()) {
            int n = MsgBox.prompt((String)LibraryUIResources.saveLibraryDialog_title, (String)LibraryUIResources.saveLibraryDialog_text, (int)448);
            switch (n) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                    }
                    catch (Exception exception) {
                        MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayError(LibraryUIResources.saveLibraryDialog_title, LibraryUIResources.saveLibraryError_msg, LibraryUIResources.error_reason, (Throwable)exception);
                    }
                    return 64;
                }
                case 128: {
                    iLibraryManager.discardMethodLibraryChanges();
                    return 128;
                }
                case 256: {
                    return 256;
                }
            }
        }
        return 256;
    }
}

