/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.preferences;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.util.DefaultValueManager;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUIPreferences {
    private static final String DEFAULT_LIBRARY_PATH = "defaultLibraryPath";
    private static final String SAVED_LIBRARY_PATH = "savedLibraryPath";
    private static final String PUBLISH_UNOPEN_ACTIVITY_DD = "publishUnopenActivityDetailDiagram";
    private static final String PREF_SWITCH_CONFIG = "switchConfigurationOnProcessActivate";
    private static final String PUBLISH_AD_FOR_ACTIVITY_EXTENSION = "publishActivityDiagramforActivityExtension";
    private static final String APPLICATION_SHORT_NAME = "appname";
    private static final String NEW_LIBRARY_PATHS = "newLibraryPaths";
    private static final String OPEN_LIBRARY_PATHS = "openLibraryPaths";
    private static final String OPEN_LIBRARY_URIS = "openLibraryURIs";
    private static final String WORK_BREAKDOWNELEMENT_OPTIONAL = "work_breakdownelement_optional";
    private static final String WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES = "work_breakdownelement_multiple_occurrances";
    private static final String WORK_BREAKDOWNELEMENT_PLANNED = "work_breakdownelement_planned";
    private static final String WORK_BREAKDOWNELEMENT_EVENT_DRIVEN = "work_breakdownelement_event_driven";
    private static final String WORK_BREAKDOWNELEMENT_ONGOING = "work_breakdownelement_multiple_ongoing";
    private static final String WORK_BREAKDOWNELEMENT_REPEATABLE = "work_breakdownelement_repeatable";
    private static final String DESCRIPTOR_OPTIONAL = "descriptor_optional";
    private static final String DESCRIPTOR_MULTIPLE_OCCURRANCES = "descriptor_multiple_occurrances";
    private static final String DESCRIPTOR_PLANNED = "descriptor_planned";
    private static final String DESCRIPTOR_EVENT_DRIVEN = "descriptor_event_driven";
    private static final String DESCRIPTOR_ONGOING = "descriptor_multiple_ongoing";
    private static final String DESCRIPTOR_REPEATABLE = "descriptor_repeatable";
    private static final String DEFAULT_LIBRARY_FOLDER_NAME = "Method Libraries";
    private static String defaultLibraryPath = null;
    private static IPreferenceStore prefStore = LibraryUIPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(DEFAULT_LIBRARY_PATH, LibraryUIPreferences.getInitialDefaultLibraryPath());
        prefStore.setDefault(SAVED_LIBRARY_PATH, "");
        prefStore.setDefault(PREF_SWITCH_CONFIG, "prompt");
        prefStore.setDefault(NEW_LIBRARY_PATHS, "");
        prefStore.setDefault(OPEN_LIBRARY_PATHS, "");
        prefStore.setDefault(OPEN_LIBRARY_URIS, "");
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_OPTIONAL, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_PLANNED, true);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_ONGOING, false);
        prefStore.setDefault(WORK_BREAKDOWNELEMENT_REPEATABLE, false);
        prefStore.setDefault(DESCRIPTOR_OPTIONAL, false);
        prefStore.setDefault(DESCRIPTOR_MULTIPLE_OCCURRANCES, false);
        prefStore.setDefault(DESCRIPTOR_PLANNED, false);
        prefStore.setDefault(DESCRIPTOR_EVENT_DRIVEN, false);
        prefStore.setDefault(DESCRIPTOR_ONGOING, false);
        prefStore.setDefault(DESCRIPTOR_REPEATABLE, false);
    }

    public static String getInitialDefaultLibraryPath() {
        if (defaultLibraryPath == null) {
            defaultLibraryPath = System.getProperty("user.home");
            String string = LibraryUIPreferences.getApplicationShortName();
            defaultLibraryPath = string != null && string.length() > 0 ? String.valueOf(defaultLibraryPath) + FileUtil.FILE_SEP + string + FileUtil.FILE_SEP + DEFAULT_LIBRARY_FOLDER_NAME : String.valueOf(defaultLibraryPath) + FileUtil.FILE_SEP + DEFAULT_LIBRARY_FOLDER_NAME;
        }
        return defaultLibraryPath;
    }

    public static String getDefaultLibraryPath() {
        return prefStore.getString(DEFAULT_LIBRARY_PATH);
    }

    public static void setDefaultLibraryPath(String string) {
        prefStore.setValue(DEFAULT_LIBRARY_PATH, string);
    }

    public static void setPublishUnopenActivitydd(boolean bl) {
        prefStore.setValue(PUBLISH_UNOPEN_ACTIVITY_DD, bl);
    }

    public static boolean getPublishUnopenActivitydd() {
        return prefStore.getBoolean(PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static void setPublishADForActivityExtension(boolean bl) {
        prefStore.setValue(PUBLISH_AD_FOR_ACTIVITY_EXTENSION, bl);
    }

    public static boolean getPublishADForActivityExtension() {
        return prefStore.getBoolean(PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
    }

    public static String getSwitchConfig() {
        return prefStore.getString(PREF_SWITCH_CONFIG);
    }

    public static void setSwitchConfig(String string) {
        prefStore.setValue(PREF_SWITCH_CONFIG, string);
    }

    public static String getSwitchConfigPreferenceKey() {
        return PREF_SWITCH_CONFIG;
    }

    public static String getSavedLibraryPath() {
        return prefStore.getString(SAVED_LIBRARY_PATH);
    }

    public static void setSavedLibraryPath(String string) {
        String string2 = string;
        if (string2.endsWith("library.xmi")) {
            string2 = FileUtil.getParentDirectory((String)string2);
        }
        prefStore.setValue(SAVED_LIBRARY_PATH, string2);
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }

    public static String getApplicationShortName() {
        return prefStore.getString(APPLICATION_SHORT_NAME);
    }

    public static String[] getNewLibraryPaths() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS);
    }

    public static List<String> getNewLibraryPathsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS);
    }

    public static void addNewLibraryPath(String string) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)NEW_LIBRARY_PATHS, (String)string, (String)LibraryUIPreferences.getDefaultLibraryPath());
    }

    public static String[] getOpenLibraryPaths() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS);
    }

    public static List<String> getOpenLibraryPathsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS);
    }

    public static void addOpenLibraryPath(String string) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_PATHS, (String)string, (String)LibraryUIPreferences.getDefaultLibraryPath());
    }

    public static String[] getOpenLibraryURIs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS);
    }

    public static List getOpenLibraryURIsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS);
    }

    public static void addOpenLibraryURI(String string) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)OPEN_LIBRARY_URIS, (String)string);
    }

    public static void saveAllPreferences() {
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }

    public static boolean getWorkBreakDownElementOptional() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_OPTIONAL);
    }

    public static void setWorkBreakdownElementOptional(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_OPTIONAL, bl);
    }

    public static boolean getWorkBreakDownElementMultipleOccurrances() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES);
    }

    public static void setWorkBreakdownElementMultipleOccurrances(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_MULTIPLE_OCCURRANCES, bl);
    }

    public static boolean getWorkBreakDownElementPlanned() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_PLANNED);
    }

    public static void setWorkBreakdownElementPlanned(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_PLANNED, bl);
    }

    public static boolean getWorkBreakDownElementEventDriven() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN);
    }

    public static void setWorkBreakdownElementEventDriven(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_EVENT_DRIVEN, bl);
    }

    public static boolean getWorkBreakDownElementOngoing() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_ONGOING);
    }

    public static void setWorkBreakdownElementOngoing(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_ONGOING, bl);
    }

    public static boolean getWorkBreakDownElementRepeatable() {
        return prefStore.getBoolean(WORK_BREAKDOWNELEMENT_REPEATABLE);
    }

    public static void setWorkBreakdownElementRepeatable(boolean bl) {
        prefStore.setValue(WORK_BREAKDOWNELEMENT_REPEATABLE, bl);
    }

    public static boolean getDescriptorOptional() {
        return prefStore.getBoolean(DESCRIPTOR_OPTIONAL);
    }

    public static void setDescriptorOptional(boolean bl) {
        prefStore.setValue(DESCRIPTOR_OPTIONAL, bl);
    }

    public static boolean getDescriptorMultipleOccurrances() {
        return prefStore.getBoolean(DESCRIPTOR_MULTIPLE_OCCURRANCES);
    }

    public static void setDescriptorMultipleOccurrances(boolean bl) {
        prefStore.setValue(DESCRIPTOR_MULTIPLE_OCCURRANCES, bl);
    }

    public static boolean getDescriptorPlanned() {
        return prefStore.getBoolean(DESCRIPTOR_PLANNED);
    }

    public static void setDescriptorPlanned(boolean bl) {
        prefStore.setValue(DESCRIPTOR_PLANNED, bl);
    }

    public static boolean getDescriptorEventDriven() {
        return prefStore.getBoolean(DESCRIPTOR_EVENT_DRIVEN);
    }

    public static void setDescriptorEventDriven(boolean bl) {
        prefStore.setValue(DESCRIPTOR_EVENT_DRIVEN, bl);
    }

    public static boolean getDescriptorOngoing() {
        return prefStore.getBoolean(DESCRIPTOR_ONGOING);
    }

    public static void setDescriptorOngoing(boolean bl) {
        prefStore.setValue(DESCRIPTOR_ONGOING, bl);
    }

    public static boolean getDescriptorRepeatable() {
        return prefStore.getBoolean(DESCRIPTOR_REPEATABLE);
    }

    public static void setDescriptorRepeatable(boolean bl) {
        prefStore.setValue(DESCRIPTOR_REPEATABLE, bl);
    }

    public static void applyDefaultValuesForBreakdownElementAttributes() {
        Object[] objectArray = new Object[]{new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), LibraryUIPreferences.getWorkBreakDownElementEventDriven()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), LibraryUIPreferences.getWorkBreakDownElementMultipleOccurrances()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), LibraryUIPreferences.getWorkBreakDownElementOngoing()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), LibraryUIPreferences.getWorkBreakDownElementOptional()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), LibraryUIPreferences.getWorkBreakDownElementPlanned()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), LibraryUIPreferences.getWorkBreakDownElementRepeatable()}};
        EClass[] eClassArray = new EClass[]{UmaPackage.eINSTANCE.getPhase(), UmaPackage.eINSTANCE.getIteration(), UmaPackage.eINSTANCE.getActivity(), UmaPackage.eINSTANCE.getMilestone()};
        Object[] objectArray2 = new Object[]{new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), LibraryUIPreferences.getDescriptorEventDriven()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), LibraryUIPreferences.getDescriptorMultipleOccurrances()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), LibraryUIPreferences.getDescriptorOngoing()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), LibraryUIPreferences.getDescriptorOptional()}, new Object[]{UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), LibraryUIPreferences.getDescriptorPlanned()}, new Object[]{UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), LibraryUIPreferences.getDescriptorRepeatable()}};
        EClass[] eClassArray2 = new EClass[]{UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getWorkProductDescriptor()};
        Object[] objectArray3 = new Object[]{new Object[]{eClassArray, objectArray}, new Object[]{eClassArray2, objectArray2}};
        int n = 0;
        while (n < objectArray3.length) {
            Object[] objectArray4 = (Object[])objectArray3[n];
            EClass[] eClassArray3 = (EClass[])objectArray4[0];
            Object[] objectArray5 = (Object[])objectArray4[1];
            int n2 = 0;
            while (n2 < objectArray5.length) {
                Object[] objectArray6 = (Object[])objectArray5[n2];
                EStructuralFeature eStructuralFeature = (EStructuralFeature)objectArray6[0];
                Object object = objectArray6[1];
                int n3 = 0;
                while (n3 < eClassArray3.length) {
                    EClass eClass = eClassArray3[n3];
                    DefaultValueManager.INSTANCE.setDefaultValue(eClass, eStructuralFeature, object);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

