/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.elements.SummaryPageLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.DefaultNodeIconResources;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationViewBuilder
extends AbstractViewBuilder {
    private static final String PREFIX_Reference_Workflows = "Reference_Workflows";
    private static final String PREFIX_Tasks = "Tasks";
    private static final String PREFIX_ResponsibleFor_Tasks = "Primarily_Performs";
    private static final String PREFIX_ParticipatesIn_Tasks = "Additionally_Performs";
    private static final String PREFIX_Performing_Roles = "Performing_Roles";
    private static final String PREFIX_Input_Work_Products = "Input_Work_Products";
    private static final String PREFIX_Output_Work_Products = "Output_Work_Products";
    private static final String PREFIX_Work_Products_Created = "Responsible_For";
    private static final String PREFIX_Work_Products_Modified = "Modifies";
    private static final String PREFIX_Responsible_Role = "Responsible_Role";
    private static final String PREFIX_Containing_Work_Product = "Containing_Work_Product";
    private static final String PREFIX_Contained_Work_Products = "Contained_Work_Products";
    private static final String PREFIX_Guidances = "Guidance";
    private static final String PREFIX_InputTo_Task = "Input_to";
    private static final String PREFIX_OutputOf_Task = "Output_from";
    private static final String ICON_FOLDER = DefaultNodeIconResources.getIconName("folder");
    private static final String NODE_Reference_Workflows = PublishingResources.referenceWorkflowsNode_text;
    private static final String NODE_Tasks = PublishingResources.taskNode_text;
    private static final String NODE_ResponsibleFor_Tasks = PublishingResources.primarilyPerformsNode_text;
    private static final String NODE_ParticipatesIn_Tasks = PublishingResources.additionallyPerformsNode_text;
    private static final String NODE_Performing_Roles = PublishingResources.performingRolesNode_text;
    private static final String NODE_Input_Work_Products = PublishingResources.inputWorkProductsNode_text;
    private static final String NODE_Output_Work_Products = PublishingResources.outputWorkProductsNode_text;
    private static final String NODE_Work_Products_Created = PublishingResources.responsibleForNode_text;
    private static final String NODE_Work_Products_Modified = PublishingResources.modifiesNode_text;
    private static final String NODE_Responsible_Role = PublishingResources.responsibleRoleNode_text;
    private static final String NODE_Containing_Work_Product = PublishingResources.containingWorkProductNode_text;
    private static final String NODE_Contained_Work_Products = PublishingResources.containedWorkProductsNode_text;
    private static final String NODE_Guidances = PublishingResources.guidanceNode_text;
    private static final String NODE_InputTo_Task = PublishingResources.inputToNode_text;
    private static final String NODE_OutputOf_Task = PublishingResources.outputFromNode_text;
    private static final String PROCESS_LAYOUT_DATA_FILE = "/scripts/processElementData.js";
    private static final Class ITreeItemContentProviderClass = ITreeItemContentProvider.class;
    protected static boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    protected AdapterFactory adapterFactory;
    protected IProgressMonitor monitor = null;
    protected EObjectComparator nameComparator = new EObjectComparator();
    protected Set elementUrls = new HashSet();

    public ConfigurationViewBuilder(ISiteGenerator iSiteGenerator) {
        super(iSiteGenerator);
    }

    @Override
    public List<Bookmark> buildViews(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
        long l = 0L;
        if (this.config != null) {
            ConfigurationFilter configurationFilter = new ConfigurationFilter(this.config, null, false);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configurationFilter);
            if (this.options != null && this.options.isPublishProcess()) {
                this.makeProcessClosure();
            }
            if (profiling) {
                l = System.currentTimeMillis();
            }
            List list = LibraryUtil.getValidViews((MethodConfiguration)this.config);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iProgressMonitor.isCanceled()) {
                    return null;
                }
                ContentCategory contentCategory = (ContentCategory)iterator.next();
                if (!ConfigurationHelper.canShow((MethodElement)contentCategory, (MethodConfiguration)this.config)) continue;
                Object object = LibraryUtil.unwrap((Object)contentCategory);
                Bookmark bookmark = this.createBookmark(this.monitor, object);
                if (contentCategory == this.config.getDefaultView()) {
                    this.defaultView = bookmark;
                }
                this.iterate(contentCategory, bookmark);
                if (bookmark.getChildCount() <= 0) continue;
                this.bookmarks.add(bookmark);
            }
            if (profiling) {
                System.out.println("Time taken to publish bookmarks: " + (System.currentTimeMillis() - l) + " ms");
            }
            if (iProgressMonitor.isCanceled()) {
                return null;
            }
        }
        if (profiling) {
            l = System.currentTimeMillis();
        }
        this.publishReferenceElements();
        if (profiling) {
            DebugTrace.print((Object)this, (String)"publishReferenceElements", (String)(String.valueOf(System.currentTimeMillis() - l) + " ms"));
        }
        if (iProgressMonitor.isCanceled()) {
            return null;
        }
        if (profiling) {
            l = System.currentTimeMillis();
        }
        this.saveElementUrls();
        if (profiling) {
            DebugTrace.print((Object)this, (String)"saveElementUrls", (String)(String.valueOf(System.currentTimeMillis() - l) + " ms"));
        }
        return this.bookmarks;
    }

    private void makeProcessClosure() {
        Object object;
        this.monitor.subTask(PublishingResources.buildingProcessClosureTask_name);
        List<Process> list = this.options.getProcesses();
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                this.makeProcessClosure(object.next());
                if (!this.monitor.isCanceled()) continue;
                return;
            }
        }
        this.getValidator().addClosureElements(this.getValidator().getPublishedElements());
        this.getValidator().addClosureElements(this.getValidator().getReferencedElements());
        object = new ArrayList(this.getValidator().getReferencedElements());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement = (MethodElement)iterator.next();
            if (methodElement instanceof ContentCategory) continue;
            super.publish(this.monitor, methodElement);
            if (!LibraryUtil.isProcess((EObject)methodElement)) continue;
            this.publishProcessLayout((Process)methodElement);
        }
        object.clear();
        for (MethodElement methodElement : this.getValidator().getReferencedElements()) {
            if (!(methodElement instanceof Guidance)) continue;
            object.add(methodElement);
        }
        if (object.size() > 0) {
            this.getValidator().addClosureElements((List)object);
        }
        this.getValidator().makeElementClosure();
    }

    private void makeProcessClosure(Process process) {
        ActivityLayout activityLayout;
        if (process == null) {
            return;
        }
        if (ConfigurationHelper.canShow((MethodElement)process, (MethodConfiguration)this.config)) {
            activityLayout = new ActivityLayout();
            activityLayout.init(this.getLayoutMgr(), (MethodElement)process, process, null);
            activityLayout.findAllLinkedElements();
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (ConfigurationHelper.isExtender((VariabilityElement)process) && ConfigurationHelper.inConfig((MethodElement)(activityLayout = (Process)process.getVariabilityBasedOnElement()), (MethodConfiguration)this.config)) {
            this.makeProcessClosure((Process)activityLayout);
        }
    }

    private void publishReferenceElements() {
        while (this.getValidator().getReferencedElements().size() > 0) {
            MethodElement methodElement = (MethodElement)this.getValidator().getReferencedElements().remove(0);
            try {
                long l;
                long l2;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (methodElement instanceof MethodPlugin || methodElement instanceof MethodPackage) continue;
                long l3 = System.currentTimeMillis();
                super.publish(this.monitor, methodElement);
                if (LibraryUtil.isProcess((EObject)methodElement)) {
                    this.publishProcessLayout((Process)methodElement);
                }
                if ((l2 = (l = System.currentTimeMillis()) - l3) < 5000L) continue;
                System.out.println("Published " + methodElement.getName() + ": " + l2 + " ms");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.getValidator().logError(methodElement, "Error publishing element", exception);
            }
        }
    }

    private void publishProcessLayout(final Process process) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ActivityLayout activityLayout = new ActivityLayout();
                    activityLayout.init(ConfigurationViewBuilder.this.getLayoutMgr(), (MethodElement)process, null, null);
                    ProcessLayoutData processLayoutData = new ProcessLayoutData(process.getGuid());
                    activityLayout.loadLayoutData(processLayoutData);
                    ConfigurationViewBuilder.this.printLayoutScript(processLayoutData);
                    processLayoutData.clear();
                }
                catch (Exception exception) {
                    ConfigurationViewBuilder.this.getValidator().logError((MethodElement)process, "Error publishing process specific layout data", exception);
                }
            }
        };
        Timer timer = new Timer();
        try {
            try {
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join(600000L);
                if (thread.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo((MethodElement)process, "publishing process specific layout data takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                timer.stop();
                this.getValidator().logInfo((MethodElement)process, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
            }
        }
        finally {
            timer.stop();
            this.getValidator().logInfo((MethodElement)process, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
        }
    }

    private void printLayoutScript(ProcessLayoutData processLayoutData) {
        File file = new File(this.getLayoutMgr().getPublishDir(), PROCESS_LAYOUT_DATA_FILE);
        PrintWriter printWriter = null;
        try {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
                printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                processLayoutData.print(printWriter);
            }
            catch (Exception exception) {
                this.getValidator().logError("unable to save process layout data", exception);
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    private void iterate(Object object, Bookmark bookmark) {
        try {
            if (this.monitor.isCanceled()) {
                return;
            }
            ITreeItemContentProvider iTreeItemContentProvider = null;
            iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
            if (iTreeItemContentProvider != null) {
                Collection collection = iTreeItemContentProvider.getChildren(object);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    Object e = iterator.next();
                    Object object2 = LibraryUtil.unwrap(e);
                    if (object2 instanceof MethodElement) {
                        String string;
                        MethodElement methodElement = (MethodElement)object2;
                        try {
                            ContentCategory contentCategory;
                            if (!ConfigurationHelper.canShow((MethodElement)methodElement, (MethodConfiguration)this.config) || (methodElement = ConfigurationHelper.getCalculatedElement((MethodElement)methodElement, (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                            if (methodElement instanceof Tool) {
                                this.buildToolSubTree((Tool)methodElement, bookmark);
                                continue;
                            }
                            if (methodElement instanceof Discipline) {
                                this.buildDisciplineSubTree((Discipline)methodElement, bookmark);
                                continue;
                            }
                            if (methodElement instanceof ContentCategory) {
                                contentCategory = (ContentCategory)methodElement;
                                string = this.createBookmark(this.monitor, contentCategory);
                                this.iterate(e, (Bookmark)string);
                                if (this.options.isPublishEmptyCategories() || string.getChildCount() > 0) {
                                    bookmark.addChild((Bookmark)string);
                                    this.discardEmptyCategory(contentCategory, false);
                                    continue;
                                }
                                this.discardEmptyCategory(contentCategory, true);
                                continue;
                            }
                            contentCategory = this.createBookmark(methodElement, bookmark);
                            if (this.buildSubTree(e, methodElement, (Bookmark)contentCategory)) continue;
                            this.iterate(e, (Bookmark)contentCategory);
                        }
                        catch (Exception exception) {
                            string = "Error building navigation tree for " + LibraryUtil.getTypeName((MethodElement)methodElement);
                            this.getHtmlBuilder().getValidator().logError(string, (Throwable)exception);
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    this.iterate(e, bookmark);
                }
            }
        }
        catch (Exception exception) {
            String string = "Error building navigation tree";
            this.getHtmlBuilder().getValidator().logError(string, (Throwable)exception);
            exception.printStackTrace();
        }
    }

    protected Bookmark createBookmark(Object object, Bookmark bookmark) {
        Bookmark bookmark2 = this.createBookmark(this.monitor, object);
        if (bookmark == null) {
            this.bookmarks.add(bookmark2);
        } else {
            bookmark.addChild(bookmark2);
        }
        return bookmark2;
    }

    private boolean buildSubTree(Object object, MethodElement methodElement, Bookmark bookmark) {
        if (methodElement instanceof Task) {
            this.buildTaskSubTree((Task)methodElement, bookmark);
        } else if (methodElement instanceof Role) {
            this.buildRoleSubTree((Role)methodElement, bookmark);
        } else if (methodElement instanceof WorkProduct) {
            this.buildWorkProductSubTree((WorkProduct)methodElement, bookmark);
        } else if (LibraryUtil.isProcess((EObject)methodElement)) {
            this.buildProcessSubTree(object, (Process)methodElement, bookmark);
        } else {
            return false;
        }
        return true;
    }

    private void buildItems(List list, Bookmark bookmark) {
        this.buildItems(list, bookmark, false);
    }

    private void buildItems(List list, Bookmark bookmark, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.monitor.isCanceled()) {
                return;
            }
            MethodElement methodElement = (MethodElement)iterator.next();
            if (ConfigurationHelper.isContainmentElement((Object)methodElement) && ConfigurationHelper.isContainerInList((MethodElement)methodElement, (List)list, (MethodConfiguration)this.config)) continue;
            this.buildItem(methodElement, bookmark, bl);
        }
    }

    private Bookmark buildItem(MethodElement methodElement, Bookmark bookmark, boolean bl) {
        if (this.monitor.isCanceled()) {
            return null;
        }
        Bookmark bookmark2 = null;
        MethodElement methodElement2 = ConfigurationHelper.getCalculatedElement((MethodElement)methodElement, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
        if (this.isVisible(methodElement2)) {
            bookmark2 = this.createBookmark(this.monitor, methodElement2);
            if (bookmark2 == null) {
                return bookmark2;
            }
            bookmark.addChild(bookmark2);
            if (bl && methodElement2 instanceof Artifact) {
                this.buildContainedArtifactsSubTree((Artifact)methodElement2, bookmark2, true);
            }
        }
        return bookmark2;
    }

    private Bookmark createFolderBookmark(MethodElement methodElement, Bookmark bookmark, String string, List list, boolean bl) {
        Bookmark bookmark2 = null;
        if (list.size() > 0) {
            SummaryPageLayout summaryPageLayout = new SummaryPageLayout(this.getHtmlBuilder().getLayoutManager(), methodElement, string, list);
            String string2 = summaryPageLayout.getUrl();
            this.getHtmlBuilder().generateHtml((IElementLayout)summaryPageLayout);
            bookmark2 = this.createBookmark(string, EcoreUtil.generateUUID(), string2, ICON_FOLDER, ICON_FOLDER, null);
            bookmark.addChild(bookmark2);
            if (bl) {
                this.buildItems(list, bookmark2);
            }
        }
        return bookmark2;
    }

    private Bookmark createFolderBookmark(MethodElement methodElement, Bookmark bookmark, String string, String string2, List list, boolean bl) {
        Bookmark bookmark2 = null;
        if (list.size() > 0) {
            SummaryPageLayout summaryPageLayout = new SummaryPageLayout(this.getHtmlBuilder().getLayoutManager(), methodElement, string, string2, list);
            String string3 = summaryPageLayout.getUrl();
            this.getHtmlBuilder().generateHtml((IElementLayout)summaryPageLayout);
            bookmark2 = this.createBookmark(string2, EcoreUtil.generateUUID(), string3, ICON_FOLDER, ICON_FOLDER, null);
            bookmark.addChild(bookmark2);
            if (bl) {
                this.buildItems(list, bookmark2);
            }
        }
        return bookmark2;
    }

    private Bookmark buildDisciplineSubTree(Discipline discipline, Bookmark bookmark) {
        MethodElement methodElement;
        Object object;
        Bookmark bookmark2;
        ArrayList arrayList;
        List list = this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getDiscipline_ReferenceWorkflows());
        ArrayList<MethodElement> arrayList2 = new ArrayList<MethodElement>();
        ArrayList<MethodElement> arrayList3 = new ArrayList<MethodElement>();
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)discipline, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            arrayList = iTreeItemContentProvider.getChildren((Object)discipline);
            bookmark2 = arrayList.iterator();
            while (bookmark2.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return null;
                }
                object = bookmark2.next();
                Object iterator2 = LibraryUtil.unwrap(object);
                if (iterator2 instanceof Task) {
                    methodElement = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)iterator2), (ElementRealizer)this.getLayoutMgr().getElementRealizer());
                    if (methodElement == null) continue;
                    arrayList2.add(methodElement);
                    continue;
                }
                if (!(iterator2 instanceof Discipline) || (methodElement = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)iterator2), (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                arrayList3.add(methodElement);
            }
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)discipline, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (!this.options.isPublishEmptyCategories() && list.size() + arrayList2.size() + arrayList.size() + arrayList3.size() == 0) {
            this.discardEmptyCategory((ContentCategory)discipline, true);
            return null;
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        bookmark2 = this.createBookmark(this.monitor, discipline);
        if (arrayList3.size() > 0) {
            for (Discipline discipline2 : arrayList3) {
                this.buildDisciplineSubTree(discipline2, bookmark2);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            Collections.sort(list, this.nameComparator);
            Collections.sort(arrayList2, this.nameComparator);
            Collections.sort(arrayList, this.nameComparator);
            this.buildItems(list, bookmark2);
            this.buildItems(arrayList2, bookmark2);
            this.buildItems(arrayList, bookmark2);
        } else {
            if (list.size() > 0) {
                object = this.createFolderBookmark((MethodElement)discipline, bookmark2, PREFIX_Reference_Workflows, NODE_Reference_Workflows, list, false);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return null;
                    }
                    methodElement = (Activity)iterator.next();
                    Bookmark bookmark3 = this.buildItem(methodElement, (Bookmark)object, false);
                    this.buildActivitySubTree(methodElement, (Activity)methodElement, bookmark3);
                }
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (arrayList2.size() > 0) {
                this.createFolderBookmark((MethodElement)discipline, bookmark2, PREFIX_Tasks, NODE_Tasks, arrayList2, true);
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (arrayList.size() > 0) {
                this.createFolderBookmark((MethodElement)discipline, bookmark2, PREFIX_Guidances, NODE_Guidances, arrayList, true);
            }
        }
        if (this.options.isPublishEmptyCategories() || bookmark2.getChildCount() > 0) {
            bookmark.addChild(bookmark2);
            this.discardEmptyCategory((ContentCategory)discipline, false);
        } else {
            this.discardEmptyCategory((ContentCategory)discipline, true);
        }
        return bookmark2;
    }

    private void buildActivitySubTree(Object object, Activity activity, Bookmark bookmark) {
        if (this.monitor.isCanceled()) {
            return;
        }
        new ArrayList();
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        ProcessElementItem processElementItem = new ProcessElementItem(object, (MethodElement)activity, activity.getGuid());
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = super.getLayoutMgr().getWBSAdapterFactory();
        Suppression suppression = new Suppression(process);
        this.iterateActivity(processElementItem, bookmark, (ComposedAdapterFactory)configurableComposedAdapterFactory, suppression);
    }

    private void buildToolSubTree(Tool tool, Bookmark bookmark) {
        if (this.monitor.isCanceled()) {
            return;
        }
        List list = this.calc0nFeatureValue((MethodElement)tool, (EStructuralFeature)UmaPackage.eINSTANCE.getTool_ToolMentors());
        if (this.options.isPublishEmptyCategories() || list.size() > 0) {
            Bookmark bookmark2 = this.createBookmark(tool, bookmark);
            this.buildItems(list, bookmark2);
            this.discardEmptyCategory((ContentCategory)tool, false);
        } else {
            this.discardEmptyCategory((ContentCategory)tool, true);
        }
    }

    private void buildTaskSubTree(Task task, Bookmark bookmark) {
        ArrayList arrayList = new ArrayList();
        List list = new ArrayList<Role>();
        Role role = (Role)this.calc01FeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy());
        if (role != null) {
            list.add(role);
        }
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()));
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)task, bookmark, PREFIX_Performing_Roles, NODE_Performing_Roles, list, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            list = new ArrayList();
            list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput()));
            list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput()));
            if (list.size() > 0) {
                this.createFolderBookmark((MethodElement)task, bookmark, PREFIX_Input_Work_Products, NODE_Input_Work_Products, list, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        if ((list = this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output())).size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)task, bookmark, PREFIX_Output_Work_Products, NODE_Output_Work_Products, list, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        list.clear();
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        list.addAll(this.calc0nFeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_ToolMentors()));
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)task, bookmark, PREFIX_Guidances, NODE_Guidances, list, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(arrayList, bookmark);
        }
    }

    private void buildRoleSubTree(Role role, Bookmark bookmark) {
        Bookmark bookmark2;
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        List list = this.calc0nFeatureValue((MethodElement)role, AssociationHelper.Role_Primary_Tasks);
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)role, bookmark, PREFIX_ResponsibleFor_Tasks, NODE_ResponsibleFor_Tasks, list, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree() && (list = this.calc0nFeatureValue((MethodElement)role, AssociationHelper.Role_Secondary_Tasks)).size() > 0) {
            this.createFolderBookmark((MethodElement)role, bookmark, PREFIX_ParticipatesIn_Tasks, NODE_ParticipatesIn_Tasks, list, true);
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        list = this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor());
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                bookmark2 = this.createFolderBookmark((MethodElement)role, bookmark, PREFIX_Work_Products_Created, NODE_Work_Products_Created, list, false);
                this.buildItems(list, bookmark2, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            list = this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_Modifies());
            if (list.size() > 0) {
                bookmark2 = this.createFolderBookmark((MethodElement)role, bookmark, PREFIX_Work_Products_Modified, NODE_Work_Products_Modified, list, false);
                this.buildItems(list, bookmark2, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        list.clear();
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        list.addAll(this.calc0nFeatureValue((MethodElement)role, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)role, bookmark, NODE_Guidances, list, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(arrayList, bookmark);
        }
    }

    private void buildWorkProductSubTree(WorkProduct workProduct, Bookmark bookmark) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        List list = this.calc0nFeatureValue((MethodElement)workProduct, AssociationHelper.WorkProduct_ResponsibleRoles);
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_Responsible_Role, NODE_Responsible_Role, list, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (workProduct instanceof Artifact) {
            Artifact artifact;
            if (!this.options.isPublishLightWeightTree()) {
                artifact = ((Artifact)workProduct).getContainerArtifact();
                if (artifact != null) {
                    list = new ArrayList();
                    list.add(artifact);
                    this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_Containing_Work_Product, NODE_Containing_Work_Product, list, true);
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
            }
            list = this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
            list.remove(workProduct);
            if (list.size() > 0) {
                if (this.options.isPublishLightWeightTree()) {
                    Collections.sort(list, this.nameComparator);
                    arrayList.addAll(list);
                } else {
                    artifact = this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_Contained_Work_Products, NODE_Contained_Work_Products, list, false);
                    this.buildItems(list, (Bookmark)artifact, true);
                }
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.isPublishLightWeightTree()) {
            list = new ArrayList<Artifact>();
            list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks));
            list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, AssociationHelper.WorkProduct_OptionalInputTo_Tasks));
            if (list.size() > 0) {
                this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_InputTo_Task, NODE_InputTo_Task, list, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            list = this.calc0nFeatureValue((MethodElement)workProduct, AssociationHelper.WorkProduct_OutputFrom_Tasks);
            if (list.size() > 0) {
                this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_OutputOf_Task, NODE_OutputOf_Task, list, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        list = new ArrayList();
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        list.addAll(this.calc0nFeatureValue((MethodElement)workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (list.size() > 0) {
            if (this.options.isPublishLightWeightTree()) {
                Collections.sort(list, this.nameComparator);
                arrayList.addAll(list);
            } else {
                this.createFolderBookmark((MethodElement)workProduct, bookmark, PREFIX_Guidances, NODE_Guidances, list, true);
            }
        }
        if (this.options.isPublishLightWeightTree()) {
            this.buildItems(arrayList, bookmark);
        }
    }

    private void buildContainedArtifactsSubTree(Artifact artifact, Bookmark bookmark, boolean bl) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList arrayList = this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        arrayList.remove(artifact);
        if (this.monitor.isCanceled()) {
            return;
        }
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Artifact artifact2 = (Artifact)iterator.next();
                this.buildItem((MethodElement)artifact2, bookmark, true);
            }
        }
        if (!bl) {
            return;
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)artifact, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (arrayList.size() > 0) {
            this.buildItems(arrayList, bookmark);
        }
    }

    private void iterateActivity(ProcessElementItem processElementItem, Bookmark bookmark, ComposedAdapterFactory composedAdapterFactory, Suppression suppression) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ITreeItemContentProvider iTreeItemContentProvider = null;
        Object object = processElementItem.rawItem;
        iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)composedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Object e = iterator.next();
                if (suppression.isSuppressed(e)) continue;
                MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(e);
                if (!this.options.showDescriptorsInNavigationTree && methodElement instanceof Descriptor) continue;
                ProcessElementItem processElementItem2 = new ProcessElementItem(e, methodElement, processElementItem);
                Bookmark bookmark2 = this.buildItem(processElementItem2.element, bookmark, false);
                if (bookmark2 == null) continue;
                bookmark2.setQueryString(processElementItem2.getQueryString());
                IBSItemProvider iBSItemProvider = null;
                iBSItemProvider = e instanceof IBSItemProvider ? (IBSItemProvider)e : (IBSItemProvider)composedAdapterFactory.adapt((Notifier)methodElement, ITreeItemContentProvider.class);
                String string = ProcessUtil.getAttribute((Object)methodElement, (String)"presentation_name", (Object)iBSItemProvider);
                bookmark2.setPresentationName(string);
                if (!(methodElement instanceof Activity)) continue;
                this.iterateActivity(processElementItem2, bookmark2, composedAdapterFactory, suppression);
            }
        }
    }

    private void buildProcessSubTree(Object object, Process process, Bookmark bookmark) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ProcessElementItem processElementItem = new ProcessElementItem(object, (MethodElement)process, process.getGuid());
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = super.getLayoutMgr().getWBSAdapterFactory();
        Suppression suppression = new Suppression(process);
        this.iterateActivity(processElementItem, bookmark, (ComposedAdapterFactory)configurableComposedAdapterFactory, suppression);
        if (this.monitor.isCanceled()) {
            return;
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Checklists()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Concepts()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Examples()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Guidelines()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_ReusableAssets()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Roadmaps()));
        arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_SupportingMaterials()));
        if (process instanceof DeliveryProcess) {
            DeliveryProcess cfr_ignored_0 = (DeliveryProcess)process;
            arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials()));
            arrayList.addAll(this.calc0nFeatureValue((MethodElement)process, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials()));
        }
        if (arrayList.size() > 0) {
            this.createFolderBookmark((MethodElement)process, bookmark, PREFIX_Guidances, NODE_Guidances, arrayList, true);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.adapterFactory = null;
        this.nameComparator = null;
        this.bookmarks.clear();
        this.elementUrls.clear();
    }

    @Override
    protected void elementPublished(IElementLayout iElementLayout, String string) {
        if (iElementLayout.getElement() instanceof ProcessElement) {
            ElementUrl elementUrl = new ElementUrl(iElementLayout.getElement().getGuid(), iElementLayout.getUrl(), iElementLayout.getDisplayName());
            this.elementUrls.add(elementUrl);
        }
    }

    private void saveElementUrls() {
        Object object2;
        XmlElement xmlElement = new XmlElement("ElementUrls");
        for (Object object2 : this.elementUrls) {
            xmlElement.newChild("elementUrl", ((ElementUrl)object2).guid).setAttribute("text", StrUtil.escape((String)((ElementUrl)object2).text)).setAttribute("url", StrUtil.escape((String)((ElementUrl)object2).url));
        }
        String string = PublishingUtil.getHtml(xmlElement, "xsl/elementUrls.xsl");
        object2 = new File(this.getLayoutMgr().getPublishDir(), PROCESS_LAYOUT_DATA_FILE);
        FileUtil.writeUTF8File((String)((File)object2).getAbsolutePath(), (String)string, (boolean)true);
    }

    class EObjectComparator
    implements Comparator {
        private EStructuralFeature pName = UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
        private EStructuralFeature name = UmaPackage.eINSTANCE.getNamedElement_Name();

        public int compare(Object object, Object object2) {
            if (object instanceof EObject && object2 instanceof EObject) {
                Object object3 = this.getValue(object);
                Object object4 = this.getValue(object2);
                if (object3 == null && object4 == null) {
                    return object.toString().compareTo(object2.toString());
                }
                if (object3 == null) {
                    return -1;
                }
                if (object4 == null) {
                    return 1;
                }
                return object3.toString().compareTo(object4.toString());
            }
            return object.toString().compareTo(object2.toString());
        }

        private Object getValue(Object object) {
            Object object2 = null;
            try {
                object2 = ((EObject)object).eGet(this.pName);
            }
            catch (Exception exception) {}
            if (object2 == null || object2.toString().length() == 0) {
                try {
                    object2 = ((EObject)object).eGet(this.name);
                }
                catch (Exception exception) {}
            }
            return object2;
        }
    }

    public class ElementUrl {
        String guid;
        String url;
        String text;

        public ElementUrl(String string, String string2, String string3) {
            this.guid = string;
            this.url = string2;
            this.text = string3;
        }
    }
}

